/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.broker.provisional.persistence;

import java.util.Map;

import org.eclipse.cosmos.dc.broker.provisional.datamodel.Group;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Groups;

public interface BrokerDatabase {
	
	public void init(Map<String, Object> initMap);
	
	public Groups getAllGroups() throws BrokerDatabaseException;
	
	public Group getGroup(String hostname, String groupName) throws BrokerDatabaseException;
	
	public Groups getGroupsByNamespace(String ns) throws BrokerDatabaseException;
	
	public boolean addGroup(Group newgroup) throws BrokerDatabaseException;
	
	public boolean deleteGroup(String hostname, String groupName) throws BrokerDatabaseException;
}
