/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dr.internal.web.ui;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.osgi.service.prefs.Preferences;

public class PreferenceInitializer extends AbstractPreferenceInitializer {

	public PreferenceInitializer() {
		super();
	}

	@Override
	public void initializeDefaultPreferences() {
		Preferences node = new DefaultScope().getNode(WebViewerActivator.PLUGIN_ID);
		
		node.put(WebViewerActivator.HOST_PREFERENCE, "127.0.0.1"); //$NON-NLS-1$
		node.put(WebViewerActivator.PORT_PREFERENCE, "3382"); //$NON-NLS-1$
		node.put(WebViewerActivator.DOJOPATH_PREFERENCE, ""); //$NON-NLS-1$
		node.put(WebViewerActivator.DOJOBASEPATH_PREFERENCE, ""); //$NON-NLS-1$
	}

}
