/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.examples.dr.drs.service.outputter;

import java.util.List;

import org.eclipse.cosmos.dc.broker.provisional.client.DataManager;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Service;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.BrokerNodeDecorator;

public class NodeDecorator extends BrokerNodeDecorator {

	@Override
	public String getDisplayName(Object node) {
		if (node instanceof DataManager){
			DataManager dm =  ((DataManager)node);
			
			if ( dm != null ){
				String dmName = dm.getName();
								
				if ( dmName.equalsIgnoreCase("examplemdr")){ //$NON-NLS-1$
					dmName = Messages.getString("NodeDecorator.1"); //$NON-NLS-1$
				} else if ( dmName.equalsIgnoreCase("SMLMDR")){ //$NON-NLS-1$
					dmName = Messages.getString("NodeDecorator.3"); //$NON-NLS-1$
				} else if ( dmName.equalsIgnoreCase("CBEServices")){ //$NON-NLS-1$
					dmName = Messages.getString("NodeDecorator.5"); //$NON-NLS-1$
				} else if ( dmName.equalsIgnoreCase("StatisticalDataManager")){ //$NON-NLS-1$
					dmName = Messages.getString("NodeDecorator.7"); //$NON-NLS-1$
				} else if ( dmName.equalsIgnoreCase("TestFederatingCMDB")){ //$NON-NLS-1$
					dmName = Messages.getString("NodeDecorator.8"); //$NON-NLS-1$
				} else if ( dmName.equalsIgnoreCase("aperimdr")){ //$NON-NLS-1$
					dmName = Messages.getString("NodeDecorator.9"); //$NON-NLS-1$
				}
				return dmName;
			}		
		}
		return Messages.getString("NodeDecorator.0"); //$NON-NLS-1$
	}

	@Override
	public String getNodeClass(Object node) {
		String nodeClass = "mdr"; //$NON-NLS-1$
		if (node instanceof DataManager){
			DataManager dm =  ((DataManager)node);
			if ( dm != null ){
								
				//need to get servies by namespace
				List<Service> services = dm.getServices();
				for (int x = 0 ; x < services.size(); x++){
					Service service = services.get(x);
					if ( dm.getName().equalsIgnoreCase("examplemdr")){ //$NON-NLS-1$
						nodeClass = "mdrExample"; //$NON-NLS-1$
						break;
					}else if ( dm.getName().equalsIgnoreCase("SMLMDR")){ //$NON-NLS-1$
						nodeClass = "smlRepository"; //$NON-NLS-1$
						break;
					}else if ( service.getNamespace().equals("http://datamgr.stat.internal.dc.cosmos.eclipse.org")){ //$NON-NLS-1$
						nodeClass = "StatDataManager"; //$NON-NLS-1$
					} else if ( service.getNamespace().equals("http://datamgr.logging.internal.dc.cosmos.eclipse.org")){ //$NON-NLS-1$
						nodeClass = "CBEDataManager"; //$NON-NLS-1$
						break;
					} else if ( service.getNamespace().equals("http://cmdbf.org/schema/1-0-0/registration")){ //$NON-NLS-1$
						nodeClass = "mdrCMDBf"; //$NON-NLS-1$
						break;
					} else if ( service.getNamespace().equals("http://cmdbf.org/schema/1-0-0/query")){ //$NON-NLS-1$
						nodeClass = "mdr"; //$NON-NLS-1$
						break;
					}
									
				}
			}		
		}
		return nodeClass;
	}



}
