/**********************************************************************
 * Copyright (c) 2008 CA Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * CA - Initial API and implementation
 *
 **********************************************************************/

package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.PrintWriter;

import org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.LoggerWrapper;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

public class RecordDetailsOutputter extends AbstractOutputter {
	private static ILogger logger = LoggerWrapper.getLogger(RecordDetailsOutputter.class);

	public void render(PrintWriter output, IParameters input) throws Exception {

		StringBuffer sb = new StringBuffer();
		sb.append("<?xml version=\"1.0\"?>"); //$NON-NLS-1$
		sb.append(" <xml>"); //$NON-NLS-1$

		String xmlIn = input.getParameter("xmlIn");		 //$NON-NLS-1$
		
		logger.info(Messages.getString("RecordDetailsOutputter.3")+xmlIn); //$NON-NLS-1$
		
		sb.append(xmlIn);
		
		sb.append(" </xml>"); //$NON-NLS-1$

		logger.info(Messages.getString("RecordDetailsOutputter.5")+sb); //$NON-NLS-1$
		output.print(sb);
			
	}
	
}

