/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.test;

import java.util.List;
import org.eclipse.cosmos.dc.broker.provisional.client.BrokerClient;
import org.eclipse.cosmos.dc.broker.provisional.client.DataManager;
import org.eclipse.cosmos.dc.test.CommandEntry;
import org.eclipse.cosmos.dc.test.CosmosCLI;
import org.eclipse.cosmos.dc.test.Messages;
import org.eclipse.cosmos.dc.test.Tokenizer;

class CmdGetDataManagersByRecordTypeNamespace
extends CommandEntry {
    private String recTypeNsp = null;

    CmdGetDataManagersByRecordTypeNamespace(CosmosCLI cli) {
        this._cli = cli;
        this._command = new String("GetDataManagersByRecordTypeNamespace");
        this._usage_entry = new String("USAGE_GETDMS_RECTYPE_INFO");
    }

    public boolean validateArguments(Tokenizer st, String line) {
        if (!st.hasMoreTokens()) {
            this._cli.logMessage(Messages.getString("MISSING_DM_RECTYPE_ERR"));
            return false;
        }
        this.recTypeNsp = st.nextToken();
        return true;
    }

    public void performAction() throws Exception {
        BrokerClient brokerclient = new BrokerClient(this._cli.getBrokerEPR());
        this._cli.logMessage(Messages.getString("DM_MESG_INFO"));
        List dmlist = null;
        dmlist = brokerclient.getDataManagerByRecordTypeNamespace(this.recTypeNsp);
        for (DataManager dm : dmlist) {
            this._cli.printDataManager(dm);
        }
    }
}

