/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.notification.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.muse.core.AbstractCapability;
import org.apache.muse.core.routing.MessageHandler;
import org.apache.muse.core.serializer.SerializerRegistry;
import org.apache.muse.util.LoggingUtils;
import org.apache.muse.util.MultiMap;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.notification.NotificationConsumer;
import org.apache.muse.ws.notification.NotificationMessage;
import org.apache.muse.ws.notification.NotificationMessageListener;
import org.apache.muse.ws.notification.TopicListener;
import org.apache.muse.ws.notification.impl.NotificationMessageSerializer;
import org.apache.muse.ws.notification.impl.NotifyHandler;

public class SimpleNotificationConsumer
extends AbstractCapability
implements NotificationConsumer {
    private Collection _messageListeners = new ArrayList();
    private Map _topicListeners = new MultiMap();
    static /* synthetic */ Class array$Lorg$apache$muse$ws$notification$NotificationMessage;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$NotificationMessage;

    public void addMessageListener(NotificationMessageListener listener) {
        this._messageListeners.add(listener);
    }

    public void addTopicListener(TopicListener listener) {
        this._topicListeners.put(listener.getTopic(), listener);
    }

    protected MessageHandler createNotifyHandler() {
        NotifyHandler handler = new NotifyHandler();
        Method method = null;
        try {
            method = this.getClass().getMethod("notify", array$Lorg$apache$muse$ws$notification$NotificationMessage == null ? (array$Lorg$apache$muse$ws$notification$NotificationMessage = SimpleNotificationConsumer.class$("[Lorg.apache.muse.ws.notification.NotificationMessage;")) : array$Lorg$apache$muse$ws$notification$NotificationMessage);
        }
        catch (Throwable error) {
            throw new RuntimeException(error.getMessage(), error);
        }
        handler.setMethod(method);
        return handler;
    }

    public Collection getMessageListeners() {
        return Collections.unmodifiableCollection(this._messageListeners);
    }

    public Collection getTopicListeners(QName topic) {
        Collection listeners = (Collection)this._topicListeners.get(topic);
        if (listeners == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(listeners);
    }

    public void initialize() throws SoapFault {
        super.initialize();
        SerializerRegistry registry = SerializerRegistry.getInstance();
        registry.registerSerializer(class$org$apache$muse$ws$notification$NotificationMessage == null ? (class$org$apache$muse$ws$notification$NotificationMessage = SimpleNotificationConsumer.class$("org.apache.muse.ws.notification.NotificationMessage")) : class$org$apache$muse$ws$notification$NotificationMessage, new NotificationMessageSerializer());
        this.setMessageHandler(this.createNotifyHandler());
    }

    public void notify(NotificationMessage[] messages) {
        NotifyThread thread = new NotifyThread(messages);
        thread.start();
    }

    public void removeMessageListener(NotificationMessageListener listener) {
        this._messageListeners.remove(listener);
    }

    public void removeTopicListener(TopicListener listener) {
        QName topic = listener.getTopic();
        Collection listeners = (Collection)this._topicListeners.get(topic);
        listeners.remove(listener);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class NotifyThread
    extends Thread {
        private NotificationMessage[] _messages = null;

        public NotifyThread(NotificationMessage[] messages) {
            this._messages = messages;
        }

        private void processMessageListeners(NotificationMessage message) {
            Iterator i = SimpleNotificationConsumer.this.getMessageListeners().iterator();
            while (i.hasNext()) {
                NotificationMessageListener listener = (NotificationMessageListener)i.next();
                try {
                    if (!listener.accepts(message)) continue;
                    listener.process(message);
                }
                catch (Throwable error) {
                    LoggingUtils.logError(SimpleNotificationConsumer.this.getLog(), error);
                }
            }
        }

        private void processTopicListeners(NotificationMessage message) {
            QName topic = message.getTopic();
            Iterator i = SimpleNotificationConsumer.this.getTopicListeners(topic).iterator();
            while (i.hasNext()) {
                NotificationMessageListener listener = (NotificationMessageListener)i.next();
                try {
                    listener.process(message);
                }
                catch (Throwable error) {
                    LoggingUtils.logError(SimpleNotificationConsumer.this.getLog(), error);
                }
            }
        }

        public void run() {
            for (int n = 0; n < this._messages.length; ++n) {
                QName topic = this._messages[n].getTopic();
                Collection topicListeners = SimpleNotificationConsumer.this.getTopicListeners(topic);
                if (!topicListeners.isEmpty()) {
                    this.processTopicListeners(this._messages[n]);
                    continue;
                }
                this.processMessageListeners(this._messages[n]);
            }
        }
    }
}

