/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityConstraintStructure {
    private Map<String, List<IdentityInstance>> constrainedInstances = new Hashtable<String, List<IdentityInstance>>();
    private Map<String, List<IdentityInstance>> orphanedConstrainedInstances = new Hashtable<String, List<IdentityInstance>>();

    public void addConstrainedInstance(String alias, IdentityInstance identityInstance) {
        this.addToNestedList(this.constrainedInstances, alias, identityInstance);
    }

    public void addOrphanedConstrainedInstance(int orphanInx, IdentityInstance identityInstance) {
        this.addToNestedList(this.orphanedConstrainedInstances, String.valueOf(orphanInx), identityInstance);
    }

    private void addToNestedList(Map<String, List<IdentityInstance>> map, String key, IdentityInstance value) {
        List<IdentityInstance> nestedList = map.get(key);
        if (nestedList == null) {
            nestedList = new ArrayList<IdentityInstance>();
            map.put(key, nestedList);
        }
        nestedList.add(value);
    }

    public IdentityInstance[] getConstrainedInstances(String alias) {
        List<IdentityInstance> list = this.constrainedInstances.get(alias);
        return list == null ? new IdentityInstance[]{} : list.toArray(new IdentityInstance[list.size()]);
    }

    public String[] getConstrainedAliases() {
        String[] constrainedAliases = new String[this.constrainedInstances.size()];
        int counter = 0;
        Iterator<String> aliases = this.constrainedInstances.keySet().iterator();
        while (aliases.hasNext()) {
            constrainedAliases[counter++] = aliases.next();
        }
        return constrainedAliases;
    }

    public IdentityInstance[] getOrphanedConstrainedInstances(int index) {
        List<IdentityInstance> list = this.orphanedConstrainedInstances.get(String.valueOf(index));
        return list == null ? new IdentityInstance[]{} : list.toArray(new IdentityInstance[list.size()]);
    }

    public int[] getOrphanedIndices() {
        int[] keys = new int[this.orphanedConstrainedInstances.size()];
        int counter = 0;
        for (String index : this.orphanedConstrainedInstances.keySet()) {
            keys[counter++] = Integer.parseInt(index);
        }
        return keys;
    }

    public IdentityInstance[] getIdentityConstraints() {
        ArrayList<IdentityInstance> instances = new ArrayList<IdentityInstance>();
        this.addInstances(instances, this.constrainedInstances);
        this.addInstances(instances, this.orphanedConstrainedInstances);
        return instances.toArray(new IdentityInstance[instances.size()]);
    }

    private void addInstances(List<IdentityInstance> instances, Map<String, List<IdentityInstance>> map) {
        Iterator<List<IdentityInstance>> identityInstances = map.values().iterator();
        while (identityInstances.hasNext()) {
            instances.addAll((Collection<IdentityInstance>)identityInstances.next());
        }
    }

    public static class IdentityConstraint {
        public static final byte KEY_TYPE = 0;
        public static final byte KEY_REF_TYPE = 1;
        public static final byte UNIQUE_TYPE = 2;
        private byte type;
        private String name;
        private List<String> fields = new ArrayList<String>();
        private String selector;
        private String refer;
        private NamespaceContext namespaceContext;
        private String ref;
        private String namespace;

        public IdentityConstraint() {
        }

        public IdentityConstraint(String name) {
            this();
            this.name = name;
        }

        public byte getType() {
            return this.type;
        }

        public void setType(byte type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String[] getFields() {
            return this.fields.toArray(new String[this.fields.size()]);
        }

        public void addField(String fields) {
            if (fields == null) {
                return;
            }
            this.fields.add(fields);
        }

        public String getSelector() {
            return this.selector;
        }

        public void setSelector(String selector) {
            this.selector = selector;
        }

        public String getRefer() {
            return this.refer;
        }

        public void setRefer(String refer) {
            this.refer = refer;
        }

        public NamespaceContext getNamespaceContext() {
            return this.namespaceContext;
        }

        public void setNamespaceContext(NamespaceContext namespaceContext) {
            this.namespaceContext = namespaceContext;
        }

        public String getRef() {
            return this.ref;
        }

        public void setRef(String ref) {
            this.ref = ref;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }
    }

    public static class IdentityInstance {
        private int[] nodePath;
        private IdentityConstraint constraint;
        private int lineNumber;

        public int[] getNodePath() {
            return this.nodePath;
        }

        public void setNodePath(int[] nodePath) {
            this.nodePath = nodePath;
        }

        public IdentityConstraint getConstraint() {
            return this.constraint;
        }

        public void setConstraint(IdentityConstraint constraint) {
            this.constraint = constraint;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }
    }
}

