/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.eclipse.cosmos.rm.internal.validation.artifacts.AbstractDeclaration;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ConstraintNode;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementLocation;
import org.eclipse.cosmos.rm.internal.validation.artifacts.GroupDeclaration;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeclarationBuilder<T>
extends AbstractDataBuilder<T> {
    private Stack<String> elements = new Stack();
    private AbstractDeclaration declaration;
    private boolean sequenceElementHit;

    protected String retrieveValue(Attributes attributes, String uri, String localName) {
        String value = attributes.getValue(uri, localName);
        return value == null ? attributes.getValue(localName) : value;
    }

    protected ConstraintNode createElementDeclaration(Attributes attributes) {
        Map<String, String> prefixUriMap = this.getPrefixMap();
        String targetNamespace = this.getTargetNamespace();
        ConstraintNode targetNode = new ConstraintNode();
        QName localElementName = SMLValidatorUtil.toQName(prefixUriMap, targetNamespace, this.retrieveValue(attributes, "http://www.w3.org/2001/XMLSchema", "name"));
        if (localElementName != null) {
            targetNode.setName(localElementName.getLocalPart());
            targetNode.setUri(localElementName.getNamespaceURI());
        } else {
            targetNode.setUri(targetNamespace);
        }
        targetNode.setRef(SMLValidatorUtil.toQName(prefixUriMap, targetNamespace, this.retrieveValue(attributes, "http://www.w3.org/2001/XMLSchema", "ref")));
        targetNode.setTargetElement(SMLValidatorUtil.toQName(prefixUriMap, targetNamespace, attributes.getValue("http://www.w3.org/2008/03/sml", "targetElement")));
        targetNode.setTargetType(SMLValidatorUtil.toQName(prefixUriMap, targetNamespace, attributes.getValue("http://www.w3.org/2008/03/sml", "targetType")));
        targetNode.setTargetRequired(attributes.getValue("http://www.w3.org/2008/03/sml", "targetRequired"));
        return targetNode;
    }

    private GroupDeclaration createGroupDeclaration(Attributes attributes) {
        Map<String, String> prefixUriMap = this.getPrefixMap();
        String targetNamespace = this.getTargetNamespace();
        GroupDeclaration groupDeclaration = new GroupDeclaration();
        groupDeclaration.setQName(SMLValidatorUtil.toQName(prefixUriMap, targetNamespace, this.retrieveValue(attributes, "http://www.w3.org/2001/XMLSchema", "name")));
        groupDeclaration.setRef(SMLValidatorUtil.toQName(prefixUriMap, targetNamespace, this.retrieveValue(attributes, "http://www.w3.org/2001/XMLSchema", "ref")));
        return groupDeclaration;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        if (!"http://www.w3.org/2001/XMLSchema".equals(uri)) {
            return;
        }
        this.elements.push(localName);
        if (this.declaration != null) {
            if ("sequence".equals(localName)) {
                this.sequenceElementHit = true;
            } else if (this.sequenceElementHit && "element".equals(localName)) {
                this.declaration.getElementDeclarations().add(this.createElementDeclaration(attributes));
            } else if (this.sequenceElementHit && "group".equals(localName)) {
                this.declaration.getGroupDeclarations().add(this.createGroupDeclaration(attributes));
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (!"http://www.w3.org/2001/XMLSchema".equals(uri)) {
            return;
        }
        this.elements.pop();
        if (this.sequenceElementHit && "sequence".equals(localName)) {
            this.sequenceElementHit = false;
        }
    }

    protected String getLastElement() {
        return this.elements.isEmpty() ? null : this.elements.peek();
    }

    protected AbstractDeclaration setCommonFields(Attributes attributes, AbstractDeclaration declaration) {
        String typeName = this.retrieveValue(attributes, "http://www.w3.org/2001/XMLSchema", "name");
        String typeUri = super.getTargetNamespace();
        if (typeName != null && typeUri != null) {
            declaration.setQName(new QName(typeUri, typeName));
            declaration.setLocation(new ElementLocation(null, this.getLocator().getLineNumber(), this.getLocator().getColumnNumber()));
            return declaration;
        }
        return null;
    }

    protected AbstractDeclaration getDeclaration() {
        return this.declaration;
    }

    protected void setDeclaration(AbstractDeclaration declaration) {
        this.declaration = declaration;
    }
}

