/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.cosmos.rm.internal.validation.artifacts.RuleBinding;
import org.eclipse.cosmos.rm.internal.validation.artifacts.RuleBindings;
import org.eclipse.cosmos.rm.internal.validation.artifacts.Schematron;
import org.eclipse.cosmos.rm.internal.validation.common.XMLInternalUtility;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.reference.SMLExtensionFunctions;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementSchematronCacheBuilder
extends AbstractDataBuilder<RuleBindings> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.ElementSchematronCacheBuilder";
    private RuleBindings dataStructure;
    protected StringBuffer buffer;
    protected String name;
    protected String type;
    protected String targetNamespace;
    private Map<String, String> schemaAttributes;
    private boolean schematronFound = false;
    private Map<String, String> prefixLookup;
    private List<RuleBinding> ruleBindings = new ArrayList<RuleBinding>();
    private RuleBinding currentRuleBinding = null;
    private boolean aliasFound = false;
    private boolean aliasesFound = false;
    private List<String> aliases;
    private boolean instance = false;
    private List<Schematron.Pattern> patterns;
    private Schematron.Pattern pattern;
    private Schematron.Rule rule;
    private boolean ruleElementHit;
    private boolean patternElementHit;
    private boolean ruleAliasFound = false;
    private boolean documentAliasFound = false;
    private Stack<String> elementStack;
    private Set<String> prefixcache;
    private Map<String, Set<String>> element2prefixmap;
    private Map<String, Stack<String>> prefix2nsmap;
    private String elementPathWithLocid;
    private boolean ignoreTextElement = false;

    public ElementSchematronCacheBuilder() {
        this.dataStructure = new RuleBindings();
        this.patterns = new ArrayList<Schematron.Pattern>();
        this.prefixcache = new HashSet<String>();
        this.elementStack = new Stack();
        this.element2prefixmap = new HashMap<String, Set<String>>();
        this.prefix2nsmap = new HashMap<String, Stack<String>>();
        this.addEvent(4);
        this.addEvent(1);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Set<String> prefixSet;
        if ("instances".equals(localName)) {
            this.instance = false;
            return;
        }
        if ("documentAlias".equals(localName)) {
            this.documentAliasFound = false;
            return;
        }
        if ("ruleAlias".equals(localName)) {
            this.ruleAliasFound = false;
            return;
        }
        if ("ruleBinding".equals(localName)) {
            if (this.currentRuleBinding.isValid()) {
                this.ruleBindings.add(this.currentRuleBinding);
            }
            this.currentRuleBinding = null;
            return;
        }
        if (!(this.getBuffer() == null || this.ignoreTextElement && localName.equals("value-of"))) {
            XMLInternalUtility.addElement(this.getBuffer(), 0, qName, true, true);
        }
        if ("http://purl.oclc.org/dsdl/schematron".equals(uri)) {
            if ("rule".equals(localName)) {
                this.pattern.addRule(this.rule);
                this.ruleElementHit = false;
                this.rule = null;
            } else if ("pattern".equals(localName)) {
                this.patterns.add(this.pattern);
                this.patternElementHit = false;
                this.pattern = null;
            } else if (this.schematronFound && "schema".equals(localName)) {
                int lineNumber = this.getLocator() == null ? -1 : this.getLocator().getLineNumber();
                Schematron schematronRule = new Schematron(this.buffer, this.patterns, this.prefixLookup, lineNumber);
                if (this.name != null) {
                    this.dataStructure.bindRule(this.targetNamespace, this.name, schematronRule);
                } else if (this.type != null) {
                    this.dataStructure.bindRule(this.targetNamespace, String.valueOf(this.type) + "$typeDelim", schematronRule);
                } else if (this.aliases != null && this.ruleBindings.size() > 0) {
                    for (RuleBinding binding : this.ruleBindings) {
                        String docAlias = binding.getAlias();
                        if (docAlias == null) {
                            this.dataStructure.addGloballyBoundRule(schematronRule);
                            continue;
                        }
                        String ruleAlias = binding.getRule();
                        if (!this.aliases.contains(ruleAlias)) continue;
                        this.dataStructure.bindRule(docAlias, schematronRule);
                    }
                } else if (this.targetNamespace == null) {
                    this.ruleBindings.size();
                }
                this.prefixLookup = new HashMap<String, String>();
                this.buffer = null;
                this.name = null;
                this.schematronFound = false;
                this.aliases = null;
                this.patterns.clear();
            }
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(uri)) {
            if ("schema".equals(localName)) {
                this.schemaAttributes = null;
                this.targetNamespace = null;
            } else if ("element".equals(localName)) {
                this.name = null;
            } else if ("complexType".equals(localName)) {
                this.type = null;
            }
        } else if ("http://www.w3.org/2008/03/sml-if".equals(uri)) {
            if ("aliases".equals(localName)) {
                this.aliasesFound = false;
            } else if (this.aliasFound && "alias".equals(localName)) {
                this.aliasFound = false;
            }
        }
        if (this.getElementPath().equals(this.elementPathWithLocid)) {
            this.ignoreTextElement = false;
        }
        if ((prefixSet = this.element2prefixmap.remove(this.getElementPath())) != null) {
            for (String prefix : prefixSet) {
                Stack<String> nsStack = this.prefix2nsmap.get(prefix);
                nsStack.pop();
            }
        }
        this.elementStack.pop();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String locidValue;
        String localizedString = null;
        this.elementStack.push(qName);
        String currentPath = this.getElementPath();
        if (this.prefixcache != null && this.prefixcache.size() > 0) {
            this.element2prefixmap.put(currentPath, this.prefixcache);
            this.prefixcache = new HashSet<String>();
        }
        if ((locidValue = attributes.getValue("http://www.w3.org/2008/03/sml", "locid")) != null && (localizedString = this.getLocalizedString(locidValue)) != null) {
            this.ignoreTextElement = true;
            this.elementPathWithLocid = currentPath;
        }
        if ("instances".equals(localName)) {
            this.instance = true;
            return;
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(uri)) {
            if ("schema".equals(localName)) {
                this.schematronFound = false;
                this.targetNamespace = attributes.getValue("targetNamespace");
                this.schemaAttributes = new HashMap<String, String>();
                int x = 0;
                while (x < attributes.getLength()) {
                    String key = attributes.getQName(x);
                    if (key.startsWith("xmlns")) {
                        this.schemaAttributes.put(attributes.getQName(x), attributes.getValue(x));
                    }
                    ++x;
                }
            } else if ("element".equals(localName)) {
                this.name = attributes.getValue("name");
            } else if ("complexType".equals(localName)) {
                this.type = attributes.getValue("name");
            }
        } else if ("http://www.w3.org/2008/03/sml-if".equals(uri)) {
            if ("ruleBinding".equals(localName)) {
                this.currentRuleBinding = new RuleBinding();
            } else if ("ruleAlias".equals(localName)) {
                this.ruleAliasFound = true;
            } else if ("documentAlias".equals(localName)) {
                this.documentAliasFound = true;
            } else if ("aliases".equals(localName)) {
                this.aliasesFound = true;
                this.aliases = new ArrayList<String>();
            } else if (this.aliasesFound && "alias".equals(localName)) {
                this.aliasFound = true;
            }
        } else if ("http://purl.oclc.org/dsdl/schematron".equals(uri) && "schema".equals(localName)) {
            this.schematronFound = true;
            this.buffer = new StringBuffer();
        }
        if (this.buffer != null) {
            if ("http://purl.oclc.org/dsdl/schematron".equals(uri)) {
                if ("rule".equals(localName)) {
                    this.ruleElementHit = true;
                    this.rule = new Schematron.Rule();
                    if (this.getLocator() != null) {
                        this.rule.setLineNumber(this.getLocator().getLineNumber());
                    }
                    StringBuffer ruleFragment = this.rule.getFragment();
                    ruleFragment.append("<").append(qName).append(this.printRuleAttributes(attributes)).append(">");
                    return;
                }
                if ("pattern".equals(localName)) {
                    this.patternElementHit = true;
                    this.pattern = new Schematron.Pattern();
                } else if ("ns".equals(localName)) {
                    if (this.prefixLookup == null) {
                        this.prefixLookup = new HashMap<String, String>();
                    }
                    this.prefixLookup.put(attributes.getValue("prefix"), attributes.getValue("uri").trim());
                }
                if (!this.ignoreTextElement || !localName.equals("value-of")) {
                    this.getBuffer().append("<").append(qName).append(this.printReplaceSMLFNAttributes(attributes)).append(">");
                }
                if (localizedString != null) {
                    this.getBuffer().append(localizedString);
                }
            } else if ("element".equals(localName) && "http://www.w3.org/2001/XMLSchema".equals(uri)) {
                this.buffer.append("<").append(qName).append(this.printSchNamespaceAttributes(attributes)).append(">");
            } else {
                this.getBuffer().append("<").append(qName).append(this.printAttributes(attributes)).append(">");
            }
        }
    }

    private StringBuffer getBuffer() {
        StringBuffer buff = this.buffer;
        if (this.ruleElementHit) {
            buff = this.rule.getFragment();
        } else if (this.patternElementHit) {
            buff = this.pattern.getFragment();
        }
        return buff;
    }

    private String getElementPath() {
        String path = "";
        Object[] patharray = this.elementStack.toArray();
        int i = 0;
        while (i < patharray.length) {
            path = String.valueOf(path) + "/" + patharray[i];
            ++i;
        }
        return path;
    }

    private String getNamespace(String prefix) {
        Stack<String> namespaceStack = this.prefix2nsmap.get(prefix);
        String namespace = null;
        if (namespaceStack != null && !namespaceStack.empty()) {
            namespace = namespaceStack.peek();
        }
        return namespace;
    }

    private String getLocalizedString(String locidValue) {
        StringTokenizer tokenizer = new StringTokenizer(locidValue, ":");
        if (tokenizer.countTokens() != 2) {
            return null;
        }
        String prefix = tokenizer.nextToken();
        String key = tokenizer.nextToken();
        String nsuri = this.getNamespace(prefix);
        if (nsuri == null) {
            return null;
        }
        String scheme = null;
        String bundleName = null;
        Locale locale = null;
        String localeStr = null;
        tokenizer = new StringTokenizer(nsuri, ":");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount < 2 || tokenCount > 3) {
            return null;
        }
        scheme = tokenizer.nextToken();
        if (!scheme.equals("sml")) {
            return null;
        }
        bundleName = tokenizer.nextToken();
        if (tokenCount == 3) {
            String language = null;
            String country = null;
            localeStr = tokenizer.nextToken();
            int underscoreIdx = localeStr.indexOf(95);
            if (underscoreIdx != -1) {
                language = localeStr.substring(0, underscoreIdx);
                country = localeStr.substring(underscoreIdx + 1, localeStr.length());
                locale = new Locale(language, country);
            } else {
                language = localeStr;
                locale = new Locale(language);
            }
        } else {
            locale = Locale.getDefault();
        }
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(bundleName, locale);
            String msg = rb.getString(key);
            return msg;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected StringBuffer printRuleAttributes(Attributes attributes) {
        buffer = new StringBuffer();
        x = 0;
        while (x < attributes.getLength()) {
            attributeValue = attributes.getValue(x);
            if (!"context".equals(attributes.getLocalName(x))) ** GOTO lbl-1000
            this.rule.setContext(attributeValue);
            if (attributeValue.indexOf("deref") > -1) {
                buffer.append(" ").append(attributes.getQName(x)).append("=").append("\"").append("/*[1]").append("\"");
                this.rule.setMatchContainsDeref(true);
            } else lbl-1000:
            // 2 sources

            {
                buffer.append(" ").append(attributes.getQName(x)).append("=").append("\"").append(attributeValue).append("\"");
            }
            ++x;
        }
        return buffer;
    }

    protected StringBuffer printReplaceSMLFNAttributes(Attributes attributes) {
        StringBuffer buffer = new StringBuffer();
        int x = 0;
        while (x < attributes.getLength()) {
            if ("uri".equals(attributes.getLocalName(x)) && "http://www.w3.org/2008/03/sml-function".equals(attributes.getValue(x))) {
                buffer.append(" ").append(attributes.getQName(x)).append("=").append("\"").append(SMLExtensionFunctions.class.getName()).append("\"");
            } else {
                buffer.append(" ").append(attributes.getQName(x)).append("=").append("\"").append(attributes.getValue(x)).append("\"");
            }
            ++x;
        }
        return buffer;
    }

    protected StringBuffer printSchNamespaceAttributes(Attributes attributes) {
        StringBuffer buffer = new StringBuffer();
        int x = 0;
        while (x < attributes.getLength()) {
            buffer.append(" ").append(attributes.getQName(x)).append("=").append("\"").append(attributes.getValue(x)).append("\"");
            this.schemaAttributes.remove(attributes.getQName(x));
            ++x;
        }
        for (String key : this.schemaAttributes.keySet()) {
            buffer.append(" ").append(key).append("=").append("\"").append(this.schemaAttributes.get(key)).append("\"");
        }
        return buffer;
    }

    protected StringBuffer printAttributes(Attributes attributes) {
        StringBuffer buffer = new StringBuffer();
        int x = 0;
        while (x < attributes.getLength()) {
            buffer.append(" ").append(attributes.getQName(x)).append("=").append("\"").append(attributes.getValue(x)).append("\"");
            ++x;
        }
        return buffer;
    }

    @Override
    public RuleBindings getDataStructure() {
        return this.dataStructure;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.instance) {
            return;
        }
        if (this.ruleElementHit && this.rule != null && !this.ignoreTextElement) {
            StringBuffer buffer = this.rule.getFragment();
            buffer.append(new String(ch, start, length));
        }
        if (this.ruleAliasFound && this.currentRuleBinding != null) {
            String currentRule = this.currentRuleBinding.getRule();
            if (currentRule == null) {
                currentRule = "";
            }
            this.currentRuleBinding.setRule(String.valueOf(currentRule) + new String(ch, start, length));
        }
        if (this.documentAliasFound && this.currentRuleBinding != null) {
            String currentDocumentAlias = this.currentRuleBinding.getAlias();
            if (currentDocumentAlias == null) {
                currentDocumentAlias = "";
            }
            this.currentRuleBinding.setAlias(String.valueOf(currentDocumentAlias) + new String(ch, start, length));
        }
        if (this.aliasFound) {
            this.aliases.add(new String(ch, start, length));
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixcache.add(prefix);
        Stack<String> nsStack = this.prefix2nsmap.get(prefix);
        if (nsStack == null) {
            nsStack = new Stack();
            this.prefix2nsmap.put(prefix, nsStack);
        }
        nsStack.push(uri);
    }
}

