/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.rm.internal.validation.artifacts.MappedNamespaceContext;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ReferenceDescriptor;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.reference.ReferenceContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceExtractor
extends AbstractDataBuilder<List<ReferenceDescriptor>> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.ReferenceExtractor";
    private boolean uriElementHit;
    private StringBuffer currentReference = new StringBuffer();
    private List<ReferenceDescriptor> references;
    private List<ReferenceContext> contextReferences;
    private boolean aliasElementHit;
    private StringBuffer currentAlias = new StringBuffer();
    private List<String> aliases;
    private boolean isInstancesPhase = false;
    private int noAliasDocumentPosition = 0;
    private boolean isSMLRef = false;
    private ReferenceContext refContext;
    int refContextStack = 0;

    public ReferenceExtractor() {
        this.references = new ArrayList<ReferenceDescriptor>();
        this.contextReferences = new ArrayList<ReferenceContext>();
        this.aliases = new ArrayList<String>();
        super.addEvent(1);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        String value = attributes.getValue("http://www.w3.org/2008/03/sml", "ref");
        if (value != null) {
            this.isSMLRef = Boolean.parseBoolean(value.toString());
            if (this.isSMLRef) {
                this.refContext = new ReferenceContext(this.getFilePath(), this.getLocator().getLineNumber());
                this.refContext.setNamespace(uri);
                this.refContext.setElementName(localName);
                this.contextReferences.add(this.refContext);
                value = attributes.getValue("http://www.w3.org/2008/03/sml", "nilref");
                if (value != null) {
                    this.refContext.setNilref(Boolean.parseBoolean(value.toString()));
                }
                MappedNamespaceContext namespaceContext = new MappedNamespaceContext();
                int i = 0;
                int attCount = attributes.getLength();
                while (i < attCount) {
                    String qName = attributes.getQName(i);
                    if (qName.startsWith("xmlns")) {
                        int colonInx = qName.indexOf(":");
                        String prefix = colonInx >= 0 ? qName.substring(colonInx + 1, qName.length()) : "";
                        namespaceContext.addEntry(prefix, attributes.getValue(i));
                    }
                    ++i;
                }
                this.refContext.setNamespaceContext(namespaceContext);
                this.refContextStack = 0;
            }
        }
        if (this.isSMLRef && uri.equals(this.refContext.getNamespace()) && localName.equals(this.refContext.getElementName())) {
            ++this.refContextStack;
        } else if ("http://www.w3.org/2008/03/sml-if".equals(uri) && "instances".equals(localName)) {
            this.isInstancesPhase = true;
        } else if ("http://www.w3.org/2008/03/sml-if".equals(uri) && "document".equals(localName)) {
            this.aliases.clear();
        } else if ("http://www.w3.org/2008/03/sml-if".equals(uri) && "alias".equals(localName)) {
            this.aliasElementHit = true;
        } else if ("http://www.w3.org/2008/03/sml".equals(uri) && "uri".equals(localName) && this.isSMLRef) {
            this.uriElementHit = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.isSMLRef && uri.equals(this.refContext.getNamespace()) && localName.equals(this.refContext.getElementName())) {
            --this.refContextStack;
            if (this.refContextStack == 0) {
                this.isSMLRef = false;
                this.refContext = null;
            }
        } else if ("http://www.w3.org/2008/03/sml-if".equals(uri) && "data".equals(localName)) {
            if (this.isInstancesPhase && this.aliases.size() == 0) {
                ++this.noAliasDocumentPosition;
            }
        } else if (uri != null && "http://www.w3.org/2008/03/sml-if".equals(uri) && "alias".equals(localName)) {
            this.aliasElementHit = false;
            this.aliases.add(this.currentAlias.toString());
            this.currentAlias.setLength(0);
        } else if ("http://www.w3.org/2008/03/sml".equals(uri) && "uri".equals(localName)) {
            if (this.refContext != null) {
                this.uriElementHit = false;
                ReferenceDescriptor ref = new ReferenceDescriptor(this.getFilePath(), this.getContextLineNumber() - 1, this.currentReference.toString(), this.aliases, this.aliases.size() > 0 ? 0 : this.noAliasDocumentPosition);
                this.references.add(ref);
                this.currentReference = new StringBuffer();
                this.refContext.addReferenceScheme(ref);
                ref.setContext(this.refContext);
            }
        } else if ("http://www.w3.org/2008/03/sml-if".equals(uri) && this.isInstancesPhase && "document".equals(localName)) {
            this.aliases = new ArrayList<String>();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String string;
        if (this.aliasElementHit) {
            string = new String(ch, start, length);
            if (this.currentAlias.length() > 0 && string.charAt(0) == '\n' && string.trim().length() > 0) {
                this.currentAlias.append(' ');
            }
            this.currentAlias.append(string.trim());
        }
        if (this.uriElementHit) {
            string = new String(ch, start, length);
            if (this.currentReference.length() > 0 && string.charAt(0) == '\n' && string.trim().length() > 0) {
                this.currentReference.append(' ');
            }
            this.currentReference.append(string.trim());
        }
    }

    @Override
    public List<ReferenceDescriptor> getDataStructure() {
        return this.references;
    }

    public List<ReferenceContext> getContextReferences() {
        return this.contextReferences;
    }
}

