/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.smlvalidators;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.cosmos.rm.internal.validation.artifacts.DOMStructure;
import org.eclipse.cosmos.rm.internal.validation.artifacts.IdentityConstraintStructure;
import org.eclipse.cosmos.rm.internal.validation.artifacts.MappedNamespaceContext;
import org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationConstants;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.core.AbstractSMLValidator;
import org.eclipse.cosmos.rm.internal.validation.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.internal.validation.databuilders.IdentityConstraintDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.IdentityConstraintUtil;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityConstraintValidator
extends AbstractSMLValidator {
    private IdentityConstraintStructure identityStruct;
    private List<IdentityConstraintStructure.IdentityConstraint> referencedConstraints = new ArrayList<IdentityConstraintStructure.IdentityConstraint>();
    private Map<QName, IdentityConstraintStructure.IdentityConstraint> concreteConstraints = new Hashtable<QName, IdentityConstraintStructure.IdentityConstraint>();

    @Override
    public void initialize(Map<String, Object> validationAttribute) {
        super.initialize(validationAttribute);
        DataBuilderRegistry databuilderRegistry = DataBuilderRegistry.getInstanceLevelRegistry();
        databuilderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.IdentityConstraintDataBuilder", new IdentityConstraintDataBuilder());
    }

    @Override
    public boolean validate() {
        if (!this.isSyntaxValid() && this.shouldAbortOnError()) {
            return false;
        }
        boolean isValidationSuccess = true;
        this.setTaskName(SMLValidationMessages.validationIdentity);
        this.identityStruct = (IdentityConstraintStructure)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.IdentityConstraintDataBuilder");
        DOMStructure domStructure = (DOMStructure)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.DocumentDOMBuilder");
        String[] constrainedInstances = this.identityStruct.getConstrainedAliases();
        int i = 0;
        while (i < constrainedInstances.length) {
            isValidationSuccess = this.handleIdentityInstances(this.identityStruct.getConstrainedInstances(constrainedInstances[i]), domStructure.get(constrainedInstances[i]));
            if (this.shouldAbortOnError()) {
                return false;
            }
            ++i;
        }
        int[] orphanedIndices = this.identityStruct.getOrphanedIndices();
        int i2 = 0;
        while (i2 < orphanedIndices.length) {
            isValidationSuccess = this.handleIdentityInstances(this.identityStruct.getOrphanedConstrainedInstances(orphanedIndices[i2]), domStructure.getOrphan(orphanedIndices[i2]));
            if (this.shouldAbortOnError()) {
                return false;
            }
            ++i2;
        }
        return isValidationSuccess;
    }

    private boolean isSyntaxValid() {
        XSModel xsModel = (XSModel)this.getAttributes().get("xs.model");
        if (xsModel == null) {
            return true;
        }
        XSNamedMap elementDeclarations = xsModel.getComponents((short)2);
        boolean shouldAbortOnError = this.shouldAbortOnError();
        boolean status = true;
        int i = 0;
        int declarationCount = elementDeclarations.getLength();
        while (i < declarationCount && (!shouldAbortOnError || status)) {
            XSElementDeclaration elementDeclaration = (XSElementDeclaration)elementDeclarations.item(i);
            List<IdentityConstraintStructure.IdentityConstraint> identityConstraints = IdentityConstraintUtil.retrieveConstraints(elementDeclaration, null);
            NamespaceContext namespaceContext = this.createNamespaceContext(elementDeclaration);
            ArrayList<QName> constraintNames = new ArrayList<QName>();
            int j = 0;
            int constraintCount = identityConstraints.size();
            while (j < constraintCount) {
                IdentityConstraintStructure.IdentityConstraint identityConstraint = identityConstraints.get(j);
                String ref = identityConstraint.getRef();
                if (ref != null) {
                    if (identityConstraint.getName() != null) {
                        this.getValidationOutput().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)SMLValidationMessages.identityInvalidNameAttribute, (Object)identityConstraint.getRef())));
                        status = false;
                    } else {
                        String[] fields = identityConstraint.getFields();
                        String selector = identityConstraint.getSelector();
                        if (fields != null && fields.length > 0 || selector != null && selector.length() > 0) {
                            this.getValidationOutput().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)SMLValidationMessages.identityInvalidElements, (Object)identityConstraint.getRef())));
                            status = false;
                        } else {
                            identityConstraint.setNamespaceContext(namespaceContext);
                            this.referencedConstraints.add(identityConstraint);
                        }
                    }
                } else {
                    String constraintName = identityConstraint.getName();
                    String[] tokenized = SMLValidatorUtil.tokenizeName(constraintName);
                    String namespace = tokenized[0] == null ? identityConstraint.getNamespace() : IdentityConstraintUtil.lookupNamespace(elementDeclaration, tokenized[0]);
                    QName constraintQName = new QName(namespace, tokenized[1]);
                    if (constraintNames.contains(constraintQName)) {
                        this.getValidationOutput().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)SMLValidationMessages.identityDuplicateName, (Object)constraintName)));
                        status = false;
                    } else {
                        constraintNames.add(constraintQName);
                        this.concreteConstraints.put(constraintQName, identityConstraint);
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        int refCount = this.referencedConstraints.size();
        while (i < refCount && (!shouldAbortOnError || status)) {
            IdentityConstraintStructure.IdentityConstraint referenceConstraint = this.referencedConstraints.get(i);
            String[] qNameStr = SMLValidatorUtil.tokenizeName(referenceConstraint.getRef());
            String namespace = qNameStr[0] == null ? "" : referenceConstraint.getNamespaceContext().getNamespaceURI(qNameStr[0]);
            IdentityConstraintStructure.IdentityConstraint resolvedConstraint = this.concreteConstraints.get(new QName(namespace = namespace == null ? "" : namespace, qNameStr[1]));
            if (resolvedConstraint != null) {
                if (resolvedConstraint.getType() != referenceConstraint.getType()) {
                    this.getValidationOutput().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)SMLValidationMessages.identityBadReferenceType, (Object)referenceConstraint.getRef())));
                    status = false;
                } else {
                    this.changeReference(referenceConstraint, resolvedConstraint);
                }
            } else {
                this.getValidationOutput().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)SMLValidationMessages.identityMissingConstraint, (Object)referenceConstraint.getRef())));
                status = false;
            }
            ++i;
        }
        XSNamedMap typeDeclarations = xsModel.getComponents((short)15);
        int j = 0;
        int count = typeDeclarations.getLength();
        while (j < count) {
            XSComplexTypeDefinition complexTypeDefinition = (XSComplexTypeDefinition)typeDeclarations.item(j);
            if (SMLValidatorUtil.retrieveAnnotation((XSTypeDefinition)complexTypeDefinition, "http://www.w3.org/2008/03/sml", IdentityConstraintDataBuilder.IDENTITY_CONSTRAINTS, false) != null) {
                this.getValidationOutput().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createWarningMessage(-1, NLS.bind((String)SMLValidationMessages.identityBadDeclaration, (Object)complexTypeDefinition.getName())));
            }
            ++j;
        }
        return status;
    }

    private NamespaceContext createNamespaceContext(XSElementDeclaration elementDeclaration) {
        MappedNamespaceContext namespaceContext = new MappedNamespaceContext();
        Document document = SMLValidatorUtil.createDocument();
        XSAnnotation annotation = elementDeclaration.getAnnotation();
        if (annotation == null) {
            return namespaceContext;
        }
        elementDeclaration.getAnnotation().writeAnnotation((Object)document, (short)3);
        NamedNodeMap attributes = document.getFirstChild().getAttributes();
        int i = 0;
        int attCount = attributes.getLength();
        while (i < attCount) {
            Node attribute = attributes.item(i);
            if ("xmlns".equals(attribute.getPrefix())) {
                namespaceContext.addEntry(attribute.getLocalName(), attribute.getNodeValue());
            }
            ++i;
        }
        return namespaceContext;
    }

    private void changeReference(IdentityConstraintStructure.IdentityConstraint referenceConstraint, IdentityConstraintStructure.IdentityConstraint resolvedConstraint) {
        IdentityConstraintStructure.IdentityInstance[] identityConstraint = this.identityStruct.getIdentityConstraints();
        String referencedConstraint = referenceConstraint.getRef();
        int i = 0;
        while (i < identityConstraint.length) {
            IdentityConstraintStructure.IdentityConstraint constraint = identityConstraint[i].getConstraint();
            String ref = constraint.getRef();
            if (ref != null && ref.equals(referencedConstraint)) {
                identityConstraint[i].setConstraint(resolvedConstraint);
            }
            ++i;
        }
    }

    private boolean handleIdentityInstances(IdentityConstraintStructure.IdentityInstance[] identityInstances, Node node) {
        if (node == null) {
            return true;
        }
        boolean status = true;
        Hashtable<String, List<String>> documentConstraints = new Hashtable<String, List<String>>();
        int j = 0;
        while (j < identityInstances.length) {
            String error = this.validateIdentityConstraints(node, identityInstances[j], documentConstraints);
            if (error != null) {
                status = false;
                this.getValidationOutput().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(identityInstances[j].getLineNumber(), error));
                if (this.shouldAbortOnError()) {
                    return false;
                }
            }
            ++j;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String validateIdentityConstraints(Node root, IdentityConstraintStructure.IdentityInstance identityInstance, Map<String, List<String>> constraintFields) {
        Node context = this.findNode(root, identityInstance.getNodePath());
        IdentityConstraintStructure.IdentityConstraint constraint = identityInstance.getConstraint();
        String error = null;
        try {
            XPathExpression selector = null;
            String[] fields = null;
            ArrayList<String> fieldValues = new ArrayList<String>();
            XPath xPath = SMLValidatorUtil.xpath;
            synchronized (xPath) {
                if (constraint.getNamespaceContext() != null) {
                    SMLValidatorUtil.xpath.setNamespaceContext(constraint.getNamespaceContext());
                }
                selector = SMLValidatorUtil.xpath.compile(constraint.getSelector());
                fields = constraint.getFields();
                NodeList selectorList = (NodeList)selector.evaluate(context, XPathConstants.NODESET);
                if (selectorList == null) return null;
                if (selectorList.getLength() <= 0) {
                    return null;
                }
                fieldValues = new ArrayList();
                int j = 0;
                int nodeCount = selectorList.getLength();
                block5: while (j < nodeCount) {
                    String fieldsPerNode = "";
                    int k = 0;
                    while (true) {
                        if (k >= fields.length) {
                            fieldValues.add(fieldsPerNode);
                            ++j;
                            continue block5;
                        }
                        Node currentNode = selectorList.item(j);
                        String currentField = this.extractField(currentNode, fields[k]);
                        fieldsPerNode = String.valueOf(fieldsPerNode) + (currentField == null ? "" : (fieldsPerNode.length() > 0 ? ", " + currentField : currentField));
                        if (currentField == null && constraint.getType() == 0) {
                            return NLS.bind((String)SMLValidationMessages.identityMissingField, (Object[])new String[]{fields[k], constraint.getName()});
                        }
                        ++k;
                    }
                    break;
                }
            }
            constraintFields.put(constraint.getName(), fieldValues);
            error = this.validateConstraint(constraintFields, constraint, fieldValues);
            if (error == null) return null;
            return error;
        }
        catch (XPathExpressionException e) {
            String string;
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(NLS.bind((String)SMLValidationMessages.identityXPathError, (Object[])new String[]{constraint.getSelector(), constraint.getName()}))).append(IValidationConstants.LINE_SEPARATOR);
            if (e.getMessage() == null) {
                string = "";
                return stringBuilder.append(string).toString();
            }
            string = e.getMessage();
            return stringBuilder.append(string).toString();
        }
    }

    private String validateConstraint(Map<String, List<String>> constraintMap, IdentityConstraintStructure.IdentityConstraint constraint, List<String> fields) {
        switch (constraint.getType()) {
            case 0: 
            case 2: {
                Hashtable<String, String> indexedHashtable = new Hashtable<String, String>();
                int i = 0;
                int listSize = fields.size();
                while (i < listSize) {
                    if (indexedHashtable.get(fields.get(i)) != null) {
                        return NLS.bind((String)SMLValidationMessages.identityDuplicateKey, (Object[])new String[]{constraint.getName(), fields.get(i).toString()});
                    }
                    indexedHashtable.put(fields.get(i), "");
                    ++i;
                }
                break;
            }
            case 1: {
                String reference = constraint.getRefer();
                List<String> referencedConstraint = null;
                if (reference == null) {
                    return NLS.bind((String)SMLValidationMessages.identityMissingReference, (Object)constraint.getName());
                }
                referencedConstraint = constraintMap.get(reference);
                if (referencedConstraint == null) {
                    return NLS.bind((String)SMLValidationMessages.identityMissingConstraint, (Object)constraint.getName());
                }
                int i = 0;
                int fieldSize = fields.size();
                while (i < fieldSize) {
                    String currentField = fields.get(i);
                    boolean foundField = false;
                    int j = 0;
                    int referenceList = referencedConstraint.size();
                    while (j < referenceList) {
                        if (currentField.equals(referencedConstraint.get(j))) {
                            foundField = true;
                            break;
                        }
                        ++j;
                    }
                    if (!foundField) {
                        return NLS.bind((String)SMLValidationMessages.identityMissingKey, (Object[])new String[]{currentField, constraint.getName()});
                    }
                    ++i;
                }
                break;
            }
        }
        return null;
    }

    private String extractField(Node context, String field) {
        Node fieldNode;
        block6: {
            XPathExpression fieldXPath = SMLValidatorUtil.xpath.compile(field);
            NodeList nodeList = (NodeList)fieldXPath.evaluate(context, XPathConstants.NODESET);
            Node node = fieldNode = nodeList.getLength() == 1 ? nodeList.item(0) : null;
            if (fieldNode != null) break block6;
            return null;
        }
        try {
            if (field.charAt(0) == '@') {
                return fieldNode.getNodeValue();
            }
            NodeList childNodes = fieldNode.getChildNodes();
            StringBuffer fieldText = new StringBuffer();
            int i = 0;
            int chidNodeCount = childNodes.getLength();
            while (i < chidNodeCount) {
                Node currentNode = childNodes.item(0);
                if (3 != currentNode.getNodeType()) {
                    return field.toString();
                }
                fieldText.append(currentNode.getNodeValue() == null ? "" : currentNode.getNodeValue());
                ++i;
            }
            return fieldText.toString();
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    private Node findNode(Node node, int[] indices) {
        Node currentNode = node;
        NodeList nodeList = null;
        int i = 1;
        while (i < indices.length) {
            nodeList = node.getChildNodes();
            if (indices[i] < 0 || indices[i] >= nodeList.getLength()) {
                return null;
            }
            currentNode = nodeList.item(indices[i]);
            ++i;
        }
        return currentNode;
    }
}

