/*******************************************************************************
 * Copyright (c) 2007, 2008 CA Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.GraphResponseViewer");
dojo.require("dijit.layout.ContentPane");
dojo.require("dijit.TitlePane");
dojo.require("dojox.grid.Grid");
dojo.require("dojox.grid._data.model");
dojo.require("dijit.form.ComboBox");

 
dojo.declare(
	///////////
	// class //
	///////////	
	"org.eclipse.cosmos.provisional.dr.ps.components.widget.GraphResponseViewer",
	////////////////
	// superclass //
	////////////////
	[dijit._Widget, dijit._Templated, dijit._Container, dijit.form], 
	
	////////////////////////////////
	// member variables/functions //
	////////////////////////////////
	{
		widgetId: "",
		_message: dojo.i18n.getLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "widget"),
		titleNE: " ",
		titleRecords: " ",
		titleDetailsViewer: " ",
        titleART: " ",	
        detailsViewer:null,
        widgetsInTemplate: true,		// The html layout of the page is in GraphResponseView.html
		globalParams: "",				// so that all classes can get to the initQueryHandler

		// set member variable templatePath to where the template html is
		
		templatePath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.widget", "html/GraphResponseView.html"),
	
		///////////////////
		// METHOD create //
		///////////////////
		
		// The Create Method in class GraphResponseViewer receives the params and srcNodeRef
		// params contains all that is in the view.jprop file, it also containd the id
		// that the outputter creates, that determines which bit of json for that outputter to get.
		// (contextMap.object)  
		
		create: function(params, srcNodeRef) {
			this.gridEdgesNodes = dijit.byId(params.widgetId+"gridEdgesNodes");
			this.gridRecords = dijit.byId(params.widgetId+"gridRecords");
	        this.gridART = dijit.byId(params.widgetId+"gridART");
			if (this.gridEdgesNodes) this.gridEdgesNodes.destroy();
			if (this.gridRecords) this.gridRecords.destroy();
			if (this.gridART) this.gridART.destroy();
			// set globalParams to params and call the superclass
		    globalParams = params;
			org.eclipse.cosmos.provisional.dr.ps.components.widget.GraphResponseViewer.superclass.create.apply(this, arguments);
		},  // end create

		////////////////////////////////
		// METHOD postMixInProperties //
		////////////////////////////////
		
		postMixInProperties: function(){
			this.titleNE      = this._message.NODESANDEDGES;
			this.titleRecords = this._message.RECORDS;
			this.titleART     = this._message.ADDRECTYPES;
			this.titleDetailsViewer = this._message.DETAILSVIEW;
			org.eclipse.cosmos.provisional.dr.ps.components.widget.PropertyValueBuilder.superclass.postMixInProperties.apply(this, arguments);
		}, //end postMixInProperties
	
		
		///////////////////////
		// METHOD postCreate //
		///////////////////////

		// Call the super class and set up gridEdgesNodes and gridRecords, these
		// point to the id tag of the object.  So when you look at the html, look
		// at the ${widgetId}gridEdgesNodes, take the widgetId member variable
		// in this class, and it becomes GraphResponsegridEdgesNodes. 
		// Whenever we need to refer to this objects, we can refer to 
		// this.gridEdgesNodes and this.gridRecords
		
		postCreate: function(){
			//call superclass

			org.eclipse.cosmos.provisional.dr.ps.components.widget.GraphResponseViewer.superclass.postCreate.apply(this, arguments);
			this.gridEdgesNodes = dijit.byId(this.widgetId+"gridEdgesNodes");
			this.gridRecords = dijit.byId(this.widgetId+"gridRecords");
            this.gridART = dijit.byId(this.widgetId+"gridART");
		}, // end postCreate
		
		///////////////////////
		// Method Destroy    //
		///////////////////////
		
		//Need to destroy the child widgets properly
		destroy:function(){
			if (this.gridEdgesNodes) this.gridEdgesNodes.destroy();
			if (this.gridRecords) this.gridRecords.destroy();
			if (this.gridART) this.gridART.destroy();
			if (dijit.byId(this.widgetId+'datatestComboBox')) dijit.byId(this.widgetId+'datatestComboBox').destroy();
			if (dijit.byId(this.widgetId+'gridARTTitlePane')) dijit.byId(this.widgetId+'gridARTTitlePane').destroy();
			this.inherited(arguments);
		} // end Destroy
	}
);

dojo.declare(
		///////////
		// class //
		///////////	
		"org.eclipse.cosmos.provisional.dr.ps.components.widget.GridEdgesNodes",
		////////////////
		// superclass //
		////////////////	
		[dojox.Grid], 
		
		////////////////////////////////
		// member variables/functions //
		////////////////////////////////
		{
			myParams : "",
			_message: dojo.i18n.getLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "widget"),
			
			///////////////////
			// METHOD create //
			///////////////////
			
			create: function(params, srcNodeRef) {
		
			// view1 describes the layout of the gridEdgesNodes grid
			// It defines the fields that are in the grid.  These field names
			// must match with the names in the Json.

			var view1 = {
					cells: [[
						{name: this._message.COLSOURCE, width: "150px"}, {name: this._message.COLEDGE}, {name: this._message.COLTARGET, width: "20%"}
					]
				]
				};
			

			var _self = this;
			var _arguments = arguments;

			// Assuming that the initQueryHandler was set in the view.jprop file,
			// we have to append to the initQueryHandler an id. 
			// If for example you run more than 1 query, each 
			// result query will have a unique id.  So when you switch from 1 query 
			// to the next the id has to be picked up and appended.
			
			if (globalParams.initQueryHandler != null){
				
				var postData = "";
				if (globalParams.contextMap){
					if (globalParams.contextMap.queryResponse){
						postData = globalParams.initQueryHandler+"&queryResponse="+globalParams.contextMap.queryResponse;
					}
					//check if this is a response save in the history
					else if ((globalParams.contextMap.historyId) && (globalParams.contextMap.uuid)){
						postData = globalParams.initQueryHandler+"&uuid="+globalParams.contextMap.uuid[0]+"&historyId="+globalParams.contextMap.historyId;
					}
				}

				// This is where the json gets picked up
				// it gets stored in params.store
				globalParams.UIContext.submitQuery({queryObject: new org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery(
				{queryHandler:globalParams.initQueryHandler, postData:postData}), 
					onItem:function(items){
						params.store=new dojo.data.ItemFileReadStore({data:items});
						params.store.UIContext = globalParams.UIContext;
						// filter into the model all rows from the store, based on the query:
						
			    		params.model = new dojox.grid.data.DojoData(null,
							params.store , {
						           rowsPerPage: 20,
						           query: {
						                   Source: '*'
						                  },
						           clientSort: true
						    });
				    		
					    // a grid layout is an array of views.
						params.structure = [ view1 ];
						
						// store the results in the globalParams.store for later use
						
						globalParams.store = params.store;
						
						// call the super class
						
						org.eclipse.cosmos.provisional.dr.ps.components.widget.GridEdgesNodes.superclass.create.apply(_self, _arguments);
					}, queryProp:"query"});
						
	
					
	
			}
			else{
				org.eclipse.cosmos.provisional.dr.ps.components.widget.GridEdgesNodes.superclass.create.apply(_self, _arguments);
			}
			
			},		// end create METHOD

			///////////////////////
			// METHOD postCreate //
			///////////////////////			
			
			postCreate: function(){
				
				//call superclass
				
				org.eclipse.cosmos.provisional.dr.ps.components.widget.GridEdgesNodes.superclass.postCreate.apply(this, arguments);

				// associate the function processClicked with the onCellClick
				// event
				
				gId = this.domNode.id;
				gId = gId.substr(0,gId.indexOf("gridEdgesNodes"));
				
				dojo.connect(this, "onCellClick", this, dijit.byId(gId+"gridEdgesNodes").processClicked);
				
				// populate the combobox from the json
				
				dijit.byId(gId+"datatestComboBox").store = globalParams.store;				
			
				
		
			},  // end create METHOD
			
			
			///////////////////////////
			// METHOD processClicked //
			///////////////////////////			
			
			// when a cell is clicked in the GridEdgesNodes grid this gets called.
			//
			// The event object 'e' is passed
			
			processClicked: function(e){
				
				// pick up the contents of the cell that was clicked
				gId = this.domNode.id;
				gId = gId.substr(0,gId.indexOf("gridEdgesNodes"));
				
				var cellClicked = e.cellNode.innerHTML;
				
				// if the cell clicked was an edge, the index of the cell is 1
				// otherwise it will 0 or 2
				// set the three text fields. 
				
				
				if (e.cellIndex == 1) {
					document.getElementById(gId+"textTemplateID").innerHTML = cellClicked;
					document.getElementById(gId+"textlocalID").innerHTML = dijit.byId(gId+"gridEdgesNodes").model.data[e.rowIndex].EdgeId;			
				}
				else {
					document.getElementById(gId+"textTemplateID").innerHTML = cellClicked.substr(0, cellClicked.indexOf(":"));
					document.getElementById(gId+"textlocalID").innerHTML = cellClicked.substr(cellClicked.indexOf(":")+1,cellClicked.length);
				}
				document.getElementById(gId+"textMDRID").innerHTML = dijit.byId(gId+"gridEdgesNodes").model.data[e.rowIndex].MdrId;			
				
				// call the setRecordGrid method in the GridRecords object
				// pass it the value of the cell clicked, and the CosmosId.
				// The Cosmosid is a value that links the edge/node in the 
				// top grid, with the recordId in the Record Grid 
				
				if (cellClicked =="")
				{
					if(dijit.byId(gId+"gridARTTitlePane").open)
					{
						dijit.byId(gId+"gridARTTitlePane").toggle();
						dijit.byId(gId+"gridART").postCreate();
					}
				}
				else { 
			
					dijit.byId(gId+"gridRecords").setRecordGrid(cellClicked,dijit.byId(gId+"gridEdgesNodes").model.data[e.rowIndex].CosmosId,dijit.byId(gId+"gridEdgesNodes").model.data[e.rowIndex].TLSID,dijit.byId(gId+"gridEdgesNodes").model.data[e.rowIndex].TLTID,e.cellIndex);

					if (dijit.byId(gId+"gridEdgesNodes").model.data[e.rowIndex].ARTData == "Y")
					{

						if(!dijit.byId(gId+"gridARTTitlePane").open)
						{
							dijit.byId(gId+"gridARTTitlePane").toggle();
							dijit.byId(gId+"gridART").postCreate();
						}
						dijit.byId(gId+"gridART").setARTGrid(cellClicked,dijit.byId(gId+"gridEdgesNodes").model.data[e.rowIndex].CosmosId,dijit.byId(gId+"gridEdgesNodes").model.data[e.rowIndex].TLSID,dijit.byId(gId+"gridEdgesNodes").model.data[e.rowIndex].TLTID,e.cellIndex,gId);
					}
					else
					{
						if(dijit.byId(gId+"gridARTTitlePane").open)
						{
							dijit.byId(gId+"gridARTTitlePane").toggle();
							dijit.byId(gId+"gridART").postCreate();
						}
					}
					
					

				}
				
			},  // end processClicked METHOD
			
			////////////////////////////////
			// METHOD setNodesEdgesFilter //
			////////////////////////////////
			
			// this method is initiated when the combobox value gets changed.
			// in the GraphResponseViewer.html, there is a reference to this
			// depending on whether ALL, a Node, an Edge is selected, will 
			// depend on what filter query: is used.  Note that the 
			// globalParams.store is used.  This was create when the 
			// json was first read in the GridEdgesNodes create method.
			
			setNodesEdgesFilter: function(inString) {
				
				gId = this.domNode.id;
				gId = gId.substr(0,gId.indexOf("gridEdgesNodes"));
				
				grid = dijit.byId(gId+"gridRecords");
				grid.expandedRows = [ ];
				
				if (inString == "All") {
		   			model1 = new dojox.grid.data.DojoData(null,
		   				  globalParams.store , {
				           rowsPerPage: 20,
				           query: {
				                 Source: '*'
				            },
				           clientSort: true
		   				}
		   			);
				}
				else {
					if ((inString.substring(0,5)) == "Node:" ){
						var nodeName = inString.substring(6,inString.length);
			   			model1 = new dojox.grid.data.DojoData(null,
								globalParams.store , {
						           rowsPerPage: 20,
									query: {
										Source: nodeName+'*',
										Edge: ''
									},
						           clientSort: true
				   				}
				   			);
					}
					else {
						var edgeName = inString.substring(6,inString.length);
			   			model1 = new dojox.grid.data.DojoData(null,
								globalParams.store , {
						           rowsPerPage: 20,
									query: {
										Source: '*',
										Edge: edgeName
									},
						           clientSort: true
				   				}
				   			);
					}
				}
				
				
				// The model contains the data from the filtering 
				// set the grids model to this new model
				dijit.byId(gId+"gridEdgesNodes").setModel(model1);

			    // Because the combobox filter value changed, we have to
			    // blank-out the text fields as they should only be shown after
			    // a cell is selected in the top grid.
			    
				document.getElementById(gId+"textTemplateID").innerHTML = "";
				document.getElementById(gId+"textlocalID").innerHTML = "";
				document.getElementById(gId+"textMDRID").innerHTML = "";
				
			    // scroll up the ART Grid
				
				
				if(dijit.byId(gId+"gridARTTitlePane").open)
				{
					dijit.byId(gId+"gridARTTitlePane").toggle();
					dijit.byId(gId+"gridART").postCreate();
				}
				
				
				
				// we also have to blank-out the lower grid
				// this is achieved by defining an internal empty store,
				// its set to model2, and then assigned to the gridRecords 
				// grid (gridRecords.setModel(model2)).
				
				var emptyStore = new dojo.data.ItemFileReadStore({data:{
					identifier: "object",  label: "title",  items:[]}});
		        
				model2 = new dojox.grid.data.DojoData(null,
				emptyStore , {
		                    rowsPerPage: 20,
		                    query: {
		                          Source: '*'
		                    },
		                    clientSort: true
		        });
			
				dijit.byId(gId+"gridRecords").setModel(model2);
			}  // end setNodesEdgesFilter METHOD
		}
);

dojo.declare(
		///////////
		// class //
		///////////	
		"org.eclipse.cosmos.provisional.dr.ps.components.widget.GridRecords",
		////////////////
		// superclass //
		////////////////	
		[dojox.Grid], 
		
		////////////////////////////////
		// member variables/functions //
		////////////////////////////////
		
		{
			storeRecords: "",
			_message: dojo.i18n.getLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "widget"),
			saveStore: "",
			detailsService:"json?service=org/eclipse/cosmos/internal/dr/drs/service/outputter/RecordDetailsOutputter",
            xmlFormatString: null,			
			///////////////////
			// METHOD create //
			///////////////////
			
			create: function(params, srcNodeRef) {
			
			// view2 describes the layout of the gridRecords grid
			// It defines the fields that are in the grid.  These field names
			// must match with the names in the Json.			
			
						
			var view2 = {
					cells: [[
						{ name: '  ',  width: 4.5, get: this.getCheck, styles: 'text-align: center;' },
						{ name: this._message.COLRECORDID, width: "200px" },
						{ name: this._message.COLLASTMODIFIED},
						{ name: this._message.COLBASELINEID},
						{ name: this._message.COLSNAPSHOTID,  width: "15%"}
					],
					[ { name: this._message.COLDETAIL, colSpan: 5, get: this.getDetail } ]
				]
				};					
			
			// On Create, we need to show an empty grid. This is done by
			// assigning an empty store to the model.
				
         		var emptyStore = new dojo.data.ItemFileReadStore({data:{
					identifier: "object",  label: "title",  items:[]}});
			
    			params.model = new dojox.grid.data.DojoData(null,
    					emptyStore , {
                    rowsPerPage: 20,
                    query: {
                          Source: '*'
                    },
                    clientSort: true
    			});

		    	// a grid layout is an array of views.
			    params.structure = [ view2 ];
			    
			    
			    storeRecords = params;
			    saveStore = params.store;

			    // dont remove the next line
			    org.eclipse.cosmos.provisional.dr.ps.components.widget.GridRecords.superclass.create.apply(this, arguments);
			}, // end create METHOD
			
			///////////////////////
			// METHOD postCreate //
			///////////////////////			
						
			postCreate: function(){
				//call superclass
				dojo.connect(this, "onCellMouseOver", this, dijit.byId(globalParams.widgetId+"gridRecords").showTooltip);
				dojo.connect(this, "onCellMouseOut", this, dijit.byId(globalParams.widgetId+"gridRecords").hideTooltip);

				// dont remove the next line
				org.eclipse.cosmos.provisional.dr.ps.components.widget.GridRecords.superclass.postCreate.apply(this, arguments);
			}, // end postCreate METHOD 

			///////////////////////
			// METHOD getCheck   //
			///////////////////////			
			
			// this method sets up whether the details should be expanded or not
			// and returns the appropriate image of an open or closed gif file.
			
			getCheck: function(inRowIndex) {
				
				var gId = this.grid.domNode.id;

				if (!dijit.byId(gId).expandedRows){
					dijit.byId(gId).expandedRows = [ ];
				}

 
				var image = 'dndCopy.png';
				var imageloc = dojo.moduleUrl("dijit", "themes/tundra/images/" +image);
    
				var show = (dijit.byId(gId).expandedRows[inRowIndex] ? 'false' : 'true')
				var myGridRecords = gId;
			
				return '<img src="'+imageloc+ '" onclick="'+myGridRecords+'.displayDetails(' + inRowIndex + ', ' + show + ')" height="11" width="11">';				
				
			}, // end getCheck METHOD
			
			///////////////////////
			// METHOD getDetail  //
			///////////////////////		
			
			// this method returns the details of the record
			
			getDetail: function(inRowIndex) {
				return ''; 
			}, // end getDetail METHOD 


			///////////////////////////
			// METHOD showTooltip    //
			///////////////////////////			
			
			// when the mouse hovers over a cell in the GridRecords grid this gets called.
			//
			// The event object 'e' is passed
			
			showTooltip: function(e){
				
				
				var cellClicked = e.cellNode.innerHTML;
				
				if (e.cellIndex == 1)    // RecordId column
				{	
					if (cellClicked =="")
					{}
					else {
						var breakAfter = 30;
						var msg = "";
						var lenCellClicked = cellClicked.length;
						var i;
						for(i=0; i <= lenCellClicked; i+= breakAfter)
						{
							msg += cellClicked.substring(i,i+breakAfter);
							msg += "<br>";
						}
						dijit.showTooltip(msg, e.cellNode);

					}
				}
				
			},  // end showtooltip METHOD
			

			
			///////////////////////////
			// METHOD hideTooltip    //
			///////////////////////////			
			
			// when the mouse hovers over a cell in the GridRecords grid this gets called.
			//
			// The event object 'e' is passed
			
			hideTooltip: function(e){
				
				
				var cellClicked = e.cellNode.innerHTML;
				
				if (cellClicked =="")
				{}
				else {
					dijit.hideTooltip(e.cellNode);
					// FIXME: make sure that pesky tooltip doesn't reappear!
					// would be nice if there were a way to hide tooltip without regard to aroundNode.
					dijit._masterTT._onDeck = null;


				}
				
			},  // end hideTooltip METHOD
			

			///////////////////////////
			// METHOD displayDetails //
			///////////////////////////	
					
			// displays the details XML in the browser
			
			displayDetails: function(inIndex, inShow) {
				var gId = this.domNode.id;
				
				grid = dijit.byId(gId);
				grid.expandedRows[inIndex] = inShow;
				grid.updateRow(inIndex);
			
				var itemData = dijit.byId(gId).model.data[inIndex];
				var dialogTitle = " - " +this._message.COLRECORDID + ":"+itemData.recordId;
			    var result = itemData.Detail;
			    var u = unescape(result);
			    var xml = "<xml>" + u + "</xml>";
			    
			    this.xmlFormatString = globalParams.UIContext.xmlFormatter.format(xml);
			    //this.detailsViewer = new org.eclipse.cosmos.provisional.dr.ps.components.widget.RecordDetailsDialog({dialogTitle: dialogTitle, width: "600px", height: "600px",content_provider: this.detailsService+"&xmlIn="+result,xmlFormatString: this.xmlFormatString});
			    
			    this.detailsViewer = new org.eclipse.cosmos.provisional.dr.ps.components.widget.RecordDetailsDialog({dialogTitle: dialogTitle, width: "600px", height: "600px",xmlFormatString: unescape(this.xmlFormatString)});
				
				this.detailsViewer.show();	
				
			}, // end toggle displayDetails
			
			//////////////////////////
			// METHOD setRecordGrid //
			//////////////////////////		
			
			// Filters the recordid based on the passed parms
				
			setRecordGrid: function(inString, inCosmosId, inTLSID, inTLTID, inCellIndex)
			{
				gId = this.domNode.id;
				gId = gId.substr(0,gId.indexOf("gridRecords"));
				
				
				grid = dijit.byId(gId+"gridRecords");
				grid.expandedRows = [ ];
			        				
				if (inCellIndex == 0) {
					var model2 = new dojox.grid.data.DojoData(null,
							globalParams.store , {
				            rowsPerPage: 20,
				            query: {
									recordId: '*',
									TLSID: inTLSID
				                    },
				            clientSort: true
				        });
				}
				else {
					if (inCellIndex == 1) {					
						var edgeName = inString;
						model2 = new dojox.grid.data.DojoData(null,
								globalParams.store , {
				            rowsPerPage: 20,
							query: {
									recordId: '*',
									CosmosId: inCosmosId
							},
				            clientSort: true
				        });
					}
					else {
						var model2 = new dojox.grid.data.DojoData(null,
								globalParams.store , {
					            rowsPerPage: 20,
					            query: {
										recordId: '*',
										TLTID: inTLTID
					                    },
					            clientSort: true
					        });
					}
				}
				grid = dijit.byId(gId+"gridRecords");
    			grid.setModel(model2);
			}  // end setRecordGrid METHOD
		
		}
	
);

dojo.declare(
		///////////
		// class //
		///////////	
		"org.eclipse.cosmos.provisional.dr.ps.components.widget.GridART",
		////////////////
		// superclass //
		////////////////	
		[dojox.Grid], 
		
		////////////////////////////////
		// member variables/functions //
		////////////////////////////////
		
		{
			storeRecords: "",
			_message: dojo.i18n.getLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "widget"),
			saveStore: "",
			
			///////////////////
			// METHOD create //
			///////////////////
			
			create: function(params, srcNodeRef) {
			
			// view2 describes the layout of the gridRecords grid
			// It defines the fields that are in the grid.  These field names
			// must match with the names in the Json.			
			
			var view3 = {
					cells: [[
						{ name: this._message.COLNAMESPACE, 	 width: "250px" },
						{ name: this._message.COLLOCALNAME,     width: "50%"}
					]]
				};							
					
			
			// On Create, we need to show an empty grid. This is done by
			// assigning an empty store to the model.
				
         		var emptyStore = new dojo.data.ItemFileReadStore({data:{
					identifier: "object",  label: "title",  items:[]}});
			
    			params.model = new dojox.grid.data.DojoData(null,
    					emptyStore , {
                    rowsPerPage: 20,
                    query: {
                          NameSpace: '*'
                    },
                    clientSort: true
    			});

		    	// a grid layout is an array of views.
			    params.structure = [ view3 ];
			    
			    
			    storeRecords = params;
			    saveStore = params.store; 


			    
			    // dont remove the next line
			    org.eclipse.cosmos.provisional.dr.ps.components.widget.GridART.superclass.create.apply(this, arguments);
			}, // end create METHOD
			

		
			
			
			///////////////////////
			// METHOD postCreate //
			///////////////////////			
						
			postCreate: function(){
				//call superclass
				// dont remove the next line
				org.eclipse.cosmos.provisional.dr.ps.components.widget.GridART.superclass.postCreate.apply(this, arguments);
			}, // end postCreate METHOD 

					
			//////////////////////////
			// METHOD setRecordGrid //
			//////////////////////////		
			
			// Filters the recordid based on the passed parms
				
			setARTGrid: function(inString, inCosmosId, inTLSID, inTLTID, inCellIndex, gId)
			{
			        				
				if (inCellIndex == 0) {
					var model3 = new dojox.grid.data.DojoData(null,
							globalParams.store , {
				            rowsPerPage: 20,
							query: {
								NameSpace: '*',
								TLSID: inTLSID,
								TLTID: ""
							},
							clientSort: true
				        });
				}
				else {
					if (inCellIndex == 1) {					
						var edgeName = inString;
						model3 = new dojox.grid.data.DojoData(null,
								globalParams.store , {
				            rowsPerPage: 20,
							query: {
								NameSpace:'*',
								CosmosId: inCosmosId
							},
				            clientSort: true
				        });
					}
					else {
						
						var model3 = new dojox.grid.data.DojoData(null,
							globalParams.store , {
					           rowsPerPage: 20,
							query: {
								NameSpace: '*',
								TLSID: inTLTID,
								TLTID: ""

							},
							clientSort: true
				        });
						

					}
				}
				
				grid = dijit.byId(gId+"gridART");
   				grid.setModel(model3);
			}  // end setARTGrid METHOD
		
		}
	
);

