/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.smlif.editor;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.cosmos.rm.internal.smlif.SMLImages;
import org.eclipse.cosmos.rm.internal.smlif.SMLPlugin;
import org.eclipse.cosmos.rm.internal.smlif.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.internal.smlif.common.SMLMessages;
import org.eclipse.cosmos.rm.internal.smlif.dialogs.ResourceSelectionDialog;
import org.eclipse.cosmos.rm.internal.smlif.editor.AbstractFormPage;
import org.eclipse.cosmos.rm.internal.smlif.editor.SMLFormToolkit;
import org.eclipse.cosmos.rm.internal.smlif.editor.SMLIFEditor;
import org.eclipse.cosmos.rm.internal.smlif.editor.XMLLineStyler;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.common.XMLInternalUtility;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentsPage
extends AbstractFormPage
implements SelectionListener,
ISelectionChangedListener {
    private static final int INSTANCES_CHOICE = 3;
    private static final int DEFINITIONS_CHOICE = 2;
    public static final String ID = "org.eclipse.cosmos.rm.smlif.DocumentsPage";
    private static final byte OPERATION_ADD_DOCUMENT = 0;
    private static final byte OPERATION_REMOVE_DOCUMENT = 1;
    private static final byte OPERATION_ADD_ALIASES = 2;
    private static final byte OPERATION_REMOVE_ALIASES = 3;
    private static final byte OPERATION_MODIFY_ALIAS = 4;
    private Table aliasTable;
    private StyledText rawStyledText;
    private TreeViewer logicalRepresentation;
    private Node input;
    private Button addAlias;
    private Button removeAlias;
    private Map<String, int[]> indices = new Hashtable<String, int[]>();
    private TreeViewer documentTreeViewer;
    private CheckboxTableViewer tableViewer;
    private FilteredTree documentTree;

    public DocumentsPage(FormEditor editor) {
        super(editor, ID, SMLMessages.editorDocumentTitle);
    }

    protected void setWeight(SashForm sashForm) {
        sashForm.setWeights(new int[]{40, 60});
    }

    protected void createLeftColumn(Composite parent) {
        this.getManagedForm().addPart((IFormPart)((SMLIFEditor)this.getEditor()).getSmlifFormPart());
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = this.createSection(parent);
        Composite sectionClient = toolkit.createComposite((Composite)section, 0);
        sectionClient.setLayout((Layout)new GridLayout());
        sectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.createLabel(sectionClient, SMLMessages.editorFilterLabel);
        this.documentTree = new FilteredTree(sectionClient, 2052, new PatternFilter());
        this.documentTreeViewer = this.documentTree.getViewer();
        this.documentTreeViewer.setContentProvider((IContentProvider)new DocumentContentProvider());
        this.documentTreeViewer.setLabelProvider((IBaseLabelProvider)new DocumentLabelProvider());
        this.documentTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.documentTreeViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof DocumentTreeElement && e2 instanceof DocumentTreeElement) {
                    return ((DocumentLabelProvider)DocumentsPage.this.documentTreeViewer.getLabelProvider()).getText(e1).compareTo(((DocumentLabelProvider)DocumentsPage.this.documentTreeViewer.getLabelProvider()).getText(e2));
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.documentTreeViewer.setInput((Object)this.getEditor());
        Menu documentContextMenu = new Menu((Control)this.documentTreeViewer.getTree());
        this.documentTreeViewer.getTree().setMenu(documentContextMenu);
        final MenuItem addDocument = this.createMenuItem(documentContextMenu, SMLMessages.editorAddDocument, (byte)0);
        final MenuItem removeDocument = this.createMenuItem(documentContextMenu, SMLMessages.editorRemoveDocument, (byte)1);
        documentContextMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                DocumentTreeElement selection = (DocumentTreeElement)((StructuredSelection)DocumentsPage.this.documentTreeViewer.getSelection()).getFirstElement();
                boolean noSelection = selection == null;
                boolean rootSelected = selection != null && selection.isRootElement();
                addDocument.setEnabled(rootSelected || noSelection);
                addDocument.setImage(rootSelected || noSelection ? SMLImages.INSTANCE.getImage("c", "add.gif") : SMLImages.INSTANCE.getImage("d", "add.gif"));
                removeDocument.setEnabled(!rootSelected);
                removeDocument.setImage(!rootSelected ? SMLImages.INSTANCE.getImage("c", "remove.gif") : SMLImages.INSTANCE.getImage("d", "remove.gif"));
            }
        });
        this.makeSectionReady(section, sectionClient, SMLMessages.editorDocuments);
    }

    private MenuItem createMenuItem(Menu parent, String text, byte operation) {
        MenuItem menuItem = new MenuItem(parent, 0);
        menuItem.setText(text);
        menuItem.addSelectionListener((SelectionListener)this);
        menuItem.setData((Object)new Byte(operation));
        return menuItem;
    }

    private Button createButton(Composite parent, String text, SelectionListener listener, byte operation, boolean enabled) {
        Button button = this.getManagedForm().getToolkit().createButton(parent, text, 0);
        button.setLayoutData((Object)new GridData(4, -1, true, false));
        button.addSelectionListener(listener);
        button.setData((Object)new Byte(operation));
        button.setEnabled(enabled);
        GridData layoutData = new GridData(-1, -1, true, false);
        layoutData.widthHint = 100;
        layoutData.horizontalAlignment = 131072;
        button.setLayoutData((Object)layoutData);
        return button;
    }

    protected void createRightColumn(Composite parent) {
        SMLFormToolkit toolkit = ((SMLIFEditor)this.getEditor()).getExtendedToolkit();
        SashForm sashForm = toolkit.createSashForm(parent, 512);
        sashForm.setLayout((Layout)new GridLayout());
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Section logicalSection = this.createSection((Composite)sashForm);
        Composite logicalClient = toolkit.createComposite((Composite)logicalSection);
        logicalClient.setLayout((Layout)new GridLayout());
        logicalClient.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.createLabel(logicalClient, SMLMessages.editorAliases);
        Composite aliasComposite = toolkit.createComposite(logicalClient);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        aliasComposite.setLayout((Layout)gridLayout);
        aliasComposite.setLayoutData((Object)new GridData(4, -1, true, false));
        this.aliasTable = toolkit.createTable(aliasComposite, 2);
        this.aliasTable.setLinesVisible(true);
        this.aliasTable.setHeaderVisible(true);
        this.setTableProperties();
        Composite buttonComposite = toolkit.createComposite(aliasComposite);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)gridLayout);
        GridData buttonCompositeGD = new GridData();
        buttonCompositeGD.verticalAlignment = 128;
        buttonCompositeGD.horizontalAlignment = 131072;
        buttonComposite.setLayoutData((Object)buttonCompositeGD);
        this.addAlias = this.createButton(buttonComposite, SMLMessages.editorAddButton, this, (byte)2, false);
        this.removeAlias = this.createButton(buttonComposite, SMLMessages.editorRemoveButton, this, (byte)3, false);
        this.aliasTable.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DocumentsPage.this.removeAlias.setEnabled(DocumentsPage.this.aliasTable.getSelection() != null && DocumentsPage.this.aliasTable.getSelection().length > 0);
            }

            public void focusLost(FocusEvent e) {
                DocumentsPage.this.removeAlias.setEnabled(DocumentsPage.this.aliasTable.getSelection() != null && DocumentsPage.this.aliasTable.getSelection().length > 0);
            }
        });
        this.aliasTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DocumentsPage.this.removeAlias.setEnabled(DocumentsPage.this.aliasTable.getSelection() != null && DocumentsPage.this.aliasTable.getSelection().length > 0);
            }
        });
        toolkit.createLabel(logicalClient, SMLMessages.editorLogicalTree);
        Tree logicalTree = toolkit.createTree(logicalClient, 0);
        logicalTree.setLayout((Layout)new GridLayout());
        logicalTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.logicalRepresentation = new TreeViewer(logicalTree);
        this.logicalRepresentation.setContentProvider((IContentProvider)new LogicalContentProvider());
        this.logicalRepresentation.setLabelProvider((IBaseLabelProvider)new LogicalLabelProvider());
        this.logicalRepresentation.addSelectionChangedListener((ISelectionChangedListener)new LogicalSelectionListener());
        this.makeSectionReady(logicalSection, logicalClient, SMLMessages.editorLogicalRepresentation);
        Section rawSection = this.createSection((Composite)sashForm);
        Composite rawSectionClient = toolkit.createComposite((Composite)rawSection);
        rawSectionClient.setLayout((Layout)new GridLayout());
        rawSectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        SMLIFEditor editor = (SMLIFEditor)this.getEditor();
        this.rawStyledText = editor.getExtendedToolkit().createStyledtext(rawSectionClient, null, 2816);
        this.rawStyledText.setLayout((Layout)new GridLayout());
        this.rawStyledText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.rawStyledText.addLineStyleListener((LineStyleListener)new XMLLineStyler());
        this.rawStyledText.setFont(new Font((Device)Display.getDefault(), "Courier New", 10, 0));
        this.rawStyledText.setEditable(false);
        this.makeSectionReady(rawSection, rawSectionClient, SMLMessages.editorXMLRepresentation);
    }

    private void setTableProperties() {
        TableLayout layout = new TableLayout();
        this.aliasTable.setLayout((Layout)layout);
        GridData aliasTableGD = new GridData(4, 4, true, true);
        aliasTableGD.heightHint = 50;
        this.aliasTable.setLayoutData((Object)aliasTableGD);
        ColumnPixelData columnLayout = new ColumnPixelData(300, true);
        layout.addColumnData((ColumnLayoutData)columnLayout);
        TableColumn column = new TableColumn(this.aliasTable, 0, 0);
        column.setResizable(columnLayout.resizable);
        column.setText(SMLMessages.editorName);
        this.tableViewer = new CheckboxTableViewer(this.aliasTable);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private Object input;

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.input = newInput;
            }

            public Object[] getElements(Object inputElement) {
                if (!(this.input instanceof Node)) {
                    return new Object[0];
                }
                Node aliasesNode = (Node)this.input;
                NodeList aliases = null;
                if (aliasesNode == null || (aliases = aliasesNode.getChildNodes()) == null || aliases.getLength() <= 0) {
                    return new Object[0];
                }
                ArrayList<String> aliasTxt = new ArrayList<String>();
                int i = 0;
                int aliasCount = aliases.getLength();
                while (i < aliasCount) {
                    Node currentAlias = aliases.item(i);
                    if (currentAlias.getNodeType() != 3) {
                        String alias = SMLCommonUtil.retrieveTextNode(currentAlias);
                        aliasTxt.add(alias);
                    }
                    ++i;
                }
                return aliasTxt.toArray(new String[aliasTxt.size()]);
            }
        });
        class AliasLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            AliasLabelProvider() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                return element.toString();
            }
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AliasLabelProvider());
        this.tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.aliasTable)});
        this.tableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                TableItem[] tableItem = DocumentsPage.this.aliasTable.getSelection();
                if (tableItem == null || tableItem.length != 1) {
                    return null;
                }
                return tableItem[0].getText(0);
            }

            public void modify(Object element, String property, Object value) {
                TableItem[] tableItem = DocumentsPage.this.aliasTable.getSelection();
                if (tableItem == null || tableItem.length != 1 || tableItem[0].getText().equals((String)value)) {
                    return;
                }
                DocumentsPage.this.handleOperation((byte)4, new Object[]{value});
            }
        });
        this.tableViewer.setColumnProperties(new String[]{"ALIAS_COLUMN"});
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.handleOperation((Byte)e.widget.getData(), null);
    }

    private boolean handleOperation(byte operation, Object[] arguments) {
        switch (operation) {
            case 0: {
                Tree documentTree = this.documentTreeViewer.getTree();
                TreeItem[] selection = documentTree.getSelection();
                boolean noSelection = selection == null || selection.length <= 0;
                boolean definitionsSelected = false;
                if (noSelection) {
                    int result = this.promptForDocumentType();
                    if (result == 1) {
                        return false;
                    }
                    definitionsSelected = result == 2;
                } else {
                    definitionsSelected = documentTree.indexOf(selection[0]) == 0;
                }
                ResourceSelectionDialog resourceDialog = new ResourceSelectionDialog(SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), definitionsSelected ? 0 : 1);
                resourceDialog.setMultiSelection(true);
                IFile[] selectedFile = resourceDialog.open();
                if (selectedFile == null || selectedFile.length <= 0) {
                    return false;
                }
                SMLIFEditor editor = (SMLIFEditor)this.getEditor();
                String parentNodeName = definitionsSelected ? "definitions" : "instances";
                Node rootNode = SMLCommonUtil.nestedNodeRetrieval(editor.getDocumentNode(), new String[][]{{"http://www.w3.org/2008/03/sml-if", parentNodeName}}, true, false, null);
                if (rootNode == null) {
                    MessageDialog.openError((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.errorAddingDocumentTitle, (String)SMLMessages.errorAddingDocument0);
                    return false;
                }
                IFile file = null;
                try {
                    int i = 0;
                    while (i < selectedFile.length) {
                        file = selectedFile[i];
                        Node documentNode = SMLCommonUtil.createElement(rootNode, "http://www.w3.org/2008/03/sml-if", "document");
                        Node dataNode = SMLCommonUtil.createElement(documentNode, "http://www.w3.org/2008/03/sml-if", "data");
                        this.adoptNode(dataNode.getOwnerDocument(), dataNode, XMLInternalUtility.domParseDocument((InputStream)file.getContents(), (boolean)false, (boolean)true).getFirstChild());
                        ++i;
                    }
                }
                catch (Exception e) {
                    SMLCommonUtil.openErrorWithDetail(SMLMessages.errorAddingDocumentTitle, NLS.bind((String)SMLMessages.errorAddingDocument1, (Object)(file == null ? "" : file.getName())), e);
                    return false;
                }
                this.endOperation(true, definitionsSelected);
                break;
            }
            case 1: {
                Tree documentTree = this.documentTreeViewer.getTree();
                TreeItem[] selections = documentTree.getSelection();
                if (selections == null || selections.length <= 0) {
                    return false;
                }
                if (!MessageDialog.openQuestion((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.editorRemoveDocumentTitle, (String)SMLMessages.editorRemoveDocumentQuestion)) {
                    return false;
                }
                TreeItem parentItem = selections[0].getParentItem();
                int documentIndex = parentItem == null ? -1 : parentItem.indexOf(selections[0]);
                SMLIFEditor editor = (SMLIFEditor)this.getEditor();
                Node rootNode = documentIndex < 0 ? null : editor.retrieveChildNode("http://www.w3.org/2008/03/sml-if", documentTree.indexOf(parentItem) == 0 ? "definitions" : "instances");
                Node[] rootChildren = null;
                if (rootNode == null || documentIndex < 0 || (rootChildren = SMLValidatorUtil.retrieveChildElements((Node)rootNode)) == null || documentIndex >= rootChildren.length) {
                    MessageDialog.openError((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.errorRemovingDocumentTitle, (String)SMLMessages.errorRemovingDocument0);
                }
                rootNode.removeChild(rootChildren[documentIndex]);
                this.endOperation(true, documentTree.indexOf(parentItem) == 0);
                break;
            }
            case 2: {
                Node dataElement = SMLCommonUtil.nestedNodeRetrieval(this.input, new String[][]{{"http://www.w3.org/2008/03/sml-if", "data"}}, false, false, null);
                Node docInfoElement = SMLCommonUtil.nestedNodeRetrieval(this.input, new String[][]{{"http://www.w3.org/2008/03/sml-if", "docinfo"}}, true, false, dataElement);
                Node aliases = SMLCommonUtil.nestedNodeRetrieval(docInfoElement, new String[][]{{"http://www.w3.org/2008/03/sml-if", "aliases"}}, true, false, null);
                Document ownerDocument = aliases.getOwnerDocument();
                Node aliasElement = SMLCommonUtil.createFormattedElement(aliases, "http://www.w3.org/2008/03/sml-if", "alias", true, null);
                aliasElement.appendChild(ownerDocument.createTextNode(String.valueOf(this.getFirstChildElementName(dataElement)) + SMLMessages.editorAlias));
                if (this.aliasTable.getItemCount() == 0) {
                    this.refreshContent();
                }
                this.endOperation(false, false);
                break;
            }
            case 3: {
                if (this.input == null) {
                    return false;
                }
                Node aliases = SMLCommonUtil.nestedNodeRetrieval(this.input, new String[][]{{"http://www.w3.org/2008/03/sml-if", "docinfo"}, {"http://www.w3.org/2008/03/sml-if", "aliases"}});
                if (aliases == null) {
                    MessageDialog.openError((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.errorRemoving, (String)SMLMessages.errorRemovingAlias1);
                    return false;
                }
                TableItem[] selection = this.aliasTable.getSelection();
                if (selection.length <= 0) {
                    MessageDialog.openError((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.errorRemoving, (String)SMLMessages.errorRemovingAlias2);
                    return false;
                }
                boolean refreshContent = false;
                int i = 0;
                while (i < selection.length) {
                    int inx = this.aliasTable.indexOf(selection[i]);
                    NodeList aliasList = aliases.getChildNodes();
                    int counter = -1;
                    Node currentAlias = null;
                    int j = 0;
                    int aliasCount = aliasList.getLength();
                    while (j < aliasCount && counter != inx) {
                        currentAlias = aliasList.item(j);
                        if (currentAlias.getNodeType() == 1) {
                            ++counter;
                        }
                        ++j;
                    }
                    if (counter != inx) {
                        MessageDialog.openError((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.errorRemoving, (String)SMLMessages.errorRemovingAlias1);
                        return false;
                    }
                    currentAlias.getParentNode().removeChild(currentAlias);
                    this.aliasTable.remove(inx);
                    refreshContent = refreshContent || inx == 0;
                    ++i;
                }
                if (this.aliasTable.getItemCount() == 0) {
                    Node parentOfAliases = aliases.getParentNode();
                    parentOfAliases.removeChild(aliases);
                    if (parentOfAliases.getLocalName().equals("docinfo")) {
                        boolean docInfoChildFound = false;
                        NodeList docInfoElements = parentOfAliases.getChildNodes();
                        int i2 = 0;
                        while (i2 < docInfoElements.getLength()) {
                            if (docInfoElements.item(i2).getNodeType() == 1) {
                                docInfoChildFound = true;
                                break;
                            }
                            ++i2;
                        }
                        if (!docInfoChildFound) {
                            parentOfAliases.getParentNode().removeChild(parentOfAliases);
                        }
                    }
                }
                if (refreshContent) {
                    this.refreshContent();
                }
                this.endOperation(true, false);
                this.removeAlias.setEnabled(false);
                break;
            }
            case 4: {
                Node aliases = SMLCommonUtil.nestedNodeRetrieval(this.input, new String[][]{{"http://www.w3.org/2008/03/sml-if", "docinfo"}, {"http://www.w3.org/2008/03/sml-if", "aliases"}});
                TableItem[] selection = this.aliasTable.getSelection();
                int selectionInx = selection == null || selection.length != 1 ? -1 : this.aliasTable.indexOf(selection[0]);
                Node[] aliasList = SMLValidatorUtil.retrieveChildElements((Node)aliases);
                if (aliases == null || selectionInx < 0 || selectionInx >= aliasList.length) {
                    MessageDialog.openError((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.errorModifyingAliasTitle, (String)SMLMessages.errorModifyingAlias0);
                    if (selectionInx >= 0) {
                        this.aliasTable.remove(selectionInx);
                    }
                    return false;
                }
                NodeList aliasChildNodes = aliasList[selectionInx].getChildNodes();
                int i = 0;
                int aliasChildNodeCount = aliasChildNodes.getLength();
                while (i < aliasChildNodeCount) {
                    aliasList[selectionInx].removeChild(aliasChildNodes.item(i));
                    ++i;
                }
                aliasList[selectionInx].appendChild(aliasList[selectionInx].getOwnerDocument().createTextNode((String)arguments[0]));
                if (selectionInx == 0) {
                    this.refreshContent(aliasChildNodes.item(0).getNodeValue());
                }
                this.endOperation(false, false);
            }
        }
        return true;
    }

    private int promptForDocumentType() {
        Dialog prompter = new Dialog(SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell()){

            protected void createButtonsForButtonBar(Composite parent) {
                this.createButton(parent, 2, SMLMessages.editorDocTypeDlgButtonDefinitions, true);
                this.createButton(parent, 3, SMLMessages.editorDocTypeDlgButtonInstances, false);
                this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            }

            protected void buttonPressed(int buttonId) {
                this.setReturnCode(buttonId);
                this.close();
            }

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText(SMLMessages.editorDocTypeDlgTitle);
            }

            protected Control createDialogArea(Composite parent) {
                Composite container = (Composite)super.createDialogArea(parent);
                GridLayout gridLayout = new GridLayout();
                gridLayout.numColumns = 1;
                container.setLayout((Layout)gridLayout);
                Label promptLabel = new Label(container, 0);
                promptLabel.setText(SMLMessages.editorDocTypeDlgPromptText);
                return container;
            }
        };
        return prompter.open();
    }

    private String getFirstChildElementName(Node dataElement) {
        Node child = dataElement.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                return child.getNodeName();
            }
            child = child.getNextSibling();
        }
        return "";
    }

    private void endOperation(boolean refreshDocuments, boolean expandRoot) {
        if (refreshDocuments) {
            this.documentTreeViewer.refresh();
            this.expandRootElement(expandRoot);
        } else {
            Node aliases = SMLCommonUtil.nestedNodeRetrieval(this.input, new String[][]{{"http://www.w3.org/2008/03/sml-if", "docinfo"}, {"http://www.w3.org/2008/03/sml-if", "aliases"}}, true, false, null);
            this.tableViewer.setInput((Object)aliases);
        }
        SMLIFEditor editor = (SMLIFEditor)this.getEditor();
        IDocument document = editor.getSmlifSourcePage().getDocument();
        StringBuffer buffer = new StringBuffer();
        XMLInternalUtility.serializeNode((StringBuffer)buffer, (Node)editor.getDocumentNode().getOwnerDocument());
        document.set(buffer.toString());
    }

    private void refreshContent() {
        this.refreshContent(null);
    }

    private void refreshContent(String nodeValue) {
        Tree documentTree = this.documentTreeViewer.getTree();
        TreeItem[] selection = documentTree.getSelection();
        int selectionInx = selection[0].getParentItem().indexOf(selection[0]);
        if (selection != null && selection.length > 0) {
            boolean definitionsSelected = documentTree.indexOf(selection[0].getParentItem()) == 0;
            this.documentTreeViewer.refresh();
            this.expandRootElement(definitionsSelected);
            Event event = new Event();
            event.type = 13;
            event.widget = documentTree;
            TreeItem rootItem = documentTree.getItem(definitionsSelected ? 0 : 1);
            int inx = -1;
            if (nodeValue != null) {
                TreeItem[] children = rootItem.getItems();
                int i = 0;
                while (i < children.length) {
                    if (nodeValue.equals(children[i].getText())) {
                        inx = i;
                        break;
                    }
                    ++i;
                }
            }
            inx = inx < 0 ? selectionInx : inx;
            event.item = rootItem.getItem(inx);
            documentTree.setSelection((TreeItem)event.item);
            documentTree.notifyListeners(event.type, event);
        }
    }

    private void expandRootElement(boolean definitionsSelected) {
        int expandedInx;
        Tree documentTree = this.documentTreeViewer.getTree();
        int n = expandedInx = definitionsSelected ? 0 : 1;
        if (expandedInx < documentTree.getItemCount()) {
            Event event = new Event();
            event.type = 17;
            event.widget = documentTree;
            event.item = documentTree.getItem(expandedInx);
            documentTree.getItem(expandedInx).setExpanded(true);
            documentTree.notifyListeners(event.type, event);
        }
    }

    private void adoptNode(Document document, Node parent, Node node) {
        switch (node.getNodeType()) {
            case 3: {
                String value = node.getNodeValue();
                if (value == null) {
                    return;
                }
                parent.appendChild(document.createTextNode(value));
                break;
            }
            case 8: {
                String value = node.getNodeValue();
                if (value == null) {
                    return;
                }
                parent.appendChild(document.createComment(value));
                break;
            }
            case 1: {
                NodeList children;
                Element clonedNode = document.createElementNS(node.getNamespaceURI(), node.getNodeName());
                clonedNode.setPrefix(node.getPrefix());
                NamedNodeMap attributes = node.getAttributes();
                if (attributes != null) {
                    int i = 0;
                    int attCount = attributes.getLength();
                    while (i < attCount) {
                        this.adoptNode(document, clonedNode, attributes.item(i));
                        ++i;
                    }
                }
                if ((children = node.getChildNodes()) != null) {
                    int i = 0;
                    int childCount = children.getLength();
                    while (i < childCount) {
                        this.adoptNode(document, clonedNode, children.item(i));
                        ++i;
                    }
                }
                parent.appendChild(clonedNode);
                break;
            }
            case 2: {
                Attr clonedNode = document.createAttributeNS(node.getNamespaceURI(), node.getNodeName());
                clonedNode.setNodeValue(node.getNodeValue());
                parent.getAttributes().setNamedItemNS(clonedNode);
            }
        }
    }

    private boolean isDefinitionOrInstance(Object element) {
        Node node = null;
        return element instanceof DocumentTreeElement && (node = ((DocumentTreeElement)element).getNode()) != null && "http://www.w3.org/2008/03/sml-if".equals(node.getNamespaceURI()) && ("definitions".equals(node.getLocalName()) || "instances".equals(node.getLocalName()));
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        StructuredSelection structuredSelection = null;
        if (!selection.isEmpty() && selection instanceof StructuredSelection && (structuredSelection = (StructuredSelection)selection).size() > 0) {
            DocumentTreeElement input = (DocumentTreeElement)structuredSelection.getFirstElement();
            this.setControlEnabble(!input.isRootElement());
            this.setInput(input.isRootElement() ? null : input.getNode());
        } else {
            this.setInput(null);
        }
    }

    private void setControlEnabble(boolean enable) {
        this.addAlias.setEnabled(enable);
        this.rawStyledText.setEnabled(enable);
    }

    private void setInput(Object input) {
        String whitespace;
        this.aliasTable.removeAll();
        this.tableViewer.setInput((Object)SMLCommonUtil.nestedNodeRetrieval((Node)input, new String[][]{{"http://www.w3.org/2008/03/sml-if", "docinfo"}, {"http://www.w3.org/2008/03/sml-if", "aliases"}}));
        this.input = (Node)input;
        this.logicalRepresentation.setInput(input);
        this.indices.clear();
        Node[] node = null;
        if (input == null || (node = this.extractDocumentContent((Node)input)).length <= 0) {
            this.rawStyledText.setText("");
            return;
        }
        StringBuffer sb = new StringBuffer();
        Node lastChildElement = node[0].getLastChild();
        if (XMLInternalUtility.isWhitespace((Node)lastChildElement) && (whitespace = lastChildElement.getNodeValue()) != null) {
            sb.append(whitespace);
        }
        XMLInternalUtility.serializeNode((StringBuffer)sb, (Node)node[0], (int)0, (String)"0", this.indices, (boolean)false);
        this.rawStyledText.setText(sb.toString());
    }

    private Node[] extractDocumentContent(Node documentNode) {
        Node dataNode = SMLCommonUtil.retrieveChildNode(documentNode, "http://www.w3.org/2008/03/sml-if", "data");
        Node[] elements = SMLValidatorUtil.retrieveChildElements((Node)dataNode);
        if (elements.length <= 0) {
            Node[] nodeArray;
            dataNode = SMLCommonUtil.retrieveChildNode(this.input, "http://www.w3.org/2008/03/sml-if", "locator");
            if (dataNode == null) {
                nodeArray = new Node[]{};
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = dataNode;
            }
            return nodeArray;
        }
        return elements;
    }

    protected void updateContent() {
        if (this.documentTreeViewer != null && !this.documentTreeViewer.getTree().isDisposed()) {
            this.documentTreeViewer.refresh();
        }
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.documentTree.getFilterControl().setFocus();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DocumentContentProvider
    implements ITreeContentProvider {
        private DocumentContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            Node node = ((DocumentTreeElement)parent).getNode();
            if (node == null) {
                return new Object[0];
            }
            ArrayList<DocumentTreeElement> children = new ArrayList<DocumentTreeElement>();
            NodeList nodeChildren = node.getChildNodes();
            int i = 0;
            int childCount = nodeChildren.getLength();
            while (i < childCount) {
                Node currentChildNode = nodeChildren.item(i);
                if (currentChildNode.getNodeType() == 1) {
                    DocumentTreeElement element = new DocumentTreeElement();
                    element.setNode(nodeChildren.item(i));
                    children.add(element);
                }
                ++i;
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return DocumentsPage.this.isDefinitionOrInstance(element);
        }

        public Object[] getElements(Object inputElement) {
            SMLIFEditor editor = (SMLIFEditor)DocumentsPage.this.getEditor();
            ArrayList<DocumentTreeElement> elements = new ArrayList<DocumentTreeElement>();
            this.addElement(elements, editor.retrieveChildNode("http://www.w3.org/2008/03/sml-if", "definitions"), SMLMessages.editorDefinitions);
            this.addElement(elements, editor.retrieveChildNode("http://www.w3.org/2008/03/sml-if", "instances"), SMLMessages.editorInstances);
            return elements.toArray();
        }

        private void addElement(List<DocumentTreeElement> elements, Node node, String text) {
            if (node == null) {
                return;
            }
            DocumentTreeElement element = new DocumentTreeElement(true);
            element.setText(text);
            element.setNode(node);
            elements.add(element);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class DocumentLabelProvider
    implements ILabelProvider {
        private DocumentLabelProvider() {
        }

        public Image getImage(Object element) {
            if (DocumentsPage.this.isDefinitionOrInstance(element)) {
                return "definitions".equals(((DocumentTreeElement)element).getNode().getLocalName()) ? SMLImages.INSTANCE.getImage("genics.gif") : SMLImages.INSTANCE.getImage("phenics.gif");
            }
            return SMLImages.INSTANCE.getImage("doc.gif");
        }

        public String getText(Object element) {
            DocumentTreeElement treeElement = (DocumentTreeElement)element;
            if (treeElement.getText() != null) {
                return treeElement.getText();
            }
            return treeElement.retrieveLabel();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static class DocumentTreeElement {
        private Node node;
        private String text;
        private boolean rootElement;

        public DocumentTreeElement() {
        }

        public DocumentTreeElement(boolean rootElement) {
            this.rootElement = rootElement;
        }

        public String retrieveLabel() {
            if (this.node == null) {
                return null;
            }
            Node alias = SMLCommonUtil.nestedNodeRetrieval(this.node, new String[][]{{"http://www.w3.org/2008/03/sml-if", "docinfo"}, {"http://www.w3.org/2008/03/sml-if", "aliases"}, {"http://www.w3.org/2008/03/sml-if", "alias"}});
            this.text = SMLCommonUtil.retrieveTextNode(alias);
            if (this.text != null && this.text.length() > 0) {
                return this.text;
            }
            Node childNode = SMLCommonUtil.retrieveChildNode(this.node, "http://www.w3.org/2008/03/sml-if", "data");
            if (childNode == null) {
                childNode = SMLCommonUtil.retrieveChildNode(this.node, "http://www.w3.org/2008/03/sml-if", "locator");
                if (childNode == null) {
                    return SMLMessages.commonUnknown;
                }
                Node reference = childNode.getAttributes().getNamedItemNS("http://www.w3.org/1999/xlink", "href");
                return reference == null ? SMLMessages.commonUnknown : String.valueOf(SMLMessages.editorRemoteDoc) + reference.getNodeValue();
            }
            NodeList children = childNode.getChildNodes();
            String text = this.retrieveElementName(children);
            return text == null ? SMLMessages.commonUnknown : text;
        }

        private String retrieveElementName(NodeList children) {
            int i = 0;
            int childCount = children.getLength();
            while (i < childCount) {
                Node node = children.item(i);
                if (node.getNodeType() != 3 && node.getLocalName() != null) {
                    return node.getLocalName();
                }
                ++i;
            }
            return null;
        }

        public Node getNode() {
            return this.node;
        }

        public void setNode(Node node) {
            this.node = node;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean isRootElement() {
            return this.rootElement;
        }
    }

    private class LogicalContentProvider
    implements ITreeContentProvider {
        private LogicalContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            return SMLValidatorUtil.retrieveChildElements((Node)((Node)parent));
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return SMLValidatorUtil.retrieveChildElements((Node)((Node)element)).length > 0;
        }

        public Object[] getElements(Object input) {
            return DocumentsPage.this.extractDocumentContent((Node)input);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class LogicalLabelProvider
    implements ILabelProvider {
        private LogicalLabelProvider() {
        }

        public Image getImage(Object element) {
            return SMLImages.INSTANCE.getImage("element.gif");
        }

        public String getText(Object element) {
            return ((Node)element).getNodeName();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class LogicalSelectionListener
    implements ISelectionChangedListener {
        private LogicalSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (!(selection instanceof StructuredSelection) || selection.isEmpty()) {
                DocumentsPage.this.rawStyledText.setSelection(0, 0);
                return;
            }
            String index = this.findSelectionIndex(null, DocumentsPage.this.logicalRepresentation.getTree().getSelection()[0]);
            int[] elementIndices = (int[])DocumentsPage.this.indices.get(index);
            if (elementIndices == null) {
                DocumentsPage.this.rawStyledText.setSelection(0, 0);
                return;
            }
            DocumentsPage.this.rawStyledText.setSelection(elementIndices[0], elementIndices[1]);
        }

        private String findSelectionIndex(String index, TreeItem item) {
            TreeItem parentItem = item.getParentItem();
            if (parentItem != null) {
                String inx = String.valueOf(parentItem.indexOf(item));
                if (index != null && index.length() > 0) {
                    inx = String.valueOf(inx) + "," + index;
                }
                return this.findSelectionIndex(inx, parentItem);
            }
            return "0" + (index == null || index.length() <= 0 ? "" : "," + index);
        }
    }
}

