/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.PSVIProvider;
import org.apache.xerces.xs.XSModel;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.cosmos.rm.internal.validation.artifacts.DOMStructure;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementModel;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementSchemaModel;
import org.eclipse.cosmos.rm.internal.validation.artifacts.MappedNamespaceContext;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ResourceWrapper;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ValidationSet;
import org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationConstants;
import org.eclipse.cosmos.rm.internal.validation.common.SMLIFIdentity;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.core.IFoundationBuilder;
import org.eclipse.cosmos.rm.internal.validation.core.IValidationListener;
import org.eclipse.cosmos.rm.internal.validation.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.internal.validation.databuilders.DocumentDOMBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.IDataBuilder;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoundationBuilder
extends DefaultHandler
implements IFoundationBuilder {
    private SAXParser saxParser;
    private IDataBuilder<?>[] dataStructureBuilders;
    private AbstractValidationOutput validationLogger;
    private boolean validateXML;
    private Locator locator;
    private boolean documentElementHit;
    private boolean smlIfInput;
    private boolean status = true;
    private Collection<IValidationListener> validationListeners;
    private boolean inEclipse;
    private Map<String, Object> attributes;
    private Map<String, String> processedImports = new Hashtable<String, String>();
    private Map<String, String> pendingProcess = new Hashtable<String, String>();
    private String currentResource;
    private StringBuffer remoteURI;
    private int mode;
    private boolean locatorElementHit;
    private boolean documentURIElementHit;
    private int baseLineNumber;
    private ValidationSet validationSet;
    private boolean ignoreSyntactical;
    private PSVIProvider psvi;
    private boolean foundXSModel;

    public FoundationBuilder(int mode) {
        this.mode = mode;
        this.foundXSModel = false;
    }

    @Override
    public void reset() {
        this.status = true;
        this.processedImports.clear();
        this.pendingProcess.clear();
    }

    @Override
    public void initialize(Map<String, Object> init) {
        this.initialize(init, this.mode == 0);
    }

    public void initialize(Map<String, Object> init, boolean initBuilders) {
        Integer lineNo;
        this.validationLogger = (AbstractValidationOutput)init.get("validation.output");
        this.smlIfInput = !(init.get("validation.input.type") instanceof String) || !"value.sml.unit".equals(init.get("validation.input.type"));
        this.inEclipse = "value.environment.eclipse".equals(init.get("attribute.environment"));
        this.attributes = init;
        this.validationSet = (ValidationSet)init.get("validation.set");
        this.ignoreSyntactical = Boolean.TRUE.equals((Boolean)init.get("ignore.syntactical.errors"));
        this.psvi = (PSVIProvider)init.get("psvi.instance");
        this.validateXML = true;
        this.createSAXParser(this.smlIfInput ? (String)init.get("validation.schema.smlif") : null);
        this.retrieveBuilders();
        if (initBuilders) {
            int i = 0;
            while (i < this.dataStructureBuilders.length) {
                this.dataStructureBuilders[i].initialize(init);
                ++i;
            }
        }
        this.baseLineNumber = (lineNo = (Integer)init.get("base.line.number")) == null ? -1 : lineNo;
    }

    protected void createSAXParser(String xsd) {
        try {
            if (xsd == null) {
                this.validateXML = false;
            }
            InputStream schemaAsStream = xsd == null ? null : this.getClass().getClassLoader().getResourceAsStream(xsd);
            this.saxParser = SMLValidatorUtil.createSAXParser(schemaAsStream, this.validateXML, this, this.validationLogger);
        }
        catch (ParserConfigurationException e) {
            this.fatalError(e);
        }
        catch (SAXNotRecognizedException e) {
            this.fatalError(-1, NLS.bind((String)SMLValidationMessages.errorUnsupportedSAXProperty1, (Object)e.getLocalizedMessage()));
        }
        catch (SAXNotSupportedException e) {
            this.fatalError(-1, NLS.bind((String)SMLValidationMessages.errorUnsupportedSAXProperty1, (Object)e.getLocalizedMessage()));
        }
        catch (SAXException e) {
            this.fatalError(e);
        }
    }

    @Override
    public void error(SAXParseException exception) {
        if (this.ignoreSyntactical) {
            return;
        }
        this.status = false;
        int lineNo = this.baseLineNumber >= 0 ? this.baseLineNumber + exception.getLineNumber() - 1 : exception.getLineNumber();
        this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(lineNo, exception.getLocalizedMessage()));
    }

    protected void fatalError(Exception exception) {
        this.fatalError(-1, exception.getLocalizedMessage());
    }

    protected void fatalError(int lineNumber, String message) {
        this.status = false;
        this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(lineNumber, message));
    }

    @Override
    public boolean validate() {
        IProgressMonitor monitor = (IProgressMonitor)this.attributes.get("validation.progress");
        if (monitor != null) {
            monitor.setTaskName(SMLValidationMessages.validationBuildingStructures);
        }
        Exception exception = null;
        int lineNumber = -1;
        try {
            switch (this.mode) {
                case 0: {
                    return this.handleTopLevelMode();
                }
                case 1: {
                    return this.handleInstanceLevelMode();
                }
            }
        }
        catch (SAXParseException e) {
            lineNumber = this.baseLineNumber >= 0 ? this.baseLineNumber + e.getLineNumber() - 1 : e.getLineNumber();
            exception = e;
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception != null) {
            exception.printStackTrace();
            this.fatalError(lineNumber, exception.getLocalizedMessage());
        }
        return false;
    }

    private boolean handleTopLevelMode() throws FileNotFoundException, SAXException, IOException, CoreException, ParserConfigurationException {
        String currentDocument = null;
        String input = (String)this.attributes.get("validation.instance");
        if (this.smlIfInput) {
            currentDocument = input;
            this.saxParser.parse(new InputSource(new FileInputStream(new File(currentDocument))), (DefaultHandler)this);
        } else {
            Map ruleBindings;
            StringTokenizer inputs = new StringTokenizer(input, ",");
            ArrayList<ResourceWrapper> instanceList = new ArrayList<ResourceWrapper>();
            SMLIFIdentity identity = (SMLIFIdentity)SMLValidatorUtil.retrieveDataStructure(0, "org.eclipse.cosmos.rm.validation.IdentityDataBuilder");
            SMLIFIdentity metaIdentity = (SMLIFIdentity)this.attributes.get("validation.identity");
            if (identity != null) {
                if (metaIdentity != null) {
                    identity.copy(metaIdentity);
                } else {
                    identity.setBaseURI("");
                }
            }
            if ((ruleBindings = (Map)this.attributes.get("validation.rule.bindings")) != null && ruleBindings.size() > 0) {
                this.elementNotification("http://www.w3.org/2008/03/sml-if", "ruleBindings", "ruleBindings", IValidationConstants.EMPTY_ATTRIBUTES, true);
                for (String alias : ruleBindings.keySet()) {
                    List rules = (List)ruleBindings.get(alias);
                    if (rules == null) continue;
                    int i = 0;
                    int ruleCount = rules.size();
                    while (i < ruleCount) {
                        this.ruleNotification(alias, (String)rules.get(i));
                        ++i;
                    }
                }
                this.elementNotification("http://www.w3.org/2008/03/sml-if", "ruleBindings", "ruleBindings", IValidationConstants.EMPTY_ATTRIBUTES, false);
            }
            this.elementNotification("http://www.w3.org/2008/03/sml-if", "definitions", "definitions", IValidationConstants.EMPTY_ATTRIBUTES, true);
            String contextRoot = (String)this.attributes.get("validation.repository.root");
            contextRoot = contextRoot == null ? "" : contextRoot;
            while (inputs.hasMoreTokens()) {
                currentDocument = inputs.nextToken();
                ResourceWrapper resource = this.retrieveResource(currentDocument);
                if (resource == null) {
                    return false;
                }
                String parentFolder = this.findParentFolder(contextRoot, resource.getFullPath());
                this.traverseRecursively(instanceList, resource, true, parentFolder);
                Map processPending = (Map)((Hashtable)this.pendingProcess).clone();
                if (processPending == null) continue;
                for (String namespace : processPending.keySet()) {
                    String path = (String)processPending.get(namespace);
                    if (path == null || this.processedImports.get(namespace) != null) continue;
                    try {
                        this.traverseRecursively(instanceList, new ResourceWrapper(path, this.inEclipse), true, parentFolder);
                    }
                    catch (MissingResourceException missingResourceException) {
                        this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createWarningMessage(-1, NLS.bind((String)SMLValidationMessages.warningMissingResource, (Object)path)));
                    }
                }
                this.processedImports.putAll(processPending);
                for (String namespace : processPending.keySet()) {
                    this.processedImports.put(namespace, this.pendingProcess.get(namespace));
                    this.pendingProcess.remove(namespace);
                }
            }
            this.elementNotification("http://www.w3.org/2008/03/sml-if", "definitions", "definitions", IValidationConstants.EMPTY_ATTRIBUTES, false);
            this.elementNotification("http://www.w3.org/2008/03/sml-if", "instances", "definitions", IValidationConstants.EMPTY_ATTRIBUTES, true);
            int i = 0;
            int instanceCount = instanceList.size();
            while (i < instanceCount) {
                ResourceWrapper currentInstanceResource = (ResourceWrapper)instanceList.get(i);
                this.traverseRecursively(instanceList, currentInstanceResource, false, this.findParentFolder(contextRoot, currentInstanceResource.getFullPath()));
                ++i;
            }
            this.elementNotification("http://www.w3.org/2008/03/sml-if", "instances", "definitions", IValidationConstants.EMPTY_ATTRIBUTES, false);
        }
        return true;
    }

    private boolean handleInstanceLevelMode() throws SAXException, ParserConfigurationException, IOException {
        ElementSchemaModel[] definitions = this.validationSet.getDefinitions();
        InputStream[] schemas = SMLValidatorUtil.toInputStream(definitions);
        this.attributes.put("namespace.context", this.createNamespace(definitions));
        this.attributes.remove("xs.model");
        this.foundXSModel = false;
        SAXParser newSaxParser = SMLValidatorUtil.createSAXParser(schemas, true, null, this.validationLogger);
        PSVIProvider psviProvider = (PSVIProvider)newSaxParser.getXMLReader();
        this.attributes.put("psvi.instance", psviProvider);
        DocumentDOMBuilder documentBuilder = new DocumentDOMBuilder();
        DataBuilderRegistry.getInstanceLevelRegistry().registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.DocumentDOMBuilder", documentBuilder);
        DOMStructure domDocumentStructure = documentBuilder.getDataStructure();
        ElementModel[] instances = this.validationSet.getInstances();
        if (instances.length == 0) {
            this.attributes.put("base.line.number", 0);
            this.attributes.put("document.aliases", new String[0]);
            this.attributes.put("ignore.syntactical.errors", true);
            this.initialize(this.attributes, true);
            newSaxParser.parse((InputStream)new ByteArrayInputStream("<dummyElement/>".getBytes()), (DefaultHandler)this);
        }
        int i = 0;
        while (i < instances.length) {
            this.attributes.put("base.line.number", instances[i].getLineNumber());
            this.attributes.put("document.aliases", instances[i].getAliases());
            this.attributes.put("ignore.syntactical.errors", false);
            this.initialize(this.attributes, true);
            ByteArrayInputStream source = new ByteArrayInputStream(instances[i].getSource().getBytes());
            newSaxParser.parse((InputStream)source, (DefaultHandler)this);
            Node documentNode = this.buildDOMDocument(schemas, source);
            domDocumentStructure.add(documentNode, instances[i]);
            ++i;
        }
        return true;
    }

    private MappedNamespaceContext createNamespace(ElementSchemaModel[] definitions) {
        MappedNamespaceContext namespaceContext = new MappedNamespaceContext();
        int i = 0;
        while (i < definitions.length) {
            namespaceContext.addEntries(definitions[i].getNamespaceContext());
            ++i;
        }
        return namespaceContext;
    }

    private Node buildDOMDocument(InputStream[] schemas, InputStream instance) {
        Document document;
        block7: {
            int i = 0;
            while (i < schemas.length) {
                schemas[i].reset();
                ++i;
            }
            instance.reset();
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            docBuilderFactory.setAttribute("http://apache.org/xml/properties/dom/document-class-name", "org.apache.xerces.dom.PSVIDocumentImpl");
            Source[] schemaSource = new Source[schemas.length];
            int i2 = 0;
            while (i2 < schemaSource.length) {
                schemaSource[i2] = new StreamSource(schemas[i2]);
                ++i2;
            }
            docBuilderFactory.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaSource));
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            document = docBuilder.parse(instance);
            if (document != null) break block7;
            return null;
        }
        try {
            NodeList children = document.getChildNodes();
            int i = 0;
            int childCount = children.getLength();
            while (i < childCount) {
                Node child = children.item(i);
                if (1 == child.getNodeType()) {
                    return child;
                }
                ++i;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, String.valueOf(SMLValidationMessages.errorDOMDocument) + " " + e.getMessage()));
            return null;
        }
    }

    private void ruleNotification(String alias, String ruleAlias) throws SAXException {
        this.fireNotifications("http://www.w3.org/2008/03/sml-if", new String[]{"ruleBinding", "documentAlias"}, true);
        this.characters(alias.toCharArray(), 0, alias.length());
        this.elementNotification("http://www.w3.org/2008/03/sml-if", "documentAlias", "documentAlias", IValidationConstants.EMPTY_ATTRIBUTES, false);
        this.elementNotification("http://www.w3.org/2008/03/sml-if", "ruleAlias", "documentAlias", IValidationConstants.EMPTY_ATTRIBUTES, true);
        this.characters(ruleAlias.toCharArray(), 0, ruleAlias.length());
        this.fireNotifications("http://www.w3.org/2008/03/sml-if", new String[]{"ruleAlias", "ruleBinding"}, false);
    }

    private String findParentFolder(String root, String resource) {
        root = root.replace('\\', '/');
        resource = resource.replace('\\', '/');
        Path rootPath = new Path(root);
        Path resourcePath = new Path(resource);
        if (this.inEclipse) {
            IPath workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            rootPath = rootPath.removeFirstSegments(workspace.segmentCount());
        }
        int i = 0;
        int segCount = rootPath.segmentCount();
        while (i < segCount) {
            if (!resourcePath.segment(0).equals(rootPath.segment(i))) break;
            resourcePath = resourcePath.removeFirstSegments(1);
            ++i;
        }
        String parentFolder = resourcePath.removeLastSegments(1).toString();
        String device = resourcePath.getDevice();
        if (device != null && parentFolder.startsWith(device)) {
            parentFolder = parentFolder.substring(device.length());
        }
        return parentFolder;
    }

    private void traverseRecursively(List<ResourceWrapper> instanceList, ResourceWrapper resource, boolean isDefinition, String parentFolder) throws CoreException, IOException, SAXException, ParserConfigurationException {
        if (resource.isDirectory()) {
            ResourceWrapper[] children = resource.getChildren();
            parentFolder = String.valueOf(parentFolder.length() > 0 ? String.valueOf(parentFolder) + "/" : "") + resource.getName();
            int i = 0;
            while (i < children.length) {
                this.traverseRecursively(instanceList, children[i], isDefinition, parentFolder);
                ++i;
            }
        } else if (resource.isFile()) {
            int type = SMLValidatorUtil.identifyDocumentType(resource);
            this.currentResource = resource.getAbsolutePath();
            switch (type) {
                case 0: {
                    this.addDocument(parentFolder, resource);
                    break;
                }
                case 1: {
                    if (isDefinition) {
                        instanceList.add(resource);
                        return;
                    }
                    this.addDocument(parentFolder, resource);
                    break;
                }
            }
        }
    }

    private void addDocument(String parentFolder, ResourceWrapper resource) throws SAXException, ParserConfigurationException, IOException, CoreException {
        this.addAliases(parentFolder, resource);
        this.processData(resource);
        this.elementNotification("http://www.w3.org/2008/03/sml-if", "document", "document", IValidationConstants.EMPTY_ATTRIBUTES, false);
    }

    private void addAliases(String parentFolder, ResourceWrapper resource) throws SAXException {
        List aliases;
        this.fireNotifications("http://www.w3.org/2008/03/sml-if", new String[]{"document", "docinfo", "aliases"}, true);
        Map fileAliasMap = (Map)this.attributes.get("validation.aliases");
        boolean definedAliases = false;
        if (fileAliasMap != null && (aliases = (List)fileAliasMap.get(resource.getName())) != null) {
            definedAliases = aliases.size() > 0;
            int i = 0;
            int aliasCount = aliases.size();
            while (i < aliasCount) {
                String alias = (String)aliases.get(i);
                this.notifyAlias(alias);
                ++i;
            }
        }
        if (!definedAliases) {
            this.notifyAlias(String.valueOf(parentFolder.length() > 0 ? String.valueOf(parentFolder) + "/" : "") + resource.getName());
        }
        this.fireNotifications("http://www.w3.org/2008/03/sml-if", new String[]{"aliases", "docinfo"}, false);
    }

    private void notifyAlias(String alias) throws SAXException {
        this.elementNotification("http://www.w3.org/2008/03/sml-if", "alias", "alias", IValidationConstants.EMPTY_ATTRIBUTES, true);
        this.characters(alias.toCharArray(), 0, alias.length());
        this.elementNotification("http://www.w3.org/2008/03/sml-if", "alias", "alias", IValidationConstants.EMPTY_ATTRIBUTES, false);
    }

    private void processData(ResourceWrapper resource) throws SAXException, ParserConfigurationException, IOException, CoreException {
        InputStream fileInputStream = resource.getContents();
        try {
            this.elementNotification("http://www.w3.org/2008/03/sml-if", "data", "data", IValidationConstants.EMPTY_ATTRIBUTES, true);
            this.validationLogger.setAssociatedResource(resource);
            int i = 0;
            while (i < this.dataStructureBuilders.length) {
                IDataBuilder<?> dataBuilder = this.dataStructureBuilders[i];
                dataBuilder.setFilePath(resource.getFullPath());
                ++i;
            }
            this.saxParser.parse(fileInputStream, (DefaultHandler)this);
            this.elementNotification("http://www.w3.org/2008/03/sml-if", "data", "data", IValidationConstants.EMPTY_ATTRIBUTES, false);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private void fireNotifications(String uri, String[] elements, boolean open) throws SAXException {
        int i = 0;
        while (i < elements.length) {
            this.elementNotification(uri, elements[i], elements[i], IValidationConstants.EMPTY_ATTRIBUTES, open);
            ++i;
        }
    }

    private ResourceWrapper retrieveResource(String path) {
        try {
            return new ResourceWrapper(path, this.inEclipse);
        }
        catch (MissingResourceException mre) {
            this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, mre.getMessage()));
            return null;
        }
    }

    private void retrieveBuilders() {
        DataBuilderRegistry registry = null;
        switch (this.mode) {
            case 0: {
                registry = DataBuilderRegistry.getTopLevelRegistry();
                break;
            }
            case 1: {
                registry = DataBuilderRegistry.getInstanceLevelRegistry();
                break;
            }
            default: {
                return;
            }
        }
        Collection<IDataBuilder<?>> dataBuilders = registry.getDataStructureBuilders();
        this.dataStructureBuilders = new IDataBuilder[dataBuilders.size()];
        dataBuilders.toArray(this.dataStructureBuilders);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("http://www.w3.org/2008/03/sml-if".equals(uri)) {
            if ("document".equals(localName)) {
                this.documentElementHit = true;
            } else if (this.documentElementHit && "locator".equals(localName)) {
                this.locatorElementHit = true;
            } else if (this.locatorElementHit && "documentURI".equals(localName)) {
                this.remoteURI = new StringBuffer();
                this.documentURIElementHit = true;
            }
        } else if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "import".equals(localName)) {
            String namespace = attributes.getValue("namespace");
            String location = attributes.getValue("schemaLocation");
            if (namespace != null && location != null && this.currentResource != null && this.processedImports.get(namespace) == null && location.indexOf("//") < 0) {
                int inx = Math.max(this.currentResource.lastIndexOf(47), this.currentResource.lastIndexOf(92));
                String parentFolder = inx >= 0 ? this.currentResource.substring(0, inx) : this.currentResource;
                location = location.startsWith(parentFolder) ? location : String.valueOf(parentFolder) + "/" + location;
                this.pendingProcess.put(namespace, location);
            }
        }
        this.elementNotification(uri, localName, qName, attributes, true);
    }

    private void retrieveRemoteDocument(String href) throws SAXException {
        Node node = null;
        SMLValidatorUtil.RemoteRetrievalException exception = null;
        try {
            node = SMLValidatorUtil.retrieveRemoteDocument(href);
            this.attributes.put("remote.document", node);
            Element dataNode = node.getOwnerDocument().createElementNS("http://www.w3.org/2008/03/sml-if", "data");
            dataNode.appendChild(node);
            node = dataNode;
        }
        catch (SMLValidatorUtil.RemoteRetrievalException e) {
            exception = e;
        }
        if (exception != null || node == null) {
            int lineNo = this.baseLineNumber >= 0 ? this.baseLineNumber + this.locator.getLineNumber() - 1 : this.locator.getLineNumber();
            this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(lineNo, NLS.bind((String)SMLValidationMessages.errorMissingDocument, (Object)String.valueOf(this.locator.getLineNumber()))));
            return;
        }
        this.walkDocument(node);
        this.attributes.remove("remote.document");
    }

    private void walkDocument(Node node) {
        Attributes atts = this.toAttributes(node.getAttributes());
        try {
            this.domNotification(node, atts, true);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            this.walkDocument(children.item(i));
            ++i;
        }
        try {
            this.domNotification(node, atts, false);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    private void domNotification(Node node, Attributes atts, boolean start) throws SAXException {
        switch (node.getNodeType()) {
            case 1: {
                this.elementNotification(node.getNamespaceURI(), node.getLocalName(), node.getNodeName(), atts, start);
                break;
            }
            case 3: 
            case 8: {
                String value;
                if (!start || (value = node.getNodeValue()) == null) break;
                this.characters(value.toCharArray(), 0, value.length());
                break;
            }
        }
    }

    private Attributes toAttributes(NamedNodeMap attributes) {
        AttributeWrapper attributeWrapper = new AttributeWrapper(attributes);
        return attributeWrapper;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("http://www.w3.org/2008/03/sml-if".equals(uri)) {
            if ("document".equals(localName)) {
                this.documentElementHit = false;
            } else if ("documentURI".equals(localName)) {
                this.retrieveRemoteDocument(this.remoteURI.toString());
                this.documentURIElementHit = false;
            }
        }
        if (!this.foundXSModel && this.psvi != null) {
            XSModel xsModel;
            ElementPSVI elementPSVI = this.psvi.getElementPSVI();
            XSModel xSModel = xsModel = elementPSVI == null ? null : elementPSVI.getSchemaInformation();
            if (xsModel != null) {
                this.foundXSModel = true;
                this.attributes.put("xs.model", xsModel);
            }
        }
        this.elementNotification(uri, localName, qName, null, false);
    }

    private void elementNotification(String uri, String localName, String qName, Attributes attributes, boolean start) throws SAXException {
        int i = 0;
        while (i < this.dataStructureBuilders.length) {
            IDataBuilder<?> dataBuilder = this.dataStructureBuilders[i];
            if (start) {
                dataBuilder.startElement(uri, localName, qName, attributes);
            } else {
                dataBuilder.endElement(uri, localName, qName);
            }
            ++i;
        }
    }

    @Override
    public void characters(char[] ch, int start, int len) throws SAXException {
        this.eventNotification(1, ch, new int[]{start, len}, null);
        if (this.documentURIElementHit) {
            this.remoteURI.append(new String(ch).substring(start, start + len));
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.eventNotification(3, null, null, null);
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
        this.eventNotification(5, null, null, new String[]{arg0});
    }

    @Override
    public void unparsedEntityDecl(String arg0, String arg1, String arg2, String arg3) throws SAXException {
        super.unparsedEntityDecl(arg0, arg1, arg2, arg3);
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        this.eventNotification(6, arg0, new int[]{arg1, arg2}, null);
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
        this.eventNotification(0, null, null, new String[]{arg0, arg1});
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
        this.eventNotification(7, null, null, new String[]{arg0});
    }

    @Override
    public void startDocument() throws SAXException {
        this.eventNotification(2, null, null, null);
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        this.eventNotification(4, null, null, new String[]{arg0, arg1});
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        int i = 0;
        while (i < this.dataStructureBuilders.length) {
            this.dataStructureBuilders[i].setDocumentLocator(locator);
            ++i;
        }
    }

    private void eventNotification(int event, char[] characters, int[] integerParameters, String[] stringParameters) throws SAXException {
        int i = 0;
        while (i < this.dataStructureBuilders.length) {
            if (this.isEventSupported(this.dataStructureBuilders[i], event)) {
                this.handleEvent(this.dataStructureBuilders[i], event, characters, integerParameters, stringParameters);
            }
            ++i;
        }
    }

    @Override
    public void comment(char[] ch, int start, int len) throws SAXException {
        this.eventNotification(8, ch, new int[]{start, len}, null);
    }

    private boolean isEventSupported(IDataBuilder<?> dataBuilder, int event) {
        int supportedEvents = dataBuilder.getSupportedEvents();
        return (supportedEvents & 1 << event) > 0;
    }

    private void handleEvent(ContentHandler contentHandler, int event, char[] characters, int[] integerParameters, String[] stringParameters) throws SAXException {
        switch (event) {
            case 8: {
                ((IDataBuilder)contentHandler).comment(characters, integerParameters[0], integerParameters[1]);
                break;
            }
            case 1: {
                contentHandler.characters(characters, integerParameters[0], integerParameters[1]);
                break;
            }
            case 2: {
                contentHandler.startDocument();
                break;
            }
            case 3: {
                contentHandler.endDocument();
                break;
            }
            case 4: {
                contentHandler.startPrefixMapping(stringParameters[0], stringParameters[1]);
                break;
            }
            case 5: {
                contentHandler.endPrefixMapping(stringParameters[0]);
                break;
            }
            case 6: {
                contentHandler.ignorableWhitespace(characters, integerParameters[0], integerParameters[1]);
                break;
            }
            case 7: {
                contentHandler.skippedEntity(stringParameters[0]);
                break;
            }
            case 0: {
                contentHandler.processingInstruction(stringParameters[0], stringParameters[1]);
                break;
            }
        }
    }

    public boolean getStatus() {
        return this.status;
    }

    @Override
    public void addValidationListener(IValidationListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.validationListeners == null) {
            this.validationListeners = new ArrayList<IValidationListener>();
        }
        if (!this.validationListeners.contains(listener)) {
            this.validationListeners.add(listener);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String arg0) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
    }

    @Override
    public void startEntity(String arg0) throws SAXException {
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    private class AttributeWrapper
    implements Attributes {
        private NamedNodeMap attributes;
        private Map<String, Integer> qNameInx;
        private Map<String, Integer> uriInx;

        public AttributeWrapper(NamedNodeMap attributes) {
            this.attributes = attributes;
            this.qNameInx = new Hashtable<String, Integer>();
            this.uriInx = new Hashtable<String, Integer>();
            if (attributes == null) {
                return;
            }
            int i = 0;
            int attributeCount = attributes.getLength();
            while (i < attributeCount) {
                Node att = attributes.item(i);
                Integer inx = new Integer(i);
                this.qNameInx.put(att.getNodeName(), inx);
                String key = att.getNamespaceURI() == null ? "" : att.getNamespaceURI();
                key = String.valueOf(key) + att.getLocalName();
                this.uriInx.put(key, inx);
                ++i;
            }
        }

        public int getIndex(String qName) {
            Integer inx = this.qNameInx.get(qName);
            return inx == null ? -1 : inx;
        }

        public int getIndex(String uri, String localName) {
            Integer inx = this.uriInx.get(uri == null ? localName : String.valueOf(uri) + localName);
            return inx == null ? -1 : inx;
        }

        public int getLength() {
            return this.attributes.getLength();
        }

        public String getLocalName(int index) {
            return this.attributes.item(index).getLocalName();
        }

        public String getQName(int index) {
            return this.attributes.item(index).getNodeName();
        }

        public String getType(int index) {
            return null;
        }

        public String getType(String qName) {
            return null;
        }

        public String getType(String uri, String localName) {
            return null;
        }

        public String getURI(int index) {
            return this.attributes.item(index).getNamespaceURI();
        }

        public String getValue(int index) {
            Node node = index >= 0 && index < this.attributes.getLength() ? this.attributes.item(index) : null;
            return node == null ? null : node.getNodeValue();
        }

        public String getValue(String qName) {
            Node node = this.attributes.getNamedItem(qName);
            return node == null ? null : node.getNodeValue();
        }

        public String getValue(String uri, String localName) {
            Node node = this.attributes.getNamedItemNS(uri, localName);
            return node == null ? null : node.getNodeValue();
        }
    }
}

