/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementLocation;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementModel;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementSchemaModel;
import org.eclipse.cosmos.rm.internal.validation.artifacts.SMLDocuments;
import org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentCacheBuilder
extends AbstractDataBuilder<SMLDocuments> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.DocumentCacheBuilder";
    private boolean documentElementHit;
    private boolean dataElementHit;
    private boolean instanceElementHit;
    private boolean definitionElementHit;
    private boolean aliasElementHit;
    private ElementModel currentElementModel;
    private ElementLocation lastDataLocation;
    private String smlifFile;
    private boolean inEclipse;
    private String currentAlias = "";
    private List<String> currentAliases;
    private SMLDocuments smlDocuments = new SMLDocuments();
    private List<String> allAliases;

    public DocumentCacheBuilder() {
        this.currentAliases = new ArrayList<String>();
        this.allAliases = new ArrayList<String>();
        this.addEvent(1);
    }

    @Override
    public void initialize(Map<String, Object> init) {
        super.initialize(init);
        this.inEclipse = "value.environment.eclipse".equals(init.get("attribute.environment"));
        this.smlifFile = "value.sml.if".equals(init.get("validation.input.type")) ? (String)init.get("validation.instance") : null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.dataElementHit) {
            if (!"http://purl.oclc.org/dsdl/schematron".equals(uri) && this.lastDataLocation != null) {
                if ("schema".equals(localName)) {
                    ElementSchemaModel schemaModel = new ElementSchemaModel(qName, this.elementFilePath(), Math.max(this.lastDataLocation.getLineNumber(), 0), this.lastDataLocation.getColumnNumber());
                    schemaModel.setTargetNamespace(attributes.getValue("targetNamespace"));
                    int i = 0;
                    while (i < attributes.getLength()) {
                        String prefix;
                        String qNameAttribute = attributes.getQName(i);
                        String valueAttribute = attributes.getValue(i);
                        if (qNameAttribute.startsWith("xmlns") && (prefix = this.retrievePrefix(qNameAttribute)) != null && valueAttribute != null) {
                            schemaModel.getNamespaceContext().addEntry(prefix, valueAttribute);
                        }
                        ++i;
                    }
                    this.currentElementModel = schemaModel;
                } else {
                    Node remoteDocument = (Node)this.getInit().get("remote.document");
                    this.currentElementModel = remoteDocument == null ? new ElementModel(qName, this.elementFilePath(), Math.max(this.lastDataLocation.getLineNumber(), 0), this.lastDataLocation.getColumnNumber()) : new ElementModel(remoteDocument, this.elementFilePath(), Math.max(this.lastDataLocation.getLineNumber(), 0), this.lastDataLocation.getColumnNumber());
                }
                this.lastDataLocation = null;
            }
            boolean importElement = false;
            if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "import".equals(localName)) {
                importElement = true;
                String namespace = attributes.getValue("namespace");
                if (namespace != null && this.currentElementModel instanceof ElementSchemaModel) {
                    ((ElementSchemaModel)this.currentElementModel).addImportedSchema(namespace);
                }
            }
            boolean needSchemaLocation = importElement && this.currentElementModel != null;
            boolean smlNamespace = false;
            if (importElement) {
                int i = 0;
                while (i < attributes.getLength()) {
                    needSchemaLocation = "schemaLocation".equals(attributes.getLocalName(i)) ? false : needSchemaLocation;
                    smlNamespace = "namespace".equals(attributes.getLocalName(i)) && "http://www.w3.org/2008/03/sml".equals(attributes.getValue(i)) ? true : smlNamespace;
                    ++i;
                }
            }
            if (smlNamespace && needSchemaLocation) {
                StringBuffer buffer = new StringBuffer(" schemaLocation");
                buffer.append("=").append("\"").append("http://www.w3.org/2008/03/sml").append("\"");
                this.currentElementModel.setAdditionalSchemaLocation(buffer.toString());
            }
        }
        if ("http://www.w3.org/2008/03/sml-if".equals(uri)) {
            if ("instances".equals(localName)) {
                this.instanceElementHit = true;
            } else if ("definitions".equals(localName)) {
                this.definitionElementHit = true;
            } else if ((this.instanceElementHit || this.definitionElementHit) && "alias".equals(localName)) {
                this.aliasElementHit = true;
            } else if ("document".equals(localName)) {
                this.documentElementHit = true;
            } else if (this.documentElementHit && "data".equals(localName)) {
                this.dataElementHit = true;
                this.lastDataLocation = this.getLocator() == null ? new ElementLocation(null, 0, 0) : new ElementLocation(null, this.getLocator().getLineNumber() + 1, this.getLocator().getColumnNumber() + 1);
            }
        }
    }

    private String retrievePrefix(String qName) {
        int colonInx = qName.indexOf(":");
        return colonInx >= 0 && colonInx + 1 < qName.length() ? qName.substring(colonInx + 1) : null;
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        if (this.aliasElementHit) {
            this.currentAlias = String.valueOf(this.currentAlias) + new String(chars, start, length).trim();
        }
    }

    private String elementFilePath() {
        return this.smlifFile == null ? this.getFilePath() : this.smlifFile;
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("http://www.w3.org/2008/03/sml-if".equals(uri)) {
            if (this.instanceElementHit && "instances".equals(localName)) {
                this.instanceElementHit = false;
            } else if (this.definitionElementHit && "definitions".equals(localName)) {
                this.definitionElementHit = false;
            } else if (this.aliasElementHit && "alias".equals(localName)) {
                this.aliasElementHit = false;
                if (this.currentAlias.length() > 0) {
                    URI aliasURI = null;
                    try {
                        aliasURI = new URI(this.currentAlias);
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                    if (this.allAliases.contains(this.currentAlias)) {
                        this.getMessageOutputter().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(this.getLocator().getLineNumber(), NLS.bind((String)SMLValidationMessages.errorDuplicateAlias, (Object)this.currentAlias)));
                    } else if (aliasURI != null && aliasURI.getFragment() != null) {
                        this.getMessageOutputter().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(this.getLocator().getLineNumber(), SMLValidationMessages.errorAliasHasFragment));
                    } else if (!this.currentAliases.contains(this.currentAlias)) {
                        this.currentAliases.add(this.currentAlias);
                    }
                    this.currentAlias = "";
                }
            } else if (this.documentElementHit && "document".equals(localName)) {
                this.documentElementHit = false;
                this.allAliases.addAll(this.currentAliases);
                this.currentAliases.clear();
            } else if (this.dataElementHit && "data".equals(localName)) {
                this.dataElementHit = false;
                if (this.currentElementModel != null) {
                    String elementSource = this.currentElementModel.getSource();
                    if (elementSource == null || elementSource.length() <= 0) {
                        this.processCurrentElementModel();
                    }
                    if (this.definitionElementHit) {
                        this.smlDocuments.addDefinition((ElementSchemaModel)this.currentElementModel);
                    } else if (this.instanceElementHit) {
                        this.smlDocuments.addInstance(this.currentElementModel);
                    }
                    this.currentElementModel = null;
                }
            }
        }
    }

    private void processCurrentElementModel() {
        if (this.getLocator() != null) {
            this.currentElementModel.setEndingLine(this.getLocator().getLineNumber());
        }
        this.currentElementModel.setAliases(this.currentAliases);
        this.getElementSource(this.currentElementModel);
    }

    private void getElementSource(ElementModel elementModel) {
        LineNumberReader in = null;
        try {
            String path = this.inEclipse ? SMLValidatorUtil.retrieveAbsolutePath(elementModel.getFilePath()) : elementModel.getFilePath();
            in = new LineNumberReader(new FileReader(path));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            String currentLine = in.readLine();
            while (in.getLineNumber() < elementModel.getLineNumber()) {
                currentLine = in.readLine();
            }
            StringBuffer contents = new StringBuffer();
            if (this.smlifFile != null) {
                contents.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            }
            String firstLine = null;
            if (currentLine.indexOf(60) == -1) {
                currentLine = in.readLine();
                firstLine = String.valueOf(currentLine) + "\n";
            } else {
                int prevTagOnLine = currentLine.lastIndexOf(62, elementModel.getColumnNumber());
                firstLine = String.valueOf(currentLine.substring(prevTagOnLine + 1)) + "\n";
            }
            in.setLineNumber(elementModel.getLineNumber());
            contents.append(firstLine);
            boolean endFound = false;
            while (!endFound && currentLine != null) {
                int endTagIndex;
                currentLine = in.readLine();
                if (currentLine == null) break;
                if (elementModel.getAdditionalSchemaLocation() != null && currentLine.matches(".*[^/][\\s]*import.*")) {
                    endTagIndex = currentLine.indexOf(62, currentLine.indexOf("import"));
                    if (endTagIndex == -1) {
                        currentLine = String.valueOf(currentLine) + elementModel.getAdditionalSchemaLocation();
                    } else {
                        if (currentLine.charAt(endTagIndex - 1) == '/') {
                            --endTagIndex;
                        }
                        currentLine = String.valueOf(currentLine.substring(0, endTagIndex)) + elementModel.getAdditionalSchemaLocation() + currentLine.substring(endTagIndex);
                    }
                }
                if (endFound = currentLine.matches(".*/[\\s]*" + elementModel.getElementName() + "[\\s]*>.*")) {
                    endTagIndex = currentLine.indexOf(elementModel.getElementName());
                    int rightBracket = currentLine.indexOf(62, endTagIndex);
                    elementModel.setEndingLine(in.getLineNumber());
                    elementModel.setEndingColumn(rightBracket);
                    contents.append(String.valueOf(currentLine.substring(0, rightBracket + 1)) + "\n");
                    continue;
                }
                contents.append(String.valueOf(currentLine) + "\n");
            }
            elementModel.setSource(contents.toString());
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public SMLDocuments getDataStructure() {
        return this.smlDocuments;
    }
}

