/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.PSVIProvider;
import org.apache.xerces.xs.XSElementDeclaration;
import org.eclipse.cosmos.rm.internal.validation.artifacts.IdentityConstraintStructure;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.IdentityConstraintUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityConstraintDataBuilder
extends AbstractDataBuilder<IdentityConstraintStructure> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.IdentityConstraintDataBuilder";
    public static final String[] IDENTITY_CONSTRAINTS = new String[]{"key", "keyref", "unique"};
    private static int START = 0;
    private static int OPEN = 1;
    private static int CLOSE = 2;
    private IdentityConstraintStructure identityStruct = new IdentityConstraintStructure();
    private List<Integer> documentNodeInx = new ArrayList<Integer>();
    private int orphanInx = -1;
    private NamespaceContext namespaceContext;
    private int lastEvent;

    public IdentityConstraintDataBuilder() {
        this.addEvent(1);
    }

    @Override
    public void initialize(Map<String, Object> init) {
        super.initialize(init);
        String[] aliases = this.getAliases();
        this.documentNodeInx.clear();
        this.orphanInx += aliases == null || aliases.length <= 0 ? 1 : 0;
        this.namespaceContext = (NamespaceContext)init.get("namespace.context");
        this.lastEvent = START;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.lastEvent == OPEN || this.lastEvent == START) {
            this.documentNodeInx.add(0);
        } else if (this.lastEvent == CLOSE) {
            int lastInx = this.documentNodeInx.size() - 1;
            this.documentNodeInx.set(lastInx, this.documentNodeInx.get(lastInx) + 1);
        }
        IdentityConstraintStructure.IdentityConstraint[] constraints = this.retrieveConstraints();
        int[] nodePath = new int[this.documentNodeInx.size()];
        int j = 0;
        while (j < nodePath.length) {
            nodePath[j] = this.documentNodeInx.get(j);
            ++j;
        }
        String[] aliases = this.getAliases();
        int i = 0;
        while (i < constraints.length) {
            IdentityConstraintStructure.IdentityInstance identityInstance = new IdentityConstraintStructure.IdentityInstance();
            identityInstance.setConstraint(constraints[i]);
            identityInstance.setNodePath(nodePath);
            identityInstance.setLineNumber(this.getBaseLineNumber() + this.getLocator().getLineNumber() - 1);
            if (aliases == null || aliases.length <= 0) {
                this.identityStruct.addOrphanedConstrainedInstance(this.orphanInx, identityInstance);
            } else {
                this.identityStruct.addConstrainedInstance(aliases[0], identityInstance);
            }
            ++i;
        }
        this.lastEvent = OPEN;
    }

    private IdentityConstraintStructure.IdentityConstraint[] retrieveConstraints() {
        PSVIProvider psviProvider = this.getPsvi();
        ElementPSVI elementPSVI = psviProvider.getElementPSVI();
        XSElementDeclaration elementDeclaration = elementPSVI == null ? null : elementPSVI.getElementDeclaration();
        List<IdentityConstraintStructure.IdentityConstraint> identityConstraints = IdentityConstraintUtil.retrieveConstraints(elementDeclaration, this.namespaceContext);
        return identityConstraints.toArray(new IdentityConstraintStructure.IdentityConstraint[identityConstraints.size()]);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (this.lastEvent == CLOSE) {
            this.documentNodeInx.remove(this.documentNodeInx.size() - 1);
        }
        this.lastEvent = CLOSE;
    }

    @Override
    public IdentityConstraintStructure getDataStructure() {
        return this.identityStruct;
    }
}

