/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ConstraintNode;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementTypeMap;
import org.eclipse.cosmos.rm.internal.validation.artifacts.TargetElementNode;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.util.ParserHelper;
import org.w3c.dom.DOMException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetInstanceBuilder
extends AbstractDataBuilder<Map<TargetElementNode, String>> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.TargetInstanceBuilder";
    protected TargetElementNode currentTargetElement;
    protected ElementTypeMap elementTypeMap;
    protected boolean uriElementFound = false;
    protected Map<TargetElementNode, String> dataStructure = new HashMap<TargetElementNode, String>();
    protected Map<String, ConstraintNode> targetSchemaBuilderStructure = new HashMap<String, ConstraintNode>();
    protected Map<String, Map<String, String>> substitutionElementStructure = new HashMap<String, Map<String, String>>();

    public TargetInstanceBuilder() {
        this.elementTypeMap = new ElementTypeMap();
        super.addEvent(1);
    }

    @Override
    public Map<TargetElementNode, String> getDataStructure() {
        return this.dataStructure;
    }

    @Override
    public void startInstances() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.updateElementTypeMap();
        if (uri == null) {
            return;
        }
        ConstraintNode constraintNode = this.getConstraintNode(localName);
        if (constraintNode == null) {
            constraintNode = this.getSubstitutionGroupNode(uri, localName);
        }
        if (constraintNode != null) {
            this.currentTargetElement = new TargetElementNode(localName, this.getFilePath(), this.getAdjustedLocatorLine(), this.getLocator() == null ? -1 : this.getLocator().getColumnNumber());
            this.currentTargetElement.setUri(uri);
        } else {
            this.uriElementFound = this.currentTargetElement != null && "uri".equals(localName);
        }
    }

    protected void updateElementTypeMap() {
        XSElementDeclaration elementDeclaration = this.getPsvi().getElementPSVI().getElementDeclaration();
        if (elementDeclaration != null) {
            String name = elementDeclaration.getName();
            XSTypeDefinition type = this.getPsvi().getElementPSVI().getTypeDefinition();
            if (type.getTypeCategory() == 16) {
                return;
            }
            if (((XSComplexTypeDefinition)type).getContentType() != 2) {
                return;
            }
            String namespace = type.getNamespace() == null ? this.getDefaultNamespace() : type.getNamespace();
            String typeName = type.getName();
            if (namespace != null && name != null && typeName != null) {
                this.elementTypeMap.addElementDeclaration(namespace, name, typeName);
            }
        }
    }

    protected ConstraintNode getSubstitutionGroupNode(String uri, String localName) {
        ConstraintNode constraintNode = null;
        String substitutionGroup = null;
        Map<String, String> subGroupMap = this.substitutionElementStructure.get(uri);
        if (subGroupMap != null) {
            substitutionGroup = subGroupMap.get(localName);
        }
        if (substitutionGroup == null) {
            substitutionGroup = this.getSubstitutionGroup();
        }
        if (substitutionGroup != null) {
            if (subGroupMap == null) {
                subGroupMap = new HashMap<String, String>();
                this.substitutionElementStructure.put(uri, subGroupMap);
            }
            subGroupMap.put(localName, substitutionGroup);
        }
        if (substitutionGroup != null) {
            constraintNode = this.getConstraintNode(ParserHelper.removeNameSpace(substitutionGroup));
        }
        return constraintNode;
    }

    protected String getSubstitutionGroup() {
        XSElementDeclaration elementDeclaration;
        ElementPSVI elementPSVI = this.getPsvi().getElementPSVI();
        XSElementDeclaration xSElementDeclaration = elementDeclaration = elementPSVI == null ? null : elementPSVI.getElementDeclaration();
        if (elementDeclaration == null || elementDeclaration.getSubstitutionGroupAffiliation() == null) {
            return null;
        }
        return elementDeclaration.getSubstitutionGroupAffiliation().getName();
    }

    private ConstraintNode getConstraintNode(String localName) {
        ConstraintNode constraintNode = this.targetSchemaBuilderStructure.get(localName);
        if (constraintNode == null) {
            String elementName = localName;
            String targetElement = this.getAttributeValue("http://www.w3.org/2008/03/sml", "targetElement");
            String targetType = this.getAttributeValue("http://www.w3.org/2008/03/sml", "targetType");
            String targetRequired = this.getAttributeValue("http://www.w3.org/2008/03/sml", "targetRequired");
            if (targetElement != null || targetType != null || targetRequired != null) {
                int adjustedLine = this.getAdjustedLocatorLine();
                constraintNode = new ConstraintNode(elementName, this.getFilePath(), adjustedLine, this.getLocator() == null ? -1 : this.getLocator().getColumnNumber());
                String namespace = this.getNamespace();
                constraintNode.setTargetElement(SMLValidatorUtil.toQName(namespace, targetElement));
                constraintNode.setTargetType(SMLValidatorUtil.toQName(namespace, targetType));
                constraintNode.setTargetRequired(targetRequired);
                this.targetSchemaBuilderStructure.put(elementName, constraintNode);
            }
        }
        return constraintNode;
    }

    private String getNamespace() {
        XSElementDeclaration elementDecl;
        ElementPSVI elementPsvi = this.getPsvi().getElementPSVI();
        if (elementPsvi != null && (elementDecl = elementPsvi.getElementDeclaration()) != null) {
            return elementDecl.getNamespace();
        }
        return super.getTargetNamespace();
    }

    protected int getAdjustedLocatorLine() {
        if (this.getLocator() == null) {
            return -1;
        }
        return this.getBaseLineNumber() + this.getLocator().getLineNumber() - 1;
    }

    public ElementTypeMap getElementTypeMap() {
        return this.elementTypeMap;
    }

    protected String getAttributeValue(String uri, String attribute) throws DOMException {
        AbstractDataBuilder.AnnotationResult annotationResult = this.retrieveElementAnnotation(uri, attribute);
        if (annotationResult != null) {
            return annotationResult.getNodes()[0].getNodeValue();
        }
        return null;
    }

    @Override
    public void characters(char[] ch, int start, int len) throws SAXException {
        if (this.uriElementFound) {
            String target = new String(ch, start, len);
            this.dataStructure.put(this.currentTargetElement, target);
            String uri = this.currentTargetElement.getTargetURI();
            this.currentTargetElement.setTargetURI(uri == null ? target : String.valueOf(uri) + target);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.uriElementFound && "uri".equals(localName)) {
            this.uriElementFound = false;
            this.currentTargetElement = null;
        }
    }

    public Map<String, ConstraintNode> getTargetSchemaBuilderStructure() {
        return this.targetSchemaBuilderStructure;
    }

    public Map<String, Map<String, String>> getSubstitutionGroupStructure() {
        return this.substitutionElementStructure;
    }
}

