/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.cosmos.rm.internal.validation.artifacts.TypeNode;
import org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInheritanceDataBuilder
extends AbstractDataBuilder<Map<String, Map<String, TypeNode>>> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilder";
    private Map<String, Map<String, TypeNode>> inheritanceMap = new HashMap<String, Map<String, TypeNode>>();
    private Map<String, Map<String, Map<String, String>>> attributes = new Hashtable<String, Map<String, Map<String, String>>>();

    @Override
    public Map<String, Map<String, TypeNode>> getDataStructure() {
        return this.inheritanceMap;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String targetNameSpace;
        if ("http://www.w3.org/2001/XMLSchema".equals(uri)) {
            return;
        }
        ElementPSVI elementPsvi = this.getPsvi().getElementPSVI();
        if (elementPsvi == null) {
            return;
        }
        XSTypeDefinition typeDef = elementPsvi.getTypeDefinition();
        if (typeDef == null || typeDef.getTypeCategory() != 15 || typeDef.getNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
            return;
        }
        String complexTypeName = typeDef.getName();
        if (complexTypeName == null) {
            return;
        }
        Hashtable<String, String> complexTypeAtts = new Hashtable<String, String>();
        AbstractDataBuilder.AnnotationResult annotationResult = SMLValidatorUtil.retrieveAnnotation(typeDef, "http://www.w3.org/2008/03/sml", "acyclic", true);
        if (annotationResult != null) {
            complexTypeAtts.put("acyclic", annotationResult.getNodes()[0].getNodeValue());
        }
        TypeNode currentComplexType = new TypeNode(complexTypeName, (targetNameSpace = typeDef.getNamespace()) == null ? "" : targetNameSpace);
        Map<?, ?> typesPerUri = SMLValidatorUtil.retrieveNestedMap(this.attributes, currentComplexType.getUri(), true);
        typesPerUri.put(currentComplexType.getType(), complexTypeAtts);
        short derivationMethod = ((XSComplexTypeDefinition)typeDef).getDerivationMethod();
        if (1 == derivationMethod || 2 == derivationMethod) {
            if (typeDef.getBaseType().getNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
                return;
            }
            String parentTypeName = typeDef.getBaseType().getName();
            String parentTypeNamespace = typeDef.getBaseType().getNamespace();
            TypeNode parent = new TypeNode(parentTypeName, parentTypeNamespace);
            this.validateRelationship(parent, currentComplexType);
            Map<?, ?> namesPerUri = SMLValidatorUtil.retrieveNestedMap(this.inheritanceMap, currentComplexType.getUri(), true);
            namesPerUri.put(currentComplexType.getType(), parent);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    public static boolean isDerivedType(Map<String, Map<String, TypeNode>> inheritanceMap, TypeNode possibleAncestorType, TypeNode refType) {
        if (possibleAncestorType.equals(refType)) {
            return true;
        }
        TypeNode currentType = refType;
        while (currentType != null) {
            Map<String, TypeNode> namePerUri = inheritanceMap.get(currentType.getUri());
            TypeNode typeNode = currentType = namePerUri == null ? null : namePerUri.get(currentType.getType());
            if (!possibleAncestorType.equals(currentType)) continue;
            return true;
        }
        return false;
    }

    private void validateRelationship(TypeNode baseType, TypeNode complexType) {
        if (this.isTypeAcyclic(baseType, false) && !this.isTypeAcyclic(complexType, true)) {
            this.setStructureValidity(false);
            if (this.getErrorMessage() == null) {
                this.setErrorMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(this.getLocator().getLineNumber(), NLS.bind((String)SMLValidationMessages.acyclicBadDerivation, (Object[])new String[]{baseType.getType(), complexType.getType()})));
            } else {
                this.appendToErrorMessage(NLS.bind((String)SMLValidationMessages.acyclicBadDerivation, (Object[])new String[]{baseType.getType(), complexType.getType()}));
            }
        }
    }

    private boolean isTypeAcyclic(TypeNode complexType, boolean defaultValue) {
        String acyclicValue;
        Map<String, String> typeAttributes;
        if (complexType.getUri() == null || complexType.getType() == null) {
            return false;
        }
        Map<String, Map<String, String>> namesPerUri = this.attributes.get(complexType.getUri());
        Map<String, String> map = typeAttributes = namesPerUri == null ? null : namesPerUri.get(complexType.getType());
        if (typeAttributes != null && (acyclicValue = typeAttributes.get("acyclic")) != null) {
            return "true".equalsIgnoreCase(acyclicValue);
        }
        return defaultValue;
    }

    public static TypeNode retrieveType(Map<String, Map<String, TypeNode>> inheritance, String uri, String localName) {
        Map<String, TypeNode> typesPerUri = inheritance.get(uri);
        return typesPerUri == null ? null : typesPerUri.get(localName);
    }
}

