/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.content;

import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.cosmos.rm.internal.validation.SMLActivator;
import org.eclipse.cosmos.rm.internal.validation.common.ISMLConstants;

public class DefinitionContentDescriber extends AbstractXMLContentDescriber
{
	/**
	 * The content type id for definition documents
	 */
	public static final String ID = SMLActivator.PLUGIN_ID + ".definitionContentType";


	
	public int determineType(String line)
	{		
		return ISMLConstants.SCHEMA_ELEMENT.equals(retrieveElementName(line)) ? IContentDescriber.VALID : IContentDescriber.INVALID;
	}
}
