/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.reference;

import javax.xml.namespace.NamespaceContext;

/**
 * This interface is used to represent a XPointer scheme
 * 
 * @see XPointerScheme
 * @see XmlnsScheme
 * @author Ali Mehregani
 */
public interface IXScheme
{
	/**
	 * Returns the expression associated with this scheme
	 * 
	 * @return The string associated with this scheme
	 */
	public String getExpression();
	
	
	/**
	 * Sets the expression associated with this scheme
	 * 
	 * @param expression The expression that should be associated with
	 * this scheme
	 */
	public void setExpression(String expression);

	
	/**
	 * Returns the type of this scheme
	 * 
	 * @return The type
	 */
	public String getType();
	
	
	/**
	 * Evaluates this scheme and returns an object as a result of
	 * the evaluation. 
	 * 
	 * @param context The context of this scheme
	 * @return An object representing the evaluation of the scheme
	 * @throws BadExpressionException When there is an error in evaluating the expression
	 */
	public Object evaluate(Object context) throws BadExpressionException;
	
	
	/**
	 * Returns the namespace context associated with 
	 * this scheme.
	 * 
	 * @return The namespace context
	 */
	public NamespaceContext getNamespaceContext();
	
	
	/**
	 * Sets a namespace context for this scheme
	 * 
	 * @param namespaceContext The namespace context to be
	 * associated with this scheme
	 */
	public void setNamespaceContext(NamespaceContext namespaceContext);
}
