/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.PrintWriter;
import java.util.List;
import org.eclipse.cosmos.dc.broker.provisional.client.BrokerClient;
import org.eclipse.cosmos.dc.broker.provisional.client.DataManager;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Service;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.IOutputterConstants;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.LoggerWrapper;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.BrokerNodeDecorator;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.INodeDecorator;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerOutputter
extends AbstractOutputter
implements IOutputterConstants {
    private static ILogger logger = LoggerWrapper.getLogger(BrokerOutputter.class);

    @Override
    public void render(PrintWriter output, IParameters input) throws Exception {
        String query = input.getParameter("query");
        String nodeDecoratorStr = input.getParameter("nodeDecorator");
        INodeDecorator nodeDecorator = null;
        if (nodeDecoratorStr != null) {
            try {
                nodeDecorator = (INodeDecorator)Class.forName(nodeDecoratorStr).newInstance();
            }
            catch (RuntimeException e) {
                logger.warn(e.getMessage(), e);
            }
        } else {
            nodeDecorator = new BrokerNodeDecorator();
        }
        if ("directMDR".equals(input.getParameter("func"))) {
            this.generateMDRJsonNode(output, nodeDecorator, input.getParameter("name"), input.getParameter("queryservice"));
        } else if (query != null && query.equalsIgnoreCase("mdr")) {
            String uri = this.context.getInitParameter("BROKER_EPR");
            BrokerClient brokerclient = new BrokerClient(uri);
            List dataManagers = brokerclient.getDataManagerByNamespace("http://cmdbf.org/schema/1-0-0/query");
            String exclude = input.getParameter("exclude");
            if (exclude != null && !"null".equals(exclude)) {
                int i = 0;
                int dataManagerCount = dataManagers.size();
                while (i < dataManagerCount) {
                    DataManager dataManager = (DataManager)dataManagers.get(i);
                    String epr = dataManager.getServiceEPR("http://www.eclipse.org/cosmos/datamanager");
                    if (exclude.equals(epr)) {
                        dataManagers.remove(i);
                        break;
                    }
                    ++i;
                }
            }
            this.generateJsonNodeList(output, nodeDecorator, dataManagers, "http://cmdbf.org/schema/1-0-0/query");
        } else if (query != null && query.equalsIgnoreCase("cmdbf")) {
            String uri = this.context.getInitParameter("BROKER_EPR");
            BrokerClient brokerclient = new BrokerClient(uri);
            List dataManagers = brokerclient.getDataManagerByNamespace("http://cmdbf.org/schema/1-0-0/registration");
            this.generateJsonNodeList(output, nodeDecorator, dataManagers, "http://cmdbf.org/schema/1-0-0/registration");
        } else {
            String uri = this.context.getInitParameter("BROKER_EPR");
            BrokerClient brokerclient = new BrokerClient(uri);
            List dataManagers = brokerclient.getDataManagers();
            output.print("{ identifier: \"object\",  label: \"title\",  items:[");
            int index = 0;
            while (index < dataManagers.size()) {
                DataManager dm = (DataManager)dataManagers.get(index);
                String dmName = nodeDecorator.getDisplayName(dm);
                String nodeClass = nodeDecorator.getNodeClass(dm);
                if (index > 0) {
                    output.print(",");
                }
                List services = dm.getServices();
                String serviceStr = "";
                String propertiesStr = "";
                int x = 0;
                while (x < services.size()) {
                    Service service = (Service)services.get(x);
                    if (x > 0) {
                        serviceStr = String.valueOf(serviceStr) + ",";
                        propertiesStr = String.valueOf(propertiesStr) + ",";
                    }
                    serviceStr = String.valueOf(serviceStr) + "[\"" + service.getNamespace() + "\", \"" + service.getEndpointReference() + "\"]";
                    propertiesStr = String.valueOf(propertiesStr) + "['" + service.getNamespace() + "', '" + service.getEndpointReference() + "']";
                    ++x;
                }
                output.print("{nodeClass:\"" + nodeClass + "\", title:\"" + dmName + "\"," + " object:\"dm" + index + "\"," + " services:[" + serviceStr + "]");
                output.print(", store:[");
                output.print("['name', '[" + dmName + "]']");
                output.print(",['mdrId', '[" + dm.getId() + "]']");
                output.print(",['description', '[" + dm.getDescription() + "]']");
                output.print(",['soapNamespace', '[" + dm.getSoapNamespace() + "]']");
                output.print(",['recordTypeNamespace', '[" + dm.getRecordTypeNamespace() + "]']");
                output.print(",['securityNamespace', '[" + dm.getSecurityNamespace() + "]']");
                output.print("," + propertiesStr);
                output.print("]}");
                ++index;
            }
            output.print("]}");
        }
    }

    protected void generateJsonNodeList(PrintWriter output, INodeDecorator nodeDecorator, List<DataManager> dataManagers, String namespace) {
        output.print("[");
        int index = 0;
        while (index < dataManagers.size()) {
            DataManager dm = dataManagers.get(index);
            String dmName = nodeDecorator.getDisplayName(dm);
            if (index > 0) {
                output.print(",");
            }
            String queryServiceEPR = dm.getServiceEPR(namespace);
            String eprString = queryServiceEPR.replace("\n", "");
            output.print("[ \"" + dmName + "\"," + " '" + eprString + "', " + " '" + nodeDecorator.getNodeClass(dm) + "' ]");
            ++index;
        }
        output.print("]");
    }

    protected void generateMDRJsonNode(PrintWriter output, INodeDecorator nodeDecorator, String dmName, String queryService) {
        output.print("{ identifier: \"object\",  label: \"title\",  items:[");
        if (dmName == null) {
            dmName = nodeDecorator.getDisplayName(null);
        }
        String nodeClass = nodeDecorator.getNodeClass(null);
        String serviceStr = "[\"http://cmdbf.org/schema/1-0-0/query\", \"" + queryService + "\"]";
        String propertiesStr = "['http://cmdbf.org/schema/1-0-0/query', '" + queryService + "']";
        output.print("{nodeClass:\"" + nodeClass + "\", title:\"" + dmName + "\"," + " object:\"dm0\"," + " services:[" + serviceStr + "]");
        output.print(", store:[");
        output.print("['name', '[" + dmName + "]']");
        output.print("," + propertiesStr);
        output.print("]}");
        output.print("]}");
    }
}

