/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.ReportDeploymentHandler;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.ReportElement;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterContext;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

public class ReportDeployment
extends AbstractOutputter {
    protected IOutputterContext context;

    public void initalize(IOutputterContext context, IParameters parameters) throws Exception {
        super.initalize(context, parameters);
        this.context = context;
        this.setupReportContext(context);
    }

    public void render(PrintWriter output, IParameters input) throws Exception {
        String func = input.getParameter("func");
        if (func != null) {
            if (func.equals("list")) {
                this.generateReportList(output, input);
            } else if (func.equals("url")) {
                this.generateURL(output, input);
            }
        }
    }

    protected void generateReportList(PrintWriter out, IParameters input) throws ServletException, IOException {
        String type = input.getParameter("value");
        Map registry = (Map)this.context.getStore().getAttribute("COSMOS_REPORT_REGISTRY");
        ReportElement element = (ReportElement)registry.get(type);
        if (element != null) {
            out.print("[{\"caption\":\"" + element.getCaption() + "\",\"value\":\"" + element.getId() + "\"}]");
        } else {
            out.print("[{}]");
        }
        out.close();
    }

    protected void generateURL(PrintWriter out, IParameters input) throws ServletException, IOException {
        String reportId = input.getParameter("reportId");
        Map templateLookup = (Map)this.context.getStore().getAttribute("COSMOS_REPORT_TEMPLATE_LOOKUP");
        ReportElement elem = (ReportElement)templateLookup.get(reportId);
        String reportURL = this.context.getInitParameter("COSMOS_REPORT_URL");
        if (elem != null) {
            String filename = new String("../COSMOSUI/" + elem.getFilename());
            Map parameters = input.getParameterMap();
            Iterator param = parameters.keySet().iterator();
            String paramStr = "";
            while (param.hasNext()) {
                Object key = param.next();
                paramStr = String.valueOf(paramStr) + "&" + key + "=" + input.getParameter(key.toString());
            }
            out.print(String.valueOf(reportURL) + "/frameset?__report=" + filename + paramStr);
        }
        out.close();
    }

    protected void setupReportContext(IOutputterContext context) throws ServletException {
        if (context.getStore().getAttribute("COSMOS_REPORT_REGISTRY") == null) {
            ReportDeploymentHandler rdh = new ReportDeploymentHandler();
            String filename = context.getInitParameter("COSMOS_REPORT_DEPLOYMENT_FILE");
            rdh.parse(context.getRealPath(filename));
            context.getStore().setAttribute("COSMOS_REPORT_REGISTRY", rdh.getRegistry());
            context.getStore().setAttribute("COSMOS_REPORT_TEMPLATE_LOOKUP", rdh.getTemplateLookup());
        }
    }
}

