/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.dom;

import org.apache.axiom.om.OMConstants;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.dom.SOAPElement;
import org.apache.axiom.soap.impl.dom.SOAPEnvelopeImpl;

public abstract class SOAPBodyImpl
extends SOAPElement
implements SOAPBody,
OMConstants {
    protected boolean hasSOAPFault = false;

    public SOAPBodyImpl(SOAPEnvelope envelope, SOAPFactory factory) throws SOAPProcessingException {
        super((OMElement)envelope, "Body", true, factory);
    }

    public SOAPBodyImpl(SOAPEnvelope envelope, OMXMLParserWrapper builder, SOAPFactory factory) {
        super((OMElement)envelope, "Body", builder, factory);
    }

    public abstract SOAPFault addFault(Exception var1) throws OMException;

    public boolean hasFault() {
        if (this.hasSOAPFault) {
            return true;
        }
        OMElement element = this.getFirstElement();
        if (element != null && "Fault".equals(element.getLocalName()) && ("http://schemas.xmlsoap.org/soap/envelope/".equals(element.getNamespace().getNamespaceURI()) || "http://www.w3.org/2003/05/soap-envelope".equals(element.getNamespace().getNamespaceURI()))) {
            this.hasSOAPFault = true;
            return true;
        }
        return false;
    }

    public SOAPFault getFault() {
        OMElement element = this.getFirstElement();
        if (this.hasSOAPFault) {
            return (SOAPFault)element;
        }
        if (element != null && "Fault".equals(element.getLocalName()) && ("http://schemas.xmlsoap.org/soap/envelope/".equals(element.getNamespace().getNamespaceURI()) || "http://www.w3.org/2003/05/soap-envelope".equals(element.getNamespace().getNamespaceURI()))) {
            this.hasSOAPFault = true;
            return (SOAPFault)element;
        }
        return null;
    }

    public void addFault(SOAPFault soapFault) throws OMException {
        if (this.hasSOAPFault) {
            throw new OMException("SOAP Body already has a SOAP Fault and there can not be more than one SOAP fault");
        }
        this.addChild((OMNode)soapFault);
        this.hasSOAPFault = true;
    }

    protected void checkParent(OMElement parent) throws SOAPProcessingException {
        if (!(parent instanceof SOAPEnvelopeImpl)) {
            throw new SOAPProcessingException("Expecting an implementation of SOAP Envelope as the parent. But received some other implementation");
        }
    }
}

