/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.descriptor;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.muse.core.Environment;
import org.apache.muse.core.descriptor.CapabilityDefinition;
import org.apache.muse.core.descriptor.CapabilityDescriptor;
import org.apache.muse.core.descriptor.DescriptorConstants;
import org.apache.muse.core.descriptor.InitParamDescriptor;
import org.apache.muse.core.descriptor.ResourceDefinition;
import org.apache.muse.core.descriptor.ResourceDescriptor;
import org.apache.muse.core.descriptor.SimpleCapabilityDescriptor;
import org.apache.muse.core.descriptor.SimpleInitParamDescriptor;
import org.apache.muse.core.descriptor.WsdlConfig;
import org.apache.muse.core.routing.MessageHandler;
import org.apache.muse.core.routing.ReflectionMessageHandler;
import org.apache.muse.core.routing.ResourceIdFactory;
import org.apache.muse.util.ReflectUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleResourceDescriptor
implements ResourceDescriptor {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$core$descriptor$SimpleResourceDescriptor == null ? (class$org$apache$muse$core$descriptor$SimpleResourceDescriptor = SimpleResourceDescriptor.class$("org.apache.muse.core.descriptor.SimpleResourceDescriptor")) : class$org$apache$muse$core$descriptor$SimpleResourceDescriptor);
    private static final String _REQUIRED_CAPABILITIES = "org.apache.muse.core.descriptor.ext.RequiredCapabilityImplementations";
    private ResourceDefinition _definition = null;
    static /* synthetic */ Class class$org$apache$muse$core$descriptor$SimpleResourceDescriptor;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$apache$muse$core$Capability;
    static /* synthetic */ Class class$org$apache$muse$core$Resource;
    static /* synthetic */ Class class$org$apache$muse$core$routing$ResourceIdFactory;

    protected Collection createCapabilityDefinitions(Element xml, Environment env, WsdlConfig wsdlConfig) throws SoapFault {
        Document wsdlDoc = WsdlUtils.createWSDL(env, wsdlConfig.getWsdlPath(), true);
        Map opsByAction = this.getWsdlOperations(wsdlDoc, wsdlConfig, env);
        Element[] capXML = XmlUtils.getElements(xml, DescriptorConstants.CAPABILITY_QNAME);
        ArrayList<CapabilityDefinition> definitions = new ArrayList<CapabilityDefinition>(capXML.length);
        Map requiredClassesByURI = this.createRequiredClasses(env);
        for (int n = 0; n < capXML.length; ++n) {
            CapabilityDescriptor cd = this.createCapabilityDescriptor();
            cd.load(capXML[n], env);
            CapabilityDefinition definition = cd.getCapabilityDefinition();
            String uri = definition.getURI();
            Class implClass = definition.getImplementationClass();
            if (requiredClassesByURI.keySet().contains(uri)) {
                String requiredClassName = (String)requiredClassesByURI.get(uri);
                if (implClass != null) {
                    Object[] filler = new Object[]{uri, requiredClassName};
                    throw new RuntimeException(_MESSAGES.get("RequiredCapability", filler));
                }
                implClass = ReflectUtils.getClass(requiredClassName, env.getClassLoader());
                definition.setImplementationClass(implClass);
            }
            Collection handlers = this.createMessageHandlers(wsdlDoc, opsByAction, implClass);
            definition.setMessageHandlers(handlers);
            definitions.add(definition);
        }
        if (!opsByAction.isEmpty()) {
            Object[] filler = new Object[]{wsdlConfig.getWsdlPath(), opsByAction.keySet()};
            throw new RuntimeException(_MESSAGES.get("MissingOperationImplementations", filler));
        }
        return definitions;
    }

    protected CapabilityDescriptor createCapabilityDescriptor() {
        return new SimpleCapabilityDescriptor();
    }

    protected String createContextPath(Element xml) {
        QName qname = DescriptorConstants.CONTEXT_PATH_QNAME;
        String path = XmlUtils.getElementText(xml, qname);
        if (path == null) {
            throw new RuntimeException(_MESSAGES.get("NullContextPath"));
        }
        return path;
    }

    protected InitParamDescriptor createInitParamDescriptor() {
        return new SimpleInitParamDescriptor();
    }

    protected MessageHandler createMessageHandler(String actionURI, QName operationName, QName returnValueName) {
        return new ReflectionMessageHandler(actionURI, operationName, returnValueName);
    }

    protected Collection createMessageHandlers(Document wsdlDoc, Map opsByAction, Class theClass) {
        HashMap<String, Method> methodsByName = new HashMap<String, Method>();
        Method[] methods = theClass.getMethods();
        for (int n = 0; n < methods.length; ++n) {
            Class<?> declaringClass = methods[n].getDeclaringClass();
            if (declaringClass == (class$java$lang$Object == null ? SimpleResourceDescriptor.class$("java.lang.Object") : class$java$lang$Object) || declaringClass == (class$org$apache$muse$core$Capability == null ? SimpleResourceDescriptor.class$("org.apache.muse.core.Capability") : class$org$apache$muse$core$Capability)) continue;
            methodsByName.put(methods[n].getName(), methods[n]);
        }
        ArrayList<MessageHandler> handlers = new ArrayList<MessageHandler>(opsByAction.size());
        Iterator i = opsByAction.keySet().iterator();
        while (i.hasNext()) {
            String action = (String)i.next();
            Operation next = (Operation)opsByAction.get(action);
            QName inputName = WsdlUtils.getInputPartName(next);
            QName outputName = WsdlUtils.getOutputPartName(next, wsdlDoc);
            String localName = next.getName();
            String methodName = this.getMethodName(localName);
            Method method = (Method)methodsByName.get(methodName);
            if (method == null) continue;
            MessageHandler handler = this.createMessageHandler(action, inputName, outputName);
            handler.setMethod(method);
            handlers.add(handler);
            i.remove();
        }
        return handlers;
    }

    protected Map createRequiredClasses(Environment env) {
        ResourceBundle bundle = null;
        HashMap<String, String> requiredClassesByURI = new HashMap<String, String>();
        try {
            bundle = ResourceBundle.getBundle(_REQUIRED_CAPABILITIES, Locale.getDefault(), env.getClassLoader());
        }
        catch (MissingResourceException notFound) {
            return requiredClassesByURI;
        }
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String next = keys.nextElement();
            requiredClassesByURI.put(next, bundle.getString(next));
        }
        return requiredClassesByURI;
    }

    protected Class createResourceClass(Element xml, Environment env) {
        ClassLoader loader;
        Class resourceClass;
        QName qname = DescriptorConstants.JAVA_RESOURCE_QNAME;
        String className = XmlUtils.getElementText(xml, qname);
        if (className == null) {
            throw new RuntimeException(_MESSAGES.get("NullJavaResourceClass"));
        }
        if (!(class$org$apache$muse$core$Resource == null ? (class$org$apache$muse$core$Resource = SimpleResourceDescriptor.class$("org.apache.muse.core.Resource")) : class$org$apache$muse$core$Resource).isAssignableFrom(resourceClass = ReflectUtils.getClass(className, loader = env.getClassLoader()))) {
            Object[] filler = new Object[]{className, (class$org$apache$muse$core$Resource == null ? (class$org$apache$muse$core$Resource = SimpleResourceDescriptor.class$("org.apache.muse.core.Resource")) : class$org$apache$muse$core$Resource).getName()};
            String message = _MESSAGES.get("IncorrectResourceRoot", filler);
            throw new RuntimeException(message);
        }
        return resourceClass;
    }

    protected ResourceIdFactory createResourceIdFactory(Element xml, Environment env) {
        ClassLoader loader;
        QName qname = DescriptorConstants.JAVA_ID_FACTORY_QNAME;
        String className = XmlUtils.getElementText(xml, qname);
        if (className == null) {
            return null;
        }
        Class theClass = null;
        if (!(class$org$apache$muse$core$routing$ResourceIdFactory == null ? (class$org$apache$muse$core$routing$ResourceIdFactory = SimpleResourceDescriptor.class$("org.apache.muse.core.routing.ResourceIdFactory")) : class$org$apache$muse$core$routing$ResourceIdFactory).isAssignableFrom(theClass = ReflectUtils.getClass(className, loader = env.getClassLoader()))) {
            Object[] filler = new Object[]{className, (class$org$apache$muse$core$routing$ResourceIdFactory == null ? (class$org$apache$muse$core$routing$ResourceIdFactory = SimpleResourceDescriptor.class$("org.apache.muse.core.routing.ResourceIdFactory")) : class$org$apache$muse$core$routing$ResourceIdFactory).getName()};
            throw new RuntimeException(_MESSAGES.get("NotResourceIdFactory", filler));
        }
        return (ResourceIdFactory)ReflectUtils.newInstance(theClass);
    }

    protected boolean createUsingPersistence(Element xml) {
        String attr = xml.getAttribute("use-router-persistence");
        return Boolean.valueOf(attr);
    }

    protected WsdlConfig createWSDL(Element xml) {
        QName qname = DescriptorConstants.WSDL_QNAME;
        Element wsdlXML = XmlUtils.getElement(xml, qname);
        if (wsdlXML == null) {
            throw new RuntimeException(_MESSAGES.get("NullWSDLFile"));
        }
        qname = DescriptorConstants.WSDL_FILE_QNAME;
        String path = XmlUtils.getElementText(wsdlXML, qname);
        if (path == null) {
            throw new RuntimeException(_MESSAGES.get("NullWSDLLocation"));
        }
        qname = DescriptorConstants.WSDL_PORT_TYPE_QNAME;
        QName portType = XmlUtils.getQNameFromChild(wsdlXML, qname);
        if (portType == null) {
            throw new RuntimeException(_MESSAGES.get("NullWSDLPortType"));
        }
        WsdlConfig wsdl = new WsdlConfig();
        wsdl.setWsdlPath(path);
        wsdl.setWsdlPortType(portType);
        return wsdl;
    }

    private String getMethodName(String actionName) {
        return Character.toLowerCase(actionName.charAt(0)) + actionName.substring(1);
    }

    public ResourceDefinition getResourceDefinition() {
        return this._definition;
    }

    protected Map getWsdlOperations(Document wsdlDoc, WsdlConfig wsdlConfig, Environment env) {
        QName portTypeName;
        File wsdlFile;
        File wsdlDir;
        Definition def;
        PortType portType;
        String wsdlPath = wsdlConfig.getWsdlPath();
        String absolutePath = env.getRealDirectory().getAbsolutePath();
        if (wsdlPath.charAt(0) != '/') {
            absolutePath = absolutePath + '/';
        }
        if ((portType = (def = WsdlUtils.createDefinition(wsdlDoc, wsdlDir = (wsdlFile = new File(absolutePath = absolutePath + wsdlPath)).getParentFile())).getPortType(portTypeName = wsdlConfig.getWsdlPortType())) == null) {
            Object[] filler = new Object[]{absolutePath, portTypeName};
            throw new RuntimeException(_MESSAGES.get("PortTypeNotFound", filler));
        }
        List ops = portType.getOperations();
        Iterator i = ops.iterator();
        HashMap<String, Operation> opsByAction = new HashMap<String, Operation>();
        while (i.hasNext()) {
            Operation next = (Operation)i.next();
            String action = WsdlUtils.getAction(next);
            opsByAction.put(action, next);
        }
        return opsByAction;
    }

    public void load(Element xml, Environment environment) throws SoapFault {
        boolean isUsingPersistence = this.createUsingPersistence(xml);
        String contextPath = this.createContextPath(xml);
        WsdlConfig wsdl = this.createWSDL(xml);
        ResourceIdFactory idFactory = this.createResourceIdFactory(xml, environment);
        Class resourceClass = this.createResourceClass(xml, environment);
        Collection capabilities = this.createCapabilityDefinitions(xml, environment, wsdl);
        InitParamDescriptor paramDesc = this.createInitParamDescriptor();
        paramDesc.load(xml);
        Map parameters = paramDesc.getInitializationParameters();
        this._definition = new ResourceDefinition();
        this._definition.setEnvironment(environment);
        this._definition.setUsingPersistence(isUsingPersistence);
        this._definition.setContextPath(contextPath);
        this._definition.setWsdlConfig(wsdl);
        this._definition.setResourceIdFactory(idFactory);
        this._definition.setResourceClass(resourceClass);
        this._definition.setCapabilityDefinitions(capabilities);
        this._definition.setInitializationParameters(parameters);
    }

    public void setResourceDefinition(ResourceDefinition definition) {
        this._definition = definition;
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        ResourceDefinition def = this.getResourceDefinition();
        Element root = XmlUtils.createElement(doc, DescriptorConstants.RESOURCE_TYPE_QNAME);
        boolean persistence = def.isUsingPersistence();
        root.setAttribute("use-router-persistence", Boolean.toString(persistence));
        XmlUtils.setElement(root, DescriptorConstants.CONTEXT_PATH_QNAME, def.getContextPath());
        WsdlConfig wsdl = def.getWsdlConfig();
        Element wsdlXML = XmlUtils.createElement(doc, DescriptorConstants.WSDL_QNAME);
        XmlUtils.setElement(wsdlXML, DescriptorConstants.WSDL_FILE_QNAME, wsdl.getWsdlPath());
        XmlUtils.setElement(wsdlXML, DescriptorConstants.WSDL_PORT_TYPE_QNAME, wsdl.getWsdlPortType());
        root.appendChild(wsdlXML);
        ResourceIdFactory factory = def.getResourceIdFactory();
        if (factory != null) {
            XmlUtils.setElement(root, DescriptorConstants.JAVA_ID_FACTORY_QNAME, factory.getClass().getName());
        }
        XmlUtils.setElement(root, DescriptorConstants.JAVA_RESOURCE_QNAME, def.getResourceClass().getName());
        Iterator i = def.getCapabilityDefinitions().iterator();
        while (i.hasNext()) {
            CapabilityDefinition next = (CapabilityDefinition)i.next();
            CapabilityDescriptor cd = this.createCapabilityDescriptor();
            cd.setCapabilityDefinition(next);
            Element capabilityXML = cd.toXML(doc);
            root.appendChild(capabilityXML);
        }
        Map parameters = def.getInitializationParameters();
        if (parameters != null) {
            InitParamDescriptor id = this.createInitParamDescriptor();
            id.setInitializationParameters(parameters);
            Element initParamXML = id.toXML(doc);
            XmlUtils.moveSubTree(initParamXML, root);
        }
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

