/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.addressing;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.muse.util.MultiMap;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.uuid.RandomUuidFactory;
import org.apache.muse.util.xml.XmlSerializable;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.addressing.soap.SoapConstants;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MessageHeaders
implements XmlSerializable {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$ws$addressing$MessageHeaders == null ? (class$org$apache$muse$ws$addressing$MessageHeaders = MessageHeaders.class$("org.apache.muse.ws.addressing.MessageHeaders")) : class$org$apache$muse$ws$addressing$MessageHeaders);
    private static final String _REQUEST = "Request";
    private static final String _RESPONSE = "Response";
    private String _action = null;
    private Map _customHeadersByQName = new MultiMap();
    private EndpointReference _faultTo = null;
    private EndpointReference _from = null;
    private String _messageID = null;
    private String _relationship = null;
    private EndpointReference _replyTo = null;
    private EndpointReference _to = null;
    static /* synthetic */ Class class$org$apache$muse$ws$addressing$MessageHeaders;

    public MessageHeaders(Element soapHeaders) throws SoapFault {
        Object[] filler;
        if (soapHeaders == null) {
            throw new NullPointerException(_MESSAGES.get("NullSOAPHeader"));
        }
        String toURI = XmlUtils.getElementText(soapHeaders, WsaConstants.TO_QNAME);
        this._action = XmlUtils.getElementText(soapHeaders, WsaConstants.ACTION_QNAME);
        this._messageID = XmlUtils.getElementText(soapHeaders, WsaConstants.MESSAGE_ID_QNAME);
        this._relationship = XmlUtils.getElementText(soapHeaders, WsaConstants.RELATES_TO_QNAME);
        if (toURI == null) {
            filler = new Object[]{WsaConstants.TO_QNAME};
            this.throwInvalidAddressingHeaderFault(_MESSAGES.get("HeaderMissing", filler));
        }
        if (this._action == null) {
            filler = new Object[]{WsaConstants.ACTION_QNAME};
            this.throwInvalidAddressingHeaderFault(_MESSAGES.get("HeaderMissing", filler));
        }
        this._to = new EndpointReference(URI.create(toURI));
        this._faultTo = this.getEPR(soapHeaders, WsaConstants.FAULT_TO_QNAME);
        this._from = this.getEPR(soapHeaders, WsaConstants.FROM_QNAME);
        this._replyTo = this.getEPR(soapHeaders, WsaConstants.REPLY_TO_QNAME);
        if (this._messageID == null && (this._from != null || this._replyTo != null)) {
            this.throwInvalidAddressingHeaderFault(_MESSAGES.get("MessageIDMissing"));
        }
        Element[] children = XmlUtils.getAllElements(soapHeaders);
        for (int n = 0; n < children.length; ++n) {
            QName qname = XmlUtils.getElementQName(children[n]);
            String wsaAttr = children[n].getAttributeNS("http://www.w3.org/2005/08/addressing", "IsReferenceParameter");
            if (Boolean.valueOf(wsaAttr) == Boolean.TRUE) {
                children[n].removeAttributeNS("http://www.w3.org/2003/05/soap-envelope", "actor");
                children[n].removeAttributeNS("http://www.w3.org/2003/05/soap-envelope", "mustUnderstand");
                this._to.addParameter(qname, children[n]);
                continue;
            }
            if (qname.getNamespaceURI().equals("http://www.w3.org/2005/08/addressing")) continue;
            this._customHeadersByQName.put(qname, children[n]);
        }
    }

    public MessageHeaders(EndpointReference to, String action) {
        if (to == null) {
            throw new NullPointerException(_MESSAGES.get("NullToEPR"));
        }
        this._to = to;
        this._action = action;
        this._messageID = this.createMessageID();
    }

    public MessageHeaders createFaultHeaders() {
        EndpointReference faultTo = this.getFaultToAddress();
        String messageID = this.getMessageID();
        if (faultTo == null) {
            EndpointReference from = this.getFromAddress();
            if (from == null) {
                from = WsaConstants.ANONYMOUS_EPR;
            }
            faultTo = from;
        }
        MessageHeaders faultHeaders = new MessageHeaders(faultTo, "http://www.w3.org/2005/08/addressing/fault");
        if (messageID != null) {
            faultHeaders.setRelationship(messageID);
        }
        faultHeaders.setFromAddress(this.getToAddress());
        return faultHeaders;
    }

    private String createMessageID() {
        return RandomUuidFactory.getInstance().createUUID();
    }

    public MessageHeaders createReplyHeaders() {
        EndpointReference replyTo = this.getReplyToAddress();
        String messageID = this.getMessageID();
        if (replyTo == null) {
            EndpointReference from = this.getFromAddress();
            if (from == null) {
                from = WsaConstants.ANONYMOUS_EPR;
            }
            replyTo = from;
        }
        String requestAction = this.getAction().toString();
        String replyAction = null;
        int requestSuffix = requestAction.lastIndexOf(_REQUEST);
        replyAction = requestSuffix >= 0 ? requestAction.substring(0, requestSuffix) + _RESPONSE : requestAction + _RESPONSE;
        MessageHeaders replyHeaders = new MessageHeaders(replyTo, replyAction);
        if (messageID != null) {
            replyHeaders.setRelationship(messageID);
        }
        replyHeaders.setFromAddress(this.getToAddress());
        return replyHeaders;
    }

    public String getAction() {
        return this._action;
    }

    public Element getCustomHeader(QName elementName) {
        Collection headers = this.getCustomHeaders(elementName);
        return headers.isEmpty() ? null : (Element)headers.iterator().next();
    }

    public Collection getCustomHeaders(QName elementName) {
        Collection headers = (Collection)this._customHeadersByQName.get(elementName);
        return headers != null ? headers : Collections.EMPTY_LIST;
    }

    public Collection getCustomHeaderNames() {
        return Collections.unmodifiableSet(this._customHeadersByQName.keySet());
    }

    private EndpointReference getEPR(Element root, QName qname) throws SoapFault {
        Element epr = XmlUtils.getElement(root, qname);
        if (epr == null) {
            return null;
        }
        return new EndpointReference(epr);
    }

    public EndpointReference getFaultToAddress() {
        return this._faultTo;
    }

    public EndpointReference getFromAddress() {
        return this._from;
    }

    public String getMessageID() {
        return this._messageID;
    }

    public String getMethodName() {
        int lastSlash;
        String actionURI = this.getAction().toString();
        String name = actionURI.substring((lastSlash = actionURI.lastIndexOf(47)) + 1);
        int request = name.indexOf(_REQUEST);
        if (request >= 0) {
            name = name.substring(0, request);
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public String getRelationship() {
        return this._relationship;
    }

    public QName getRelationshipType() {
        return WsaConstants.REPLY_RELATIONSHIP_QNAME;
    }

    public EndpointReference getReplyToAddress() {
        return this._replyTo;
    }

    public EndpointReference getToAddress() {
        return this._to;
    }

    protected void setAction(String action) {
        if (action == null) {
            throw new NullPointerException(_MESSAGES.get("NullActionURI"));
        }
        this._action = action;
    }

    public void setFaultToAddress(EndpointReference faultTo) {
        this._faultTo = faultTo == null ? null : new EndpointReference(faultTo, WsaConstants.FAULT_TO_QNAME);
    }

    public void setFromAddress(EndpointReference from) {
        this._from = from == null ? null : new EndpointReference(from, WsaConstants.FROM_QNAME);
    }

    protected void setMessageID(String messageID) {
        if (messageID == null) {
            throw new NullPointerException(_MESSAGES.get("NullMessageID"));
        }
        this._messageID = messageID;
    }

    public void setRelationship(String relationship) {
        if (relationship == null) {
            throw new NullPointerException(_MESSAGES.get("NullRelatesTo"));
        }
        this._relationship = relationship;
    }

    public void setReplyToAddress(EndpointReference replyTo) {
        this._replyTo = replyTo == null ? null : new EndpointReference(replyTo, WsaConstants.REPLY_TO_QNAME);
    }

    protected void setToAddress(EndpointReference to) {
        if (to == null) {
            throw new NullPointerException(_MESSAGES.get("NullToEPR"));
        }
        this._to = to;
    }

    protected void throwInvalidAddressingHeaderFault(String message) throws SoapFault {
        SoapFault fault = new SoapFault(message);
        fault.setCode(SoapConstants.SENDER_QNAME);
        fault.setSubCode(WsaConstants.INVALID_HEADER_FAULT_QNAME);
        throw fault;
    }

    public String toString() {
        return XmlUtils.toString(this.toXML(), false);
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        String relatesTo;
        if (doc == null) {
            throw new NullPointerException(_MESSAGES.get("NullXMLDocument"));
        }
        Element soapHeaders = XmlUtils.createElement(doc, SoapConstants.HEADER_QNAME);
        URI toURI = this.getToAddress().getAddress();
        Element to = XmlUtils.createElement(doc, WsaConstants.TO_QNAME, toURI);
        soapHeaders.appendChild(to);
        XmlUtils.setElement(soapHeaders, WsaConstants.ACTION_QNAME, this.getAction());
        String messageID = this.getMessageID();
        if (messageID != null) {
            XmlUtils.setElement(soapHeaders, WsaConstants.MESSAGE_ID_QNAME, messageID);
        }
        if ((relatesTo = this.getRelationship()) != null) {
            Element relationship = XmlUtils.createElement(doc, WsaConstants.RELATES_TO_QNAME, relatesTo);
            String type = XmlUtils.toString(this.getRelationshipType());
            relationship.setAttribute("RelationshipType", type);
            soapHeaders.appendChild(relationship);
        }
        EndpointReference[] eprs = new EndpointReference[]{this.getFromAddress(), this.getReplyToAddress(), this.getFaultToAddress()};
        for (int n = 0; n < eprs.length; ++n) {
            if (eprs[n] == null) continue;
            Element xml = eprs[n].toXML();
            xml = (Element)doc.importNode(xml, true);
            soapHeaders.appendChild(xml);
        }
        Element[] parameters = this.getToAddress().getParameters();
        for (int n = 0; n < parameters.length; ++n) {
            Element copy = (Element)doc.importNode(parameters[n], true);
            copy.setAttributeNS("http://www.w3.org/2005/08/addressing", "wsa:IsReferenceParameter", "true");
            soapHeaders.appendChild(copy);
        }
        Iterator i = this.getCustomHeaderNames().iterator();
        while (i.hasNext()) {
            QName qname = (QName)i.next();
            Iterator j = this.getCustomHeaders(qname).iterator();
            while (j.hasNext()) {
                Element next = (Element)j.next();
                next = (Element)doc.importNode(next, true);
                soapHeaders.appendChild(next);
            }
        }
        return soapHeaders;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

