/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.clustering.configuration.ConfigurationManager;
import org.apache.axis2.clustering.context.ContextManager;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ContextListener;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.DependencyManager;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.threadpool.ThreadFactory;
import org.apache.axis2.util.threadpool.ThreadPool;

public class ConfigurationContext
extends AbstractContext {
    private final Map operationContextMap = new HashMap();
    private Hashtable serviceGroupContextMap = new Hashtable();
    private Hashtable applicationSessionServiceGroupContexts = new Hashtable();
    private AxisConfiguration axisConfiguration;
    private ThreadFactory threadPool;
    private ListenerManager listenerManager;
    private long serviceGroupContextTimoutInterval = 30000L;
    private String contextRoot;
    private String servicePath;
    private String cachedServicePath = null;
    protected List contextListeners;

    public ConfigurationContext(AxisConfiguration axisConfiguration) {
        super(null);
        this.axisConfiguration = axisConfiguration;
        this.initConfigContextTimeout(axisConfiguration);
    }

    private void initConfigContextTimeout(AxisConfiguration axisConfiguration) {
        Object value;
        Parameter parameter = axisConfiguration.getParameter("ConfigContextTimeoutInterval");
        if (parameter != null && (value = parameter.getValue()) != null && value instanceof String) {
            this.serviceGroupContextTimoutInterval = Integer.parseInt((String)value);
        }
    }

    public void initCluster() throws AxisFault {
        ClusterManager clusterManager = this.axisConfiguration.getClusterManager();
        if (clusterManager != null) {
            ConfigurationManager configManager;
            ContextManager contextManager = clusterManager.getContextManager();
            if (contextManager != null) {
                contextManager.setConfigurationContext(this);
            }
            if ((configManager = clusterManager.getConfigurationManager()) != null) {
                configManager.setConfigurationContext(this);
            }
            if (ConfigurationContext.shouldClusterBeInitiated(clusterManager)) {
                clusterManager.setConfigurationContext(this);
                clusterManager.init();
            }
        }
    }

    private static boolean shouldClusterBeInitiated(ClusterManager clusterManager) {
        Parameter param = clusterManager.getParameter("AvoidInitiation");
        return param == null || !JavaUtils.isTrueExplicitly(param.getValue());
    }

    void contextCreated(AbstractContext context) {
        if (this.contextListeners == null) {
            return;
        }
        Iterator iter = this.contextListeners.iterator();
        while (iter.hasNext()) {
            ContextListener listener = (ContextListener)iter.next();
            listener.contextCreated(context);
        }
    }

    void contextRemoved(AbstractContext context) {
        if (this.contextListeners == null) {
            return;
        }
        Iterator iter = this.contextListeners.iterator();
        while (iter.hasNext()) {
            ContextListener listener = (ContextListener)iter.next();
            listener.contextRemoved(context);
        }
    }

    public void addContextListener(ContextListener contextListener) {
        if (this.contextListeners == null) {
            this.contextListeners = new ArrayList();
        }
        this.contextListeners.add(contextListener);
    }

    public void removeContextListener(ContextListener contextListener) {
        if (this.contextListeners != null) {
            this.contextListeners.remove(contextListener);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void fillServiceContextAndServiceGroupContext(MessageContext messageContext) throws AxisFault {
        ServiceContext serviceContext = messageContext.getServiceContext();
        AxisService axisService = messageContext.getAxisService();
        if (serviceContext == null) {
            String scope = axisService.getScope();
            if ("application".equals(scope)) {
                String serviceGroupName = axisService.getAxisServiceGroup().getServiceGroupName();
                ServiceGroupContext serviceGroupContext = (ServiceGroupContext)this.applicationSessionServiceGroupContexts.get(serviceGroupName);
                if (serviceGroupContext == null) {
                    AxisServiceGroup axisServiceGroup = messageContext.getAxisServiceGroup();
                    if (axisServiceGroup == null) {
                        axisServiceGroup = axisService.getAxisServiceGroup();
                        messageContext.setAxisServiceGroup(axisServiceGroup);
                    }
                    ConfigurationContext cfgCtx = messageContext.getConfigurationContext();
                    serviceGroupContext = cfgCtx.createServiceGroupContext(axisServiceGroup);
                    this.applicationSessionServiceGroupContexts.put(serviceGroupName, serviceGroupContext);
                }
                messageContext.setServiceGroupContext(serviceGroupContext);
                messageContext.setServiceContext(serviceGroupContext.getServiceContext(axisService));
            } else if ("soapsession".equals(scope)) {
                ServiceGroupContext serviceGroupContext;
                this.cleanupServiceGroupContexts();
                String serviceGroupContextId = messageContext.getServiceGroupContextId();
                if (serviceGroupContextId != null) {
                    serviceGroupContext = this.getServiceGroupContextFromSoapSessionTable(serviceGroupContextId, messageContext);
                    if (serviceGroupContext == null) {
                        serviceGroupContext = new ServiceGroupContext(this, axisService.getAxisServiceGroup());
                        serviceGroupContext.setId(serviceGroupContextId);
                        this.addServiceGroupContextIntoSoapSessionTable(serviceGroupContext);
                    }
                } else {
                    AxisServiceGroup axisServiceGroup = axisService.getAxisServiceGroup();
                    serviceGroupContext = this.createServiceGroupContext(axisServiceGroup);
                    serviceContext = serviceGroupContext.getServiceContext(axisService);
                    serviceGroupContextId = UUIDGenerator.getUUID();
                    serviceGroupContext.setId(serviceGroupContextId);
                    messageContext.setServiceGroupContextId(serviceGroupContextId);
                    this.addServiceGroupContextIntoSoapSessionTable(serviceGroupContext);
                }
                messageContext.setServiceGroupContext(serviceGroupContext);
                messageContext.setServiceContext(serviceGroupContext.getServiceContext(axisService));
            } else if ("request".equals(scope)) {
                AxisServiceGroup axisServiceGroup = axisService.getAxisServiceGroup();
                ServiceGroupContext serviceGroupContext = this.createServiceGroupContext(axisServiceGroup);
                messageContext.setServiceGroupContext(serviceGroupContext);
                serviceContext = serviceGroupContext.getServiceContext(axisService);
                messageContext.setServiceContext(serviceContext);
            }
        }
        if (messageContext.getOperationContext() != null) {
            messageContext.getOperationContext().setParent(serviceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerOperationContext(String messageID, OperationContext mepContext) {
        mepContext.setKey(messageID);
        Map map = this.operationContextMap;
        synchronized (map) {
            if (!this.operationContextMap.containsKey(messageID)) {
                this.operationContextMap.put(messageID, mepContext);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOperationContext(String key) {
        Map map = this.operationContextMap;
        synchronized (map) {
            OperationContext opCtx = (OperationContext)this.operationContextMap.get(key);
            this.operationContextMap.remove(key);
            this.contextRemoved(opCtx);
        }
    }

    public void addServiceGroupContextIntoSoapSessionTable(ServiceGroupContext serviceGroupContext) {
        String id = serviceGroupContext.getId();
        this.serviceGroupContextMap.put(id, serviceGroupContext);
        serviceGroupContext.touch();
        serviceGroupContext.setParent(this);
        this.cleanupServiceGroupContexts();
    }

    public void addServiceGroupContextIntoApplicationScopeTable(ServiceGroupContext serviceGroupContext) {
        if (this.applicationSessionServiceGroupContexts == null) {
            this.applicationSessionServiceGroupContexts = new Hashtable();
        }
        this.applicationSessionServiceGroupContexts.put(serviceGroupContext.getDescription().getServiceGroupName(), serviceGroupContext);
    }

    public void deployService(AxisService service) throws AxisFault {
        this.axisConfiguration.addService(service);
        if ("application".equals(service.getScope())) {
            ServiceGroupContext sgc = this.createServiceGroupContext(service.getAxisServiceGroup());
            DependencyManager.initService(sgc);
        }
    }

    public AxisConfiguration getAxisConfiguration() {
        return this.axisConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationContext getOperationContext(String id) {
        OperationContext opCtx;
        Map map = this.operationContextMap;
        synchronized (map) {
            if (this.operationContextMap == null) {
                return null;
            }
            opCtx = (OperationContext)this.operationContextMap.get(id);
        }
        return opCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationContext findOperationContext(String operationName, String serviceName, String serviceGroupName) {
        if (operationName == null) {
            return null;
        }
        if (serviceName == null) {
            return null;
        }
        Map map = this.operationContextMap;
        synchronized (map) {
            Iterator it = this.operationContextMap.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                OperationContext value = (OperationContext)this.operationContextMap.get(key);
                if (value == null) continue;
                String valueOperationName = value.getOperationName();
                String valueServiceName = value.getServiceName();
                String valueServiceGroupName = value.getServiceGroupName();
                if (valueOperationName == null || !valueOperationName.equals(operationName) || valueServiceName == null || !valueServiceName.equals(serviceName)) continue;
                if (valueServiceGroupName != null && serviceGroupName != null && valueServiceGroupName.equals(serviceGroupName)) {
                    return value;
                }
                if (valueServiceGroupName != null || serviceGroupName != null) continue;
                return value;
            }
        }
        return null;
    }

    public MessageContext createMessageContext() {
        MessageContext msgCtx = new MessageContext(this);
        this.contextCreated(msgCtx);
        return msgCtx;
    }

    public ServiceGroupContext createServiceGroupContext(AxisServiceGroup serviceGroup) {
        ServiceGroupContext sgCtx = new ServiceGroupContext(this, serviceGroup);
        this.contextCreated(sgCtx);
        return sgCtx;
    }

    public File getRealPath(String path) {
        URL repository = this.axisConfiguration.getRepository();
        if (repository != null) {
            File repo = new File(repository.getFile());
            return new File(repo, path);
        }
        return null;
    }

    public ServiceGroupContext getServiceGroupContextFromSoapSessionTable(String serviceGroupContextId, MessageContext msgContext) throws AxisFault {
        ServiceGroupContext serviceGroupContext = (ServiceGroupContext)this.serviceGroupContextMap.get(serviceGroupContextId);
        if (serviceGroupContext != null) {
            serviceGroupContext.touch();
            return serviceGroupContext;
        }
        throw new AxisFault("Unable to find corresponding context for the serviceGroupId: " + serviceGroupContextId);
    }

    public ServiceGroupContext getServiceGroupContext(String serviceGroupCtxId) {
        if (serviceGroupCtxId == null) {
            return null;
        }
        ServiceGroupContext serviceGroupContext = null;
        if (this.serviceGroupContextMap != null) {
            serviceGroupContext = (ServiceGroupContext)this.serviceGroupContextMap.get(serviceGroupCtxId);
            if (serviceGroupContext != null) {
                serviceGroupContext.touch();
            } else {
                serviceGroupContext = (ServiceGroupContext)this.applicationSessionServiceGroupContexts.get(serviceGroupCtxId);
                if (serviceGroupContext != null) {
                    serviceGroupContext.touch();
                }
            }
        }
        return serviceGroupContext;
    }

    public String[] getServiceGroupContextIDs() {
        String[] ids = new String[this.serviceGroupContextMap.size() + this.applicationSessionServiceGroupContexts.size()];
        int index = 0;
        Iterator iter = this.serviceGroupContextMap.keySet().iterator();
        while (iter.hasNext()) {
            ids[index] = (String)iter.next();
            ++index;
        }
        iter = this.applicationSessionServiceGroupContexts.keySet().iterator();
        while (iter.hasNext()) {
            ids[index] = (String)iter.next();
            ++index;
        }
        return ids;
    }

    public Hashtable getServiceGroupContexts() {
        return this.serviceGroupContextMap;
    }

    public ThreadFactory getThreadPool() {
        if (this.threadPool == null) {
            this.threadPool = new ThreadPool();
        }
        return this.threadPool;
    }

    public void setAxisConfiguration(AxisConfiguration configuration) {
        this.axisConfiguration = configuration;
    }

    public void setThreadPool(ThreadFactory pool) throws AxisFault {
        if (this.threadPool != null) {
            throw new AxisFault(Messages.getMessage("threadpoolset"));
        }
        this.threadPool = pool;
    }

    public void removeServiceGroupContext(String serviceGroupContextId) {
        if (this.serviceGroupContextMap == null) {
            return;
        }
        ServiceGroupContext serviceGroupContext = (ServiceGroupContext)this.serviceGroupContextMap.get(serviceGroupContextId);
        this.serviceGroupContextMap.remove(serviceGroupContextId);
        this.cleanupServiceContexts(serviceGroupContext);
    }

    private void cleanupServiceGroupContexts() {
        if (this.serviceGroupContextMap == null) {
            return;
        }
        long currentTime = new Date().getTime();
        Iterator sgCtxtMapKeyIter = this.serviceGroupContextMap.keySet().iterator();
        while (sgCtxtMapKeyIter.hasNext()) {
            String sgCtxtId = (String)sgCtxtMapKeyIter.next();
            ServiceGroupContext serviceGroupContext = (ServiceGroupContext)this.serviceGroupContextMap.get(sgCtxtId);
            if (currentTime - serviceGroupContext.getLastTouchedTime() <= this.getServiceGroupContextTimoutInterval()) continue;
            sgCtxtMapKeyIter.remove();
            this.cleanupServiceContexts(serviceGroupContext);
            this.contextRemoved(serviceGroupContext);
        }
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public void setTransportManager(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
    }

    private void cleanupServiceContexts(ServiceGroupContext serviceGroupContext) {
        if (serviceGroupContext == null) {
            return;
        }
        Iterator serviceContextIter = serviceGroupContext.getServiceContexts();
        if (serviceContextIter == null) {
            return;
        }
        while (serviceContextIter.hasNext()) {
            ServiceContext serviceContext = (ServiceContext)serviceContextIter.next();
            DependencyManager.destroyServiceObject(serviceContext);
        }
    }

    public void cleanupContexts() {
        ServiceGroupContext serviceGroupContext;
        if (this.applicationSessionServiceGroupContexts != null && this.applicationSessionServiceGroupContexts.size() > 0) {
            Iterator applicationScopeSgs = this.applicationSessionServiceGroupContexts.values().iterator();
            while (applicationScopeSgs.hasNext()) {
                serviceGroupContext = (ServiceGroupContext)applicationScopeSgs.next();
                this.cleanupServiceContexts(serviceGroupContext);
            }
            this.applicationSessionServiceGroupContexts.clear();
        }
        if (this.serviceGroupContextMap != null && this.serviceGroupContextMap.size() > 0) {
            Iterator soapSessionSgs = this.serviceGroupContextMap.values().iterator();
            while (soapSessionSgs.hasNext()) {
                serviceGroupContext = (ServiceGroupContext)soapSessionSgs.next();
                this.cleanupServiceContexts(serviceGroupContext);
            }
            this.serviceGroupContextMap.clear();
        }
    }

    public void terminate() throws AxisFault {
        if (this.listenerManager != null) {
            this.listenerManager.stop();
        }
        this.axisConfiguration.cleanup();
        this.cleanupTemp();
    }

    private void cleanupTemp() {
        File tempFile = (File)this.axisConfiguration.getParameterValue("artifactsDIR");
        if (tempFile == null) {
            tempFile = new File(System.getProperty("java.io.tmpdir"), "_axis2");
        }
        this.deleteTempFiles(tempFile);
    }

    private void deleteTempFiles(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                this.deleteTempFiles(new File(dir, children[i]));
            }
        }
        dir.delete();
    }

    public String getServiceContextPath() {
        if (this.cachedServicePath == null) {
            this.cachedServicePath = this.internalGetServiceContextPath();
        }
        return this.cachedServicePath;
    }

    private String internalGetServiceContextPath() {
        String ctxRoot = this.getContextRoot();
        String path = "/";
        if (ctxRoot != null) {
            if (!ctxRoot.equals("/")) {
                path = ctxRoot + "/";
            }
            if (this.servicePath == null || this.servicePath.trim().length() == 0) {
                throw new IllegalArgumentException("service path cannot be null or empty");
            }
            path = path + this.servicePath.trim();
        }
        return path;
    }

    public String getServicePath() {
        if (this.servicePath == null || this.servicePath.trim().length() == 0) {
            throw new IllegalArgumentException("service path cannot be null or empty");
        }
        return this.servicePath.trim();
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        if (contextRoot != null) {
            this.contextRoot = contextRoot.trim();
            this.cachedServicePath = this.internalGetServiceContextPath();
        }
    }

    public long getServiceGroupContextTimoutInterval() {
        Integer serviceGroupContextTimoutIntervalParam = (Integer)this.getProperty("ConfigContextTimeoutInterval");
        if (serviceGroupContextTimoutIntervalParam != null) {
            this.serviceGroupContextTimoutInterval = serviceGroupContextTimoutIntervalParam.intValue();
        }
        return this.serviceGroupContextTimoutInterval;
    }

    public void removeServiceGroupContext(AxisServiceGroup serviceGroup) {
        Object obj;
        if (serviceGroup != null && (obj = this.applicationSessionServiceGroupContexts.get(serviceGroup.getServiceGroupName())) == null) {
            ArrayList<String> toBeRemovedList = new ArrayList<String>();
            Iterator serviceGroupContexts = this.serviceGroupContextMap.values().iterator();
            while (serviceGroupContexts.hasNext()) {
                ServiceGroupContext serviceGroupContext = (ServiceGroupContext)serviceGroupContexts.next();
                if (!serviceGroupContext.getDescription().equals(serviceGroup)) continue;
                toBeRemovedList.add(serviceGroupContext.getId());
            }
            for (int i = 0; i < toBeRemovedList.size(); ++i) {
                String s = (String)toBeRemovedList.get(i);
                this.serviceGroupContextMap.remove(s);
            }
        }
    }

    public ConfigurationContext getRootContext() {
        return this;
    }
}

