/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.internal.cmdbf.services.registration.transform.input.artifacts;

import java.io.StringWriter;
import java.util.List;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.AbstractGraphCollection;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElementCollection;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;

public abstract class GraphElementCollection extends AbstractGraphCollection implements IGraphElementCollection {
	
	private boolean idList;

	public GraphElementCollection(boolean idList, List<IGraphElement> elements) 
	{
		this(idList);
		setElements(elements.toArray(new IGraphElement[elements.size()]));
	}

	public GraphElementCollection(boolean idList) 
	{
		super((String)null);
		this.idList = idList;
	}
	
	protected abstract String getElementName(boolean idList);

	public void toXML(StringWriter writer, int indent) {
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + getElementName(idList))+ICMDBfServicesConstants.nl);
		
		if (idList)
		{
			for (int i = 0, elementCount = getCollection().size(); i < elementCount; i++)
			{
				IGraphElement element = getCollection().get(i);
				IInstanceId[] instanceIds = element.getInstanceIds();
				for (int j = 0; j < instanceIds.length; j++)
				{
					CMDBfServicesUtil.addIndent(writer, indent+1);
					writer.write(CMDBfServicesUtil.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + ICMDBfServicesConstants.INSTANCE_ID_ELEMENT)+ICMDBfServicesConstants.nl);
					
					CMDBfServicesUtil.addIndent(writer, indent+2);
					writer.write(CMDBfServicesUtil.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + ICMDBfServicesConstants.MDR_ID_ELEMENT) +
								instanceIds[j].getMdrId().toString() + 
								CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + ICMDBfServicesConstants.MDR_ID_ELEMENT) +
								ICMDBfServicesConstants.nl);
					
					CMDBfServicesUtil.addIndent(writer, indent+2);
					writer.write(CMDBfServicesUtil.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + ICMDBfServicesConstants.LOCAL_ID_ELEMENT) +
								instanceIds[j].getLocalId().toString() + 
								CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + ICMDBfServicesConstants.LOCAL_ID_ELEMENT) +
								ICMDBfServicesConstants.nl);

					CMDBfServicesUtil.addIndent(writer, indent+1);
					writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + ICMDBfServicesConstants.INSTANCE_ID_ELEMENT)+ICMDBfServicesConstants.nl);
				}
			}			
		}
		else
		{
			CMDBfServicesUtil.outputListToXML(writer, indent+1, getCollection());
		}
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + getElementName(idList))+ICMDBfServicesConstants.nl);
	}

	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((getCollection() == null) ? 0 : getCollection().hashCode());
		return result;
	}

	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final GraphElementCollection other = (GraphElementCollection) obj;
		if (getCollection() == null) {
			if (other.getCollection() != null)
				return false;
		} else if (!getCollection().equals(other.getCollection()))
			return false;
		return true;
	}


}
