/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.ServletException;

import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterContext;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

public class ReportDeployment extends AbstractOutputter {
	protected IOutputterContext context;

	@Override
	public void initalize(IOutputterContext context, IParameters parameters)
			throws Exception {
		super.initalize(context, parameters);
		this.context = context;
		setupReportContext(context);
	}

	public void render(PrintWriter output, IParameters input) throws Exception {
		String func = input.getParameter("func"); //$NON-NLS-1$
		if (func != null){
			if (func.equals("list")) //$NON-NLS-1$
				this.generateReportList(output, input);
			else if (func.equals("url")){ //$NON-NLS-1$
				this.generateURL(output, input);
			}
		}
	}

	protected void generateReportList(PrintWriter out, IParameters input) throws ServletException, IOException {
		String type = input.getParameter("value"); //$NON-NLS-1$
		Map registry = (Map)context.getStore().getAttribute("COSMOS_REPORT_REGISTRY"); //$NON-NLS-1$
		ReportElement element = (ReportElement)registry.get(type);
		if (element != null){
			out.print("[{\"caption\":\""+element.getCaption()+"\",\"value\":\""+element.getId()+"\"}]");			 //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		}
		else{
			out.print("[{}]"); //$NON-NLS-1$
		}
		out.close();		
	}
	
	protected void generateURL(PrintWriter out, IParameters input) throws ServletException, IOException {
		String reportId = input.getParameter("reportId"); //$NON-NLS-1$
		
		Map templateLookup = (Map)context.getStore().getAttribute("COSMOS_REPORT_TEMPLATE_LOOKUP"); //$NON-NLS-1$
		ReportElement elem = (ReportElement)templateLookup.get(reportId);
		String reportURL = context.getInitParameter("COSMOS_REPORT_URL"); //$NON-NLS-1$
		if (elem != null){
			String filename = new String("../COSMOSUI/" + elem.getFilename()); //$NON-NLS-1$
			Map parameters = input.getParameterMap();
			Iterator param = parameters.keySet().iterator();
			String paramStr= ""; //$NON-NLS-1$
			while (param.hasNext()){
				Object key = param.next();
				paramStr += "&"+key+"="+input.getParameter(key.toString()); //$NON-NLS-1$ //$NON-NLS-2$
			}
			out.print(reportURL+"/frameset?__report="+filename+paramStr); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		}
		out.close();		
	}
	
	protected void setupReportContext(IOutputterContext context) throws ServletException {
		if (context.getStore().getAttribute("COSMOS_REPORT_REGISTRY") == null){ //$NON-NLS-1$
			ReportDeploymentHandler rdh = new ReportDeploymentHandler();
			String filename = context.getInitParameter("COSMOS_REPORT_DEPLOYMENT_FILE"); //$NON-NLS-1$
			rdh.parse(context.getRealPath(filename));
			context.getStore().setAttribute("COSMOS_REPORT_REGISTRY", rdh.getRegistry()); //$NON-NLS-1$
			context.getStore().setAttribute("COSMOS_REPORT_TEMPLATE_LOOKUP", rdh.getTemplateLookup()); //$NON-NLS-1$
		}
	}
		
}
