/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.provisional.datamanager;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Set;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;

public class DataManager {
	public static final String DATA_MANAGER_NAMESPACE = "http://www.eclipse.org/cosmos/datamanager";

	public OMElement getDataManagerInfo(String locale) throws Exception {
		ConfigurationManager m = DoProp();

		OMFactory fac = OMAbstractFactory.getOMFactory();
		OMNamespace omNs =
		    fac.createOMNamespace(DATA_MANAGER_NAMESPACE, "ns");//$NON-NLS-1$
		OMElement method = fac.createOMElement("getDataManagerInfoResponse", omNs);//$NON-NLS-1$
		
		Add("id",m.getId(),method,fac,omNs);
		Add("name",m.getDisplayName(),method,fac,omNs);
		Add("description",m.getDescription(),method,fac,omNs);
		Add("soapNamespace",m.getSoapNamespace(),method,fac,omNs);
		Add("recordTypeNamespace",m.getRecordTypeNamespace(),method,fac,omNs);
		Add("securityNamespace",m.getSecurityNamespace(),method,fac,omNs);
				
		Properties p = m.getOtherProperties();
		Set ks = p.keySet();
		Object[] o = ks.toArray();
		int i = 0;
		for (i=0;i<o.length;i++) {
			String tstr = o[i].toString();
			String pstr = p.getProperty(tstr);
			
			OMElement value = fac.createOMElement("property", omNs);//$NON-NLS-1$
			value.addChild(fac.createOMText(value, tstr));
			method.addChild(value);
			
			OMElement v2 = fac.createOMElement("value", omNs);//$NON-NLS-1$
			v2.addChild(fac.createOMText(v2, pstr));
			method.addChild(v2);
		}
		
		return method;
	}
	
	public OMElement getSoapVersion(String locale) throws Exception {
		ConfigurationManager m = DoProp();
		String sns = m.getSoapNamespace();
		String s11 = org.apache.axiom.soap.SOAP11Constants.SOAP_ENVELOPE_NAMESPACE_URI;
		String s12 = org.apache.axiom.soap.SOAP12Constants.SOAP_ENVELOPE_NAMESPACE_URI;   
		String rns = null;
		
		OMFactory fac = OMAbstractFactory.getOMFactory();
		OMNamespace omNs =
		    fac.createOMNamespace(DATA_MANAGER_NAMESPACE, "ns");//$NON-NLS-1$
		OMElement method = fac.createOMElement("getSoapVersionResponse", omNs);//$NON-NLS-1$
		
		if (sns.equals(s11))
			rns = new String("1.1");
		if (sns.equals(s12))
			rns = new String("1.2");
		if (rns == null)
			rns = new String("unknown");
		Add("version",rns,method,fac,omNs);
		
		return method;
	}
	
	private void Add(String label,String str,OMElement method,OMFactory fac,OMNamespace omNs) 
	{
		OMElement Value = fac.createOMElement(label, omNs);//$NON-NLS-1$
		Value.addChild(fac.createOMText(Value, str));
		method.addChild(Value);
	}
	
	private ConfigurationManager DoProp() throws Exception {
		ConfigurationManager ret = null;

		URL resource = this.getClass().getClassLoader().getResource("META-INF/cosmos.properties");//$NON-NLS-1$
		InputStream in = resource.openStream();
		ret = new ConfigurationManager();
		ret.Init(in);
		
		return ret;
	}
}

