/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.resource.lifetime.impl;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.TimerTask;
import javax.xml.namespace.QName;
import org.apache.muse.core.routing.MessageHandler;
import org.apache.muse.util.LoggingUtils;
import org.apache.muse.util.ReflectUtils;
import org.apache.muse.util.Timer;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.impl.AbstractWsResourceCapability;
import org.apache.muse.ws.resource.lifetime.ScheduledTermination;
import org.apache.muse.ws.resource.lifetime.impl.SetTerminationTimeHandler;

public class SimpleScheduledTermination
extends AbstractWsResourceCapability
implements ScheduledTermination {
    protected static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$ws$resource$lifetime$impl$SimpleScheduledTermination == null ? (class$org$apache$muse$ws$resource$lifetime$impl$SimpleScheduledTermination = SimpleScheduledTermination.class$("org.apache.muse.ws.resource.lifetime.impl.SimpleScheduledTermination")) : class$org$apache$muse$ws$resource$lifetime$impl$SimpleScheduledTermination);
    private Timer _terminationTimer = new Timer();
    static /* synthetic */ Class class$org$apache$muse$ws$resource$lifetime$impl$SimpleScheduledTermination;

    protected MessageHandler createSetTerminationTimeHandler() {
        SetTerminationTimeHandler handler = new SetTerminationTimeHandler();
        Method method = ReflectUtils.getFirstMethod(this.getClass(), "setTerminationTime");
        handler.setMethod(method);
        return handler;
    }

    public Date getCurrentTime() {
        return new Date();
    }

    public QName[] getPropertyNames() {
        return ScheduledTermination.PROPERTIES;
    }

    public Date getTerminationTime() {
        return this._terminationTimer.getScheduledTime();
    }

    public void initialize() throws SoapFault {
        super.initialize();
        this.setMessageHandler(this.createSetTerminationTimeHandler());
    }

    public Date setTerminationTime(Date time) {
        if (time == null) {
            this._terminationTimer.cancel();
        } else if (this._terminationTimer.getScheduledTime() == null) {
            DestroyTimerTask terminationTask = new DestroyTimerTask(this.getWsResource());
            this._terminationTimer.schedule(terminationTask, time);
        } else {
            DestroyTimerTask terminationTask = new DestroyTimerTask(this.getWsResource());
            this._terminationTimer.reschedule(terminationTask, time);
        }
        return time;
    }

    public void shutdown() throws SoapFault {
        this._terminationTimer.cancel();
        super.shutdown();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DestroyTimerTask
    extends TimerTask {
        private WsResource _resource = null;

        public DestroyTimerTask(WsResource resource) {
            this._resource = resource;
        }

        public void run() {
            try {
                this._resource.shutdown();
            }
            catch (SoapFault fault) {
                LoggingUtils.logError(this._resource.getLog(), fault);
            }
        }
    }
}

