/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.wsdl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.muse.core.Environment;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.util.xml.XsdUtils;
import org.apache.muse.ws.addressing.WsaConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WsdlUtils {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$ws$wsdl$WsdlUtils == null ? (class$org$apache$muse$ws$wsdl$WsdlUtils = WsdlUtils.class$("org.apache.muse.ws.wsdl.WsdlUtils")) : class$org$apache$muse$ws$wsdl$WsdlUtils);
    public static final String NAMESPACE_URI = "http://schemas.xmlsoap.org/wsdl/";
    public static final String PREFIX = "wsdl";
    public static final String SOAP_URI = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String SOAP_PREFIX = "wsdl-soap";
    public static final QName ADDRESS_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address", "wsdl-soap");
    public static final QName BINDING_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "binding", "wsdl");
    public static final QName DEFINITIONS_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "definitions", "wsdl");
    public static final QName IMPORT_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "import", "wsdl");
    public static final QName INPUT_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "input", "wsdl");
    public static final String LOCATION = "location";
    public static final QName MESSAGE_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "message", "wsdl");
    public static final String NAME = "name";
    public static final QName OPERATION_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "operation", "wsdl");
    public static final QName OUTPUT_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "output", "wsdl");
    public static final QName PORT_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "port", "wsdl");
    public static final QName PORT_TYPE_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "portType", "wsdl");
    public static final QName SERVICE_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "service", "wsdl");
    public static final QName TYPES_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "types", "wsdl");
    public static final String WSDL4J_VERBOSE_FLAG = "javax.wsdl.verbose";
    public static final String DEFAULT_SERVICE_NAME = "MyService";
    public static final String SERVICES = "services";
    static /* synthetic */ Class class$org$apache$muse$ws$wsdl$WsdlUtils;

    private static void addNamespacePrefixes(Element nextSchema, Element finalSchema) {
        NamedNodeMap attributes = nextSchema.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (finalSchema.hasAttribute(attribute.getNodeName())) continue;
            String nodePrefix = finalSchema.getPrefix();
            String nodeValue = attribute.getLocalName();
            if (nodePrefix != null && nodePrefix.equals(nodeValue)) continue;
            finalSchema.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
        }
    }

    public static Document addSchemaImports(Document wsdl, String wsdlPath, Environment environment, Set namespaces) {
        Element root = XmlUtils.getFirstElement(wsdl);
        Element types = XmlUtils.getElement(root, TYPES_QNAME);
        Element[] schemas = XmlUtils.getElements(types, XsdUtils.SCHEMA_QNAME);
        for (int n = 0; n < schemas.length; ++n) {
            WsdlUtils.addSchemaImports(types, schemas[n], wsdlPath, environment, namespaces);
        }
        return wsdl;
    }

    private static void addSchemaImports(Element schemaContainer, Element currentSchema, String path, Environment environment, Set namespaces) {
        Element[] imports = XmlUtils.getElements(currentSchema, XsdUtils.IMPORT_QNAME);
        Document doc = schemaContainer.getOwnerDocument();
        for (int n = 0; n < imports.length; ++n) {
            String nextPath;
            Document importDoc;
            Element nextSchema;
            String targetNS;
            String location = imports[n].getAttribute("schemaLocation");
            if (location.length() == 0 || namespaces.contains(targetNS = (nextSchema = XmlUtils.getFirstElement(importDoc = environment.getDocument(nextPath = environment.createRelativePath(path, location)))).getAttribute("targetNamespace"))) continue;
            nextSchema = (Element)doc.importNode(nextSchema, true);
            schemaContainer.appendChild(nextSchema);
            namespaces.add(targetNS);
            WsdlUtils.addSchemaImports(schemaContainer, nextSchema, nextPath, environment, namespaces);
        }
    }

    public static Document addSchemaIncludes(Document wsdl, String wsdlPath, Environment environment, Set namespaces) {
        Element root = XmlUtils.getFirstElement(wsdl);
        Element types = XmlUtils.getElement(root, TYPES_QNAME);
        Element[] schemas = XmlUtils.getElements(types, XsdUtils.SCHEMA_QNAME);
        for (int n = 0; n < schemas.length; ++n) {
            WsdlUtils.addSchemaIncludes(schemas[n], schemas[n], wsdlPath, environment, namespaces);
        }
        return wsdl;
    }

    private static void addSchemaIncludes(Element finalSchema, Element currentSchema, String path, Environment environment, Set namespaces) {
        Element[] includes = XmlUtils.getElements(currentSchema, XsdUtils.INCLUDE_QNAME);
        for (int n = 0; n < includes.length; ++n) {
            String relative = includes[n].getAttribute("schemaLocation");
            String nextPath = environment.createRelativePath(path, relative);
            Document includeDoc = environment.getDocument(nextPath);
            Element nextSchema = XmlUtils.getFirstElement(includeDoc);
            XmlUtils.moveSubTree(nextSchema, finalSchema, includes[n]);
            WsdlUtils.addNamespacePrefixes(nextSchema, finalSchema);
            Element types = (Element)finalSchema.getParentNode();
            WsdlUtils.addSchemaImports(types, nextSchema, nextPath, environment, namespaces);
            WsdlUtils.addSchemaIncludes(finalSchema, nextSchema, nextPath, environment, namespaces);
        }
    }

    public static Definition createDefinition(Document wsdlDoc, File wsdlDir) {
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            reader.setFeature(WSDL4J_VERBOSE_FLAG, false);
            return reader.readWSDL(wsdlDir.getAbsolutePath(), wsdlDoc);
        }
        catch (Exception error) {
            throw new RuntimeException(error);
        }
    }

    public static Document createWSDL(Environment environment, String wsdlPath, boolean resolveReferences) {
        Document wsdl = environment.getDocument(wsdlPath);
        if (!resolveReferences) {
            return wsdl;
        }
        Set namespaces = WsdlUtils.getSchemaNamespaces(wsdl);
        WsdlUtils.addSchemaIncludes(wsdl, wsdlPath, environment, namespaces);
        WsdlUtils.addSchemaImports(wsdl, wsdlPath, environment, namespaces);
        Collection otherWSDLs = WsdlUtils.getWsdlImports(wsdl, wsdlPath, environment);
        Iterator i = otherWSDLs.iterator();
        while (i.hasNext()) {
            Document next = (Document)i.next();
            WsdlUtils.mergeWSDL(next, wsdl, namespaces);
        }
        return wsdl;
    }

    public static String getAction(Operation op) {
        Input input = op.getInput();
        Object attr = input.getExtensionAttribute(WsaConstants.ACTION_QNAME);
        if (attr == null) {
            Object[] filler = new Object[]{op.getName(), input.getName(), input.getExtensionAttributes().keySet()};
            throw new RuntimeException(_MESSAGES.get("NoActionOnInput", filler));
        }
        return attr instanceof String ? (String)attr : ((QName)attr).getLocalPart();
    }

    public static Element getComplexTypeDeclaration(Node wsdl, QName qname) {
        if (wsdl == null) {
            throw new NullPointerException(_MESSAGES.get("NullWSDLDocument"));
        }
        if (qname == null) {
            throw new NullPointerException(_MESSAGES.get("NullTypeQName"));
        }
        Element definitions = null;
        definitions = wsdl.getNodeType() == 9 ? XmlUtils.getFirstElement(wsdl) : (Element)wsdl;
        String name = qname.getLocalPart();
        String uri = qname.getNamespaceURI();
        Element[] elements = XmlUtils.findInSubTree(definitions, XsdUtils.COMPLEX_TYPE_QNAME);
        for (int n = 0; n < elements.length; ++n) {
            Element parent;
            String targetNS;
            String nextName = elements[n].getAttribute(NAME);
            if (!nextName.equals(name) || !uri.equals(targetNS = (parent = (Element)elements[n].getParentNode()).getAttribute("targetNamespace"))) continue;
            return elements[n];
        }
        return null;
    }

    public static Element getElementDeclaration(Node wsdl, QName qname) {
        if (wsdl == null) {
            throw new NullPointerException(_MESSAGES.get("NullWSDLDocument"));
        }
        if (qname == null) {
            throw new NullPointerException(_MESSAGES.get("NullTypeQName"));
        }
        Element definitions = null;
        definitions = wsdl.getNodeType() == 9 ? XmlUtils.getFirstElement(wsdl) : (Element)wsdl;
        Element[] elements = XmlUtils.findInSubTree(definitions, XsdUtils.ELEMENT_QNAME);
        String localName = qname.getLocalPart();
        String uri = qname.getNamespaceURI();
        if (uri == null) {
            Object[] filler = new Object[]{qname};
            String message = _MESSAGES.get("NullTypeNamespaceURI", filler);
            throw new RuntimeException(message);
        }
        for (int n = 0; n < elements.length; ++n) {
            Element parent;
            String targetNS;
            String nextName = elements[n].getAttribute(NAME);
            if (!nextName.equals(localName) || !uri.equals(targetNS = (parent = (Element)elements[n].getParentNode()).getAttribute("targetNamespace"))) continue;
            return elements[n];
        }
        return null;
    }

    public static Element getFirstPortType(Node wsdl) {
        if (wsdl == null) {
            throw new NullPointerException(_MESSAGES.get("NullWSDLDocument"));
        }
        Element root = null;
        root = wsdl.getNodeType() == 1 ? (Element)wsdl : XmlUtils.getFirstElement(wsdl);
        Element[] portTypes = XmlUtils.getElements(root, PORT_TYPE_QNAME);
        if (portTypes.length == 0) {
            return null;
        }
        return portTypes[0];
    }

    public static QName getInputPartName(Operation op) {
        Input input = op.getInput();
        Map parts = input.getMessage().getParts();
        if (parts.size() != 1) {
            Object[] filler = new Object[]{op.getName()};
            throw new RuntimeException(_MESSAGES.get("NotDocLiteral", filler));
        }
        Part docLiteralPart = (Part)parts.values().iterator().next();
        QName partName = docLiteralPart.getElementName();
        String prefix = partName.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            partName = new QName(partName.getNamespaceURI(), partName.getLocalPart(), "muse-op");
        }
        return partName;
    }

    public static QName getOutputPartName(Operation op, Document wsdlDoc) {
        Output output = op.getOutput();
        if (output == null) {
            return null;
        }
        Map parts = output.getMessage().getParts();
        if (parts.size() != 1) {
            Object[] filler = new Object[]{op.getName()};
            throw new RuntimeException(_MESSAGES.get("NotDocLiteral", filler));
        }
        Part docLiteralPart = (Part)parts.values().iterator().next();
        QName responseType = docLiteralPart.getElementName();
        if (responseType == null) {
            return null;
        }
        Element typeDef = WsdlUtils.getElementDeclaration(wsdlDoc, responseType);
        if (typeDef.getChildNodes().getLength() == 0) {
            return null;
        }
        Element returnValueElement = XmlUtils.findFirstInSubTree(typeDef, XsdUtils.ELEMENT_QNAME);
        if (returnValueElement == null) {
            return null;
        }
        String name = returnValueElement.getAttribute(NAME);
        if (name != null && name.length() > 0) {
            return XmlUtils.parseSchemaName(name, returnValueElement);
        }
        String qname = returnValueElement.getAttribute("ref");
        return XmlUtils.parseQName(qname, returnValueElement);
    }

    public static Element getPortType(Node wsdl, QName qname) {
        if (wsdl == null) {
            throw new NullPointerException(_MESSAGES.get("NullWSDLDocument"));
        }
        if (qname == null) {
            throw new NullPointerException(_MESSAGES.get("NullPortTypeQName"));
        }
        Element root = null;
        root = wsdl.getNodeType() == 1 ? (Element)wsdl : XmlUtils.getFirstElement(wsdl);
        Element[] portTypes = XmlUtils.getElements(root, PORT_TYPE_QNAME);
        String localName = qname.getLocalPart();
        String uri = qname.getNamespaceURI();
        if (uri == null) {
            Object[] filler = new Object[]{qname};
            String message = _MESSAGES.get("NullPortTypeNamespaceURI", filler);
            throw new RuntimeException(message);
        }
        String targetNS = root.getAttribute("targetNamespace");
        for (int n = 0; n < portTypes.length; ++n) {
            String next = portTypes[n].getAttribute(NAME);
            if (!next.equals(localName) || !uri.equals(targetNS)) continue;
            return portTypes[n];
        }
        return null;
    }

    public static Set getSchemaNamespaces(Document wsdl) {
        Element root = XmlUtils.getFirstElement(wsdl);
        Element types = XmlUtils.getElement(root, TYPES_QNAME);
        Element[] schemas = XmlUtils.getElements(types, XsdUtils.SCHEMA_QNAME);
        HashSet<String> namespaces = new HashSet<String>();
        for (int n = 0; n < schemas.length; ++n) {
            namespaces.add(schemas[n].getAttribute("targetNamespace"));
        }
        return namespaces;
    }

    public static String getServiceName(Element wsdlDefinition) {
        Element address = XmlUtils.findFirstInSubTree(wsdlDefinition, ADDRESS_QNAME);
        if (address == null) {
            return DEFAULT_SERVICE_NAME;
        }
        String location = address.getAttribute(LOCATION);
        if (location == null) {
            return DEFAULT_SERVICE_NAME;
        }
        int servicesStart = location.indexOf(SERVICES);
        if (servicesStart < 0) {
            return DEFAULT_SERVICE_NAME;
        }
        int serviceNameStart = servicesStart + SERVICES.length() + 1;
        if (serviceNameStart >= location.length()) {
            return DEFAULT_SERVICE_NAME;
        }
        return location.substring(serviceNameStart);
    }

    public static Collection getWsdlImports(Document wsdl, String wsdlPath, Environment environment) {
        return WsdlUtils.getWsdlImports(wsdl, wsdlPath, environment, new ArrayList());
    }

    private static Collection getWsdlImports(Document wsdl, String wsdlPath, Environment environment, Collection otherWSDLs) {
        Element root = XmlUtils.getFirstElement(wsdl);
        Element[] imports = XmlUtils.getElements(root, IMPORT_QNAME);
        for (int n = 0; n < imports.length; ++n) {
            String location = imports[n].getAttribute(LOCATION);
            if (location.length() == 0) continue;
            String nextPath = environment.createRelativePath(wsdlPath, location);
            Document nextWSDL = WsdlUtils.createWSDL(environment, nextPath, true);
            otherWSDLs.add(nextWSDL);
            WsdlUtils.getWsdlImports(nextWSDL, nextPath, environment, otherWSDLs);
        }
        return otherWSDLs;
    }

    public static void mergeWSDL(Document from, Document to, Set namespaces) {
        String targetNS;
        int n;
        Element fromRoot = XmlUtils.getFirstElement(from);
        Element toRoot = XmlUtils.getFirstElement(to);
        Element fromTypes = XmlUtils.getElement(fromRoot, TYPES_QNAME);
        Element toTypes = XmlUtils.getElement(toRoot, TYPES_QNAME);
        Element[] fromSchemas = XmlUtils.getElements(fromTypes, XsdUtils.SCHEMA_QNAME);
        Element[] toSchemas = XmlUtils.getElements(toTypes, XsdUtils.SCHEMA_QNAME);
        HashMap<String, Element> toSchemasByNS = new HashMap<String, Element>();
        for (n = 0; n < toSchemas.length; ++n) {
            targetNS = toSchemas[n].getAttribute("targetNamespace");
            toSchemasByNS.put(targetNS, toSchemas[n]);
        }
        for (n = 0; n < fromSchemas.length; ++n) {
            targetNS = fromSchemas[n].getAttribute("targetNamespace");
            if (!namespaces.contains(targetNS)) {
                fromSchemas[n] = (Element)to.importNode(fromSchemas[n], true);
                toTypes.appendChild(fromSchemas[n]);
            } else {
                Element schema = (Element)toSchemasByNS.get(targetNS);
                Element[] toChildren = XmlUtils.getAllElements(schema);
                Element[] fromChildren = XmlUtils.getAllElements(fromSchemas[n]);
                if (fromChildren.length > toChildren.length) {
                    toTypes.removeChild(schema);
                    fromSchemas[n] = (Element)to.importNode(fromSchemas[n], true);
                    toTypes.appendChild(fromSchemas[n]);
                    toSchemasByNS.put(targetNS, fromSchemas[n]);
                }
            }
            namespaces.add(targetNS);
        }
    }

    private static Element removeSchemaImports(Element schema) {
        Element[] imports = XmlUtils.getElements(schema, XsdUtils.IMPORT_QNAME);
        for (int i = 0; i < imports.length; ++i) {
            imports[i].removeAttribute("schemaLocation");
        }
        return schema;
    }

    private static Element removeSchemaIncludes(Element schema) {
        Element[] includes = XmlUtils.getElements(schema, XsdUtils.INCLUDE_QNAME);
        for (int i = 0; i < includes.length; ++i) {
            schema.removeChild(includes[i]);
        }
        return schema;
    }

    public static Element removeSchemaReferences(Element wsdl) {
        Element types = XmlUtils.getElement(wsdl, TYPES_QNAME);
        Element[] schemas = XmlUtils.getElements(types, XsdUtils.SCHEMA_QNAME);
        for (int i = 0; i < schemas.length; ++i) {
            WsdlUtils.removeSchemaImports(schemas[i]);
            WsdlUtils.removeSchemaIncludes(schemas[i]);
        }
        return wsdl;
    }

    public static Element removeWsdlReferences(Element wsdl) {
        Element[] imports = XmlUtils.getElements(wsdl, IMPORT_QNAME);
        for (int i = 0; i < imports.length; ++i) {
            wsdl.removeChild(imports[i]);
        }
        return wsdl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

