<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<%
/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
%>      
<jsp:useBean id="template" scope="request" class="org.eclipse.cosmos.provisional.dr.ps.common.Template" /> 
 
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<title>COSMOS Web User Interface</title>

<style type="text/css">
	@import "<%= template.getDojoBaseUrl() %>/dojo/resources/dojo.css";
	@import "<%= template.getDojoBaseUrl() %>/dijit/themes/tundra/tundra.css";
	@import "<%= template.getDojoBaseUrl() %>/dojox/grid/_grid/Grid.css";
	@import "<%= template.getPage() %>/css/style.css";
	@import "<%= template.getDojoBaseUrl() %>/dojox/layout/resources/FloatingPane.css"; 
	@import "<%= template.getDojoBaseUrl() %>/dojox/layout/resources/ResizeHandle.css"; 
	@import "js/org/eclipse/cosmos/provisional/dr/ps/components/widget/css/default.css";
</style>

<%= template.header() %>

<script>
dojo.addOnLoad(function(){
	var nav = dijit.byId("nav");
	var navcontent = dojo.byId("navcontent");
	var detail = dijit.byId("detail");
	var detailcontent = dojo.byId("detailcontent");
	var prop = dijit.byId("properties");
	var propcontent = dojo.byId("propertiescontent");

	var newHeight = dijit.getViewport().h - 120;
	var navHeight = newHeight + 9;
	var detailHeight = newHeight * 0.7;
	var propHeight = newHeight * 0.3;
	
	nav.domNode.style.height = navHeight + "px";

	navcontent.style.height = (navHeight - 23) + "px";

	detail.domNode.style.height = detailHeight + "px";
	detail.domNode.style.position = "absolute";
	detail.domNode.style.left = (parseInt(nav.domNode.style.width) + 20) + "px";
	
	detailcontent.style.height = (detailHeight - 23) + "px";

	prop.domNode.style.height = propHeight + "px";
	prop.domNode.style.position = "absolute";
	prop.domNode.style.left = (parseInt(nav.domNode.style.width) + 20) + "px";
	prop.domNode.style.top = (parseInt(detail.domNode.style.height) + 78) + "px";
	
	propcontent.style.height = (propHeight - 23) + "px";
});

</script>

<!-- For debugging purposes.  Make sure this is disabled prior to checking in the file (it causes problems with IE)
<script src="http://localhost:9080/COSMOSUI/js/org/eclipse/cosmos/provisional/dr/ps/components/widget/GraphResponseTreeViewer.js"/>
<script src="http://localhost:9080/COSMOSUI/js/org/eclipse/cosmos/provisional/dr/ps/components/widget/Navigator.js"/>
<script src="http://localhost:9080/COSMOSUI/js/org/eclipse/cosmos/provisional/dr/ps/components/widget/WidgetContainer.js"/>
<script src="http://localhost:9080/COSMOSUI/js/org/eclipse/cosmos/provisional/dr/ps/components/widget/GraphResponseViewer.js"/> -->

</head>
<body class="tundra">
<table width="100%" border="0" cellspacing="10" cellpadding="0">
<tr>
	<td height="35" align="left" bgcolor="#FFFFFF"><img alt='Cosmos Data Visualization UI' title='Cosmos Data Visualization UI COSMOS-1.0.0-200809110902' src='images/bannerLeft.png'/></td>
	<td height="35" align="right"  bgcolor="#FFFFFF"></td>
</tr>
<tr>
	<td>

	<div dojoType="org.eclipse.cosmos.provisional.dr.ps.components.widget.FloatingLayout" title="Data Managers" offsetWidth="20" offsetHeight="20" resizable="false" id="nav" style="width:28%;height:602px;float:left;" duration="300" closable="false">
		<div dojoType="org.eclipse.cosmos.provisional.dr.ps.components.widget.WidgetContainer" attachPoint="nav"  id="navcontent"></div> 
	</div>

	<div dojoType="org.eclipse.cosmos.provisional.dr.ps.components.widget.FloatingLayout" title="Details" offsetWidth="20" offsetHeight="10" resizable="false" id="detail" style="width:70%;height:400px;" duration="300"  closable="false">		
		<div dojoType="org.eclipse.cosmos.provisional.dr.ps.components.widget.WidgetContainer" attachPoint="detail" id="detailcontent"></div>  
	</div>
		
	<div dojoType="org.eclipse.cosmos.provisional.dr.ps.components.widget.FloatingLayout" title="Properties" offsetWidth="20" offsetHeight="0" resizable="false" id="properties" style="width:70%;height:200px" duration="350" closable="false">
		<div dojoType="org.eclipse.cosmos.provisional.dr.ps.components.widget.WidgetContainer" attachPoint="properties" id="propertiescontent"></div>  
	</div>

	<div dojoType="dojox.layout.Dock" id="alternateDock" class="alternateDock"></div>

	</td>
</tr>
</table>
</body>
