/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.eclipse.cosmos.dc.provisional.cmdbf.exception.CMDBfException;
import org.eclipse.cosmos.dc.provisional.cmdbf.registration.client.RegistrationServiceClient;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.input.artifacts.DeregisterInputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.input.artifacts.IDeregisterRequest;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.QueryOutputTransformer;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.input.artifacts.IRegisterRequest;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.input.artifacts.RegisterInputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IRegisterResponse;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IResponse;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRelationship;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.XMLUtil;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.Messages;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.StatusResponseOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RegistrationOutputter
extends AbstractOutputter {
    private Element cleanseResponse(Element queryResponse) throws Exception {
        Element cleansedRoot = XMLUtil.createElement(new QName("http://cmdbf.org/schema/1-0-0/datamodel", "queryResult", "cmdbf"));
        Document document = cleansedRoot.getOwnerDocument();
        NodeList children = queryResponse.getChildNodes();
        int counter = 0;
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(counter);
            Node adoptedNode = document.adoptNode(child);
            if (adoptedNode == null) {
                adoptedNode = document.importNode(child, true);
                ++counter;
            }
            cleansedRoot.appendChild(adoptedNode);
            ++i;
        }
        return cleansedRoot;
    }

    protected InputStream toInputStream(Node rootNode) throws CMDBfException {
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            StringWriter sw = new StringWriter();
            trans.transform(new DOMSource(rootNode), new StreamResult(sw));
            ByteArrayInputStream inputStream = new ByteArrayInputStream(sw.toString().getBytes("UTF-8"));
            return inputStream;
        }
        catch (Exception exception) {
            throw new CMDBfException(Messages.getString("RegistrationOutputter.OPENSTREAM_ERR"));
        }
    }

    private boolean selectedLocalId(String[] localIdList, String localId) {
        String[] stringArray = localIdList;
        int n = localIdList.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id.equalsIgnoreCase(localId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void render(PrintWriter output, IParameters input) throws Exception {
        String cmd = input.getParameter("cmd");
        String cmdbfepr = input.getParameter("cmdbfEPR");
        String queryResp = input.getParameter("queryResp");
        String username = input.getParameter("username");
        String password = input.getParameter("password");
        String soapversion = input.getParameter("soapversion");
        Document document = XMLUtil.createDocument(queryResp);
        Element queryRespElem = document.getDocumentElement();
        InputStream inputStream = this.toInputStream(this.cleanseResponse(queryRespElem));
        IQueryResult queryResult = QueryOutputTransformer.transform((InputStream)inputStream);
        if (cmd.equalsIgnoreCase("query")) {
            IEdges[] edges;
            int n;
            IGraphElement[] ids;
            int n2;
            IEdges[] graphElements;
            output.print("[ ");
            INodes[] nodes = queryResult.getAllNodes();
            int count = 0;
            INodes[] iNodesArray = nodes;
            int n3 = nodes.length;
            int n4 = 0;
            while (n4 < n3) {
                INodes inode = iNodesArray[n4];
                IEdges[] iEdgesArray = graphElements = inode.getElements();
                n2 = graphElements.length;
                int n5 = 0;
                while (n5 < n2) {
                    IEdges graphElement = iEdgesArray[n5];
                    IGraphElement[] iGraphElementArray = ids = graphElement.getInstanceIds();
                    n = ids.length;
                    int n6 = 0;
                    while (n6 < n) {
                        IGraphElement id = iGraphElementArray[n6];
                        if (count > 0) {
                            output.print(", ");
                        }
                        ++count;
                        output.print("[ \"Node\", '" + id.getLocalId() + "' ]");
                        ++n6;
                    }
                    ++n5;
                }
                ++n4;
            }
            graphElements = edges = queryResult.getAllEdges();
            int n7 = edges.length;
            n3 = 0;
            while (n3 < n7) {
                IGraphElement[] graphElements2;
                IEdges edge = graphElements[n3];
                ids = graphElements2 = edge.getElements();
                int n8 = graphElements2.length;
                n2 = 0;
                while (n2 < n8) {
                    IInstanceId[] ids2;
                    IGraphElement graphElement = ids[n2];
                    IInstanceId[] iInstanceIdArray = ids2 = graphElement.getInstanceIds();
                    int n9 = ids2.length;
                    n = 0;
                    while (n < n9) {
                        IInstanceId id = iInstanceIdArray[n];
                        if (count > 0) {
                            output.print(", ");
                        }
                        ++count;
                        output.print("[ \"Edge\", '" + id.getLocalId() + "' ]");
                        ++n;
                    }
                    ++n2;
                }
                ++n3;
            }
            output.print("]");
        } else if (cmd.equalsIgnoreCase("register") || cmd.equalsIgnoreCase("deregister")) {
            IRegisterResponse result;
            JSONObject root;
            IEdges[] edges;
            int n;
            int n10;
            INodes[] nodes;
            String ciParm;
            boolean bRegister = cmd.equalsIgnoreCase("register");
            URI mdrId = new URI("");
            ArrayList<String> ciliststr = new ArrayList<String>();
            Integer i = 0;
            while ((ciParm = input.getParameter("localid" + i.toString())) != null) {
                ciliststr.add(ciParm);
                i = i + 1;
            }
            String[] localIdList = ciliststr.toArray(new String[ciliststr.size()]);
            IRegisterRequest registerRequest = RegisterInputArtifactFactory.getInstance().createRegisterRequest();
            IDeregisterRequest deregisterRequest = DeregisterInputArtifactFactory.getInstance().createDeregisterRequest();
            INodes[] iNodesArray = nodes = queryResult.getAllNodes();
            int n11 = nodes.length;
            int graphElement = 0;
            while (graphElement < n11) {
                IGraphElement[] graphElements;
                INodes inode = iNodesArray[graphElement];
                IGraphElement[] iGraphElementArray = graphElements = inode.getElements();
                n10 = graphElements.length;
                int id = 0;
                while (id < n10) {
                    IInstanceId[] ids;
                    IGraphElement graphElement2 = iGraphElementArray[id];
                    boolean bFound = false;
                    IInstanceId[] iInstanceIdArray = ids = graphElement2.getInstanceIds();
                    n = ids.length;
                    int n12 = 0;
                    while (n12 < n) {
                        IInstanceId id2 = iInstanceIdArray[n12];
                        String localId = CMDBfServicesUtil.toString((URI)id2.getLocalId());
                        if (this.selectedLocalId(localIdList, localId)) {
                            mdrId = id2.getMdrId();
                            bFound = true;
                        }
                        ++n12;
                    }
                    if (bFound) {
                        if (bRegister) {
                            registerRequest.addItem((IItem)graphElement2);
                        } else {
                            deregisterRequest.addItem((IItem)graphElement2);
                        }
                    }
                    ++id;
                }
                ++graphElement;
            }
            IEdges[] iEdgesArray = edges = queryResult.getAllEdges();
            int n13 = edges.length;
            n11 = 0;
            while (n11 < n13) {
                IGraphElement[] graphElements;
                IEdges edge = iEdgesArray[n11];
                IGraphElement[] iGraphElementArray = graphElements = edge.getElements();
                int n14 = graphElements.length;
                n10 = 0;
                while (n10 < n14) {
                    IInstanceId[] ids;
                    IGraphElement graphElement3 = iGraphElementArray[n10];
                    boolean bFound = false;
                    IInstanceId[] iInstanceIdArray = ids = graphElement3.getInstanceIds();
                    int n15 = ids.length;
                    n = 0;
                    while (n < n15) {
                        IInstanceId id = iInstanceIdArray[n];
                        String localId = CMDBfServicesUtil.toString((URI)id.getLocalId());
                        if (this.selectedLocalId(localIdList, localId)) {
                            mdrId = id.getMdrId();
                            bFound = true;
                        }
                        ++n;
                    }
                    if (bFound) {
                        if (bRegister) {
                            registerRequest.addRelationship((IRelationship)graphElement3);
                        } else {
                            deregisterRequest.addRelationship((IRelationship)graphElement3);
                        }
                    }
                    ++n10;
                }
                ++n11;
            }
            registerRequest.setMdrId(mdrId);
            deregisterRequest.setMdrId(mdrId);
            RegistrationServiceClient client = new RegistrationServiceClient(cmdbfepr);
            if (username != null) {
                client.setUsername(username);
            }
            if (password != null) {
                client.setPassword(password);
            }
            if (soapversion != null) {
                client.setSoapVersion(Integer.parseInt(soapversion));
            }
            if (!(root = StatusResponseOutputter.renderStatusResult(null, (IResponse)(result = bRegister ? client.register(registerRequest) : client.deregister(deregisterRequest)))).has("items")) {
                root.put("items", (Object)new JSONArray());
            }
            output.write(root.toString());
        }
    }
}

