/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.common;

/**
 * Constants for CMDBf support
 * 
 * 
 * @author David Whiteman
 */
public interface ICMDBfServicesConstants {

	/**
	 * Miscellaneous constants
	 */
	public static final String COLON = ":";
	public static final String OPEN_ANGLE_BRACKET = "<";
	public static final String FORWARD_SLASH = "/";
	public static final String BACKWARD_SLASH = "\\";
	public static final String CLOSE_ANGLE_BRACKET = ">";
	public static final String EQUAL_SIGN = "=";
	public static final String DOUBLE_QUOTE = "\"";
	public static final String nl = System.getProperty("line.separator");
	public static final String SINGLE_SPACE = " ";
	public static final String UTF_8 = "UTF-8";
	public static final String EMPTY_STRING = "";
	public static final String PERIOD = ".";
	public static final String COMMA = ",";
	public static final String AMPERSAND = "&";
	
	/**
	 * Escaped character constants
	 */
	public static final String ESCAPED_AMPERSAND = "&amp;";
	public static final String ESCAPED_LESS_THAN = "&lt;";
	public static final String ESCAPED_GREATER_THAN = "&gt;";
	
	/* SAX parsing constants */
	public static final String SAX_PARSER_FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
	public static final String SAX_PARSER_FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
	public static final String SAX_PARSER_FEATURE_VALIDATION = "http://xml.org/sax/features/validation";
	public static final String SAX_PARSER_PROPERTY_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
	public static final String SAX_PARSER_PROPERTY_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
	public static final String SCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
	public static final String CMDBF_MODEL_NAMESPACE = "http://cmdbf.org/schema/1-0-0/datamodel";
	/**
	 * Remote data model schema file accessed if local file not found
	 */
	public static final String CMDBF_DATA_MODEL_XSD_URL = "http://www.cmdbf.org/schema/1-0-0/cmdbfDatamodel.xsd";
	/**
	 * Local data model schema file
	 */
	public static final String CMDBF_DATA_MODEL_XSD_FILE = "resources/cmdbfDataModel.xsd";
//	public static final String CMDBF_DATA_MODEL_XSD_FILE = "resources/none.xsd"; // revert after checking in 1.0 xsd file
	
	/**
	 * Common element/attribute transformer constants 
	 */
	public static final String RECORD_ELEMENT = "record";
	public static final String NAMESPACE_PREFIX = "xmlns";
	public static final String RELATIONSHIP_ELEMENT = "relationship";
	public static final String ITEM_ELEMENT = "item";
	public static final String SOURCE_ELEMENT = "source";
	public static final String TARGET_ELEMENT = "target";
	public static final String INSTANCE_ID_ELEMENT = "instanceId";
	public static final String ADDITIONAL_RECORD_TYPE_ELEMENT = "additionalRecordType";
	public static final String LOCAL_NAME_ATTRIBUTE = "localName";
	public static final String NAMESPACE_ATTRIBUTE = "namespace";
	public static final String LOCAL_ID_ELEMENT = "localId";
	public static final String MDR_ID_ELEMENT = "mdrId";
	public static final String RECORD_METADATA_ELEMENT = "recordMetadata";
	public static final String RECORD_ID_ELEMENT = "recordId";
	public static final String LAST_MODIFIED_ELEMENT = "lastModified";
	public static final String BASE_LINE_ID_ELEMENT = "baselineId";
	public static final String SNAPSHOT_ID_ELEMENT = "snapshotId";
	
	/**
	 * XPath 1.0 dialect
	 */
	public static final String XPATH_1_DIALECT = "http://www.w3.org/TR/1999/REC-xpath-19991116";
	
	/**
	 * XPath 2.0 dialect
	 */
	public static final String XPATH_2_DIALECT = "http://www.w3.org/TR/1999/REC-xpath-19991116";
	
	
	/**
	 * The CMDBf prefix
	 */
	public static final String CMDBF_PREFIX_RAW = "cmdbf";
	public static final String CMDBF_PREFIX = CMDBF_PREFIX_RAW + ":";
	
	/* Options for transformers */
	public static final String SERVICES_TRANSFORM_DATAMODEL_OPTION = "services.transform.datamodel";
	public static final String SERVICES_TRANSFORM_VALIDATION_OPTION = "services.transform.validation";
	
}
