/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.repository.application;

import java.io.Serializable;

import org.eclipse.cosmos.rm.provisional.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLInstanceDocument;

/**
 * Represents a resource, which can contain zero or more facets
 * 
 * @author Ali Mehregani
 */
public interface ISMLResourceInstance extends ISMLInstanceDocument, ISMLResourceBase, Serializable
{    
	/**
	 * If this object happens to represent a reference to a resource
	 * (i.e. isReference() returns true), then this method will have it
	 * resolved to the actual resource.  If isReference() happens to
	 * return false, then the return value of this method is this
	 * object.
	 * 
	 * @return An object representing the resolved resource that 
	 * this reference points to 
	 */
	public ISMLResourceInstance resolveReference() throws RepositoryOperationException;
	
	
	/**
	 * Retrieves and returns the set of root level facets that are included
	 * as part of this resource
	 * 
	 * @return Root level facets of this resource
	 */
	public ISMLResourceFacet[] retrieveFacets() throws RepositoryOperationException;
}
