/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.dmtoolkit.common.ui;

import org.eclipse.cosmos.me.internal.dmtoolkit.common.Messages;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.artifacts.interfaces.IProjectConfig;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.util.Utilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DataManagerConfigPage
extends WizardPage {
    private IProjectConfig model = null;
    private Text packageNameTextField;
    private Text nameTextField;
    private String nameTextLabel;

    protected DataManagerConfigPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        String packageNameFieldInitialContents = this.getModel().getPackageName();
        this.packageNameTextField = Utilities.createLabelTextPair(composite, Messages.wizardPagePackageNameField, packageNameFieldInitialContents, false);
        String dataManagerNameInitialContents = this.getModel().getName();
        this.nameTextField = Utilities.createLabelTextPair(composite, this.getNameTextLabel(), dataManagerNameInitialContents, false);
        this.nameTextField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!Character.isJavaIdentifierPart(e.character)) {
                    e.doit = false;
                    return;
                }
                Text widget = (Text)e.widget;
                if (widget.getCharCount() == 0) {
                    if (!Character.isJavaIdentifierStart(e.character)) {
                        e.doit = false;
                        return;
                    }
                    e.text = e.text.toUpperCase();
                }
            }
        });
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void setModel(Object model) {
        this.model = (IProjectConfig)model;
    }

    public IProjectConfig getModel() {
        return this.model;
    }

    public void transferStateToModel() {
        this.getModel().setName(this.nameTextField.getText());
        this.getModel().setPackageName(this.packageNameTextField.getText());
    }

    public String getNameTextLabel() {
        if (this.nameTextLabel == null) {
            this.nameTextLabel = Messages.wizardPageDataManagerNameField;
        }
        return this.nameTextLabel;
    }

    public void setNameTextLabel(String nameTextLabel) {
        this.nameTextLabel = nameTextLabel;
    }
}

