/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dr.internal.web.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;



public class WebUIPreferencePage extends PreferencePage implements
		IWorkbenchPreferencePage {

	private Text port;
	private Text host;
	private Text dojoPath;
	
	public WebUIPreferencePage() {
	}

	public WebUIPreferencePage(String title) {
		super(title);
	}

	public WebUIPreferencePage(String title, ImageDescriptor image) {
		super(title, image);
	}



	/*
	 * @see PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {

		final Composite topComposite = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		GridData data = new GridData();
		data.verticalAlignment = GridData.FILL;
		data.horizontalAlignment = GridData.FILL;
		topComposite.setLayout(layout);
		topComposite.setLayoutData(data);
	    layout.numColumns = 1;
	    
	    Group group = new Group(topComposite, SWT.NULL);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		group.setLayoutData(gridData);		
	    
	    group.setText(Messages.getString("COSMOSPreferencePage.0")); //$NON-NLS-1$
	    //group.setBounds(10, 10, 300, 140);
		//Create a data that takes up the extra space in the dialog .
		layout = new GridLayout();
		group.setLayout(layout);							
	    layout.numColumns = 2;
	    
		Label label = new Label(group,SWT.NONE);
		label.setText(Messages.getString("COSMOSPreferencePage.1")); //$NON-NLS-1$

		host = new Text(group, SWT.BORDER);
		gridData = new GridData();
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalAlignment = GridData.FILL;
		host.setLayoutData(gridData);		

		label = new Label(group,SWT.NONE);
		label.setText(Messages.getString("COSMOSPreferencePage.2")); //$NON-NLS-1$

		port = new Text(group,SWT.BORDER);
		port.addListener(SWT.Verify, new Listener() {
		          public void handleEvent(Event e) {
		             String string = e.text;
		             char[] chars = new char[string.length()];
		             string.getChars(0, chars.length, chars, 0);
		             for (int i = 0; i < chars.length; i++) {
		               if (!('0' <= chars[i] && chars[i] <= '9')) {
		                 e.doit = false;
		                return;
		               }
		              }
		            }
		});		
		gridData = new GridData();
		gridData.grabExcessHorizontalSpace = true;
		gridData.widthHint = 60;
		port.setLayoutData(gridData);		
		
		final Composite dojoComposite = new Composite(topComposite, SWT.NULL);
		layout = new GridLayout();
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		dojoComposite.setLayoutData(gridData);
		dojoComposite.setLayout(layout);
		layout.numColumns = 2;
	    		
		label = new Label(dojoComposite,SWT.NONE);
		label.setText(Messages.getString("COSMOSPreferencePage.3")); //$NON-NLS-1$
		
		dojoPath = new Text(dojoComposite, SWT.BORDER);
		dojoPath.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if (!isValid()) {
					validateData();
				}
			}
		});
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		dojoPath.setLayoutData(gridData);
		label = new Label(dojoComposite, SWT.NONE);
		gridData = new GridData();

		gridData.horizontalAlignment = GridData.FILL;

		gridData.horizontalSpan = 2;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("COSMOSPreferencePage.4")); //$NON-NLS-1$
	    
		host.setText(WebViewerActivator.getDefault().getHostPreference());
		port.setText(WebViewerActivator.getDefault().getPortPreference());
		dojoPath.setText(WebViewerActivator.getDefault().getDojoPathPreference());
		Dialog.applyDialogFont(topComposite);
		return topComposite;
	}

	/*
	 * @see IWorkbenchPreferencePage#init(IWorkbench)
	 */
	public void init(IWorkbench workbench) {
		//Initialize the preference store we wish to use
		setPreferenceStore(WebViewerActivator.getDefault().getPreferenceStore());
	}

	/**
	 * Performs special processing when this page's Restore Defaults button has been pressed.
	 * Sets the field contents to default values. 
	 */
	protected void performDefaults() {		
		host.setText(WebViewerActivator.getDefault().getDefaultHostPreference());
		port.setText(WebViewerActivator.getDefault().getDefaultPortPreference());
		dojoPath.setText(WebViewerActivator.getDefault().getDefaultDojoPathPreference());
		setErrorMessage(null);
		setValid(true);
	}
	/** 
	 * Method declared on IPreferencePage. Save the
	 * values to the preference store.
	 */
	public boolean performOk() {
		validateAndUpdate();
		return isValid();
	}

	private void validateAndUpdate() {
		validateData();
		updateDefaults();
	}

	private void updateDefaults() {
		WebViewerActivator.getDefault().setHostPreference(host.getText());
		WebViewerActivator.getDefault().setPortPreference(port.getText());
		WebViewerActivator.getDefault().setDojoPathPreference(dojoPath.getText());
	}

	private void validateData() {
		if ("".equals(dojoPath.getText())) { //$NON-NLS-1$
			setErrorMessage(Messages.getString("COSMOSPreferencePage.5")); //$NON-NLS-1$
			setValid(false);
			return;
		}
		setErrorMessage(null);
		setValid(true);
	}	
}
