/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.cosmos.dr.internal.web.ui;

import java.io.File;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jst.ws.axis2.core.context.Axis2EmitterContext;
import org.eclipse.jst.ws.axis2.core.plugin.WebServiceAxis2CorePlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

/**
 * The activator class controls the plug-in life cycle
 */
public class WebViewerActivator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.eclipse.cosmos.dr.web.ui"; //$NON-NLS-1$
	public static final String HOST_PREFERENCE = "COSMOS.UI.host"; //$NON-NLS-1$
	public static final String PORT_PREFERENCE = "COSMOS.UI.port"; //$NON-NLS-1$
	public static final String DOJOPATH_PREFERENCE = "COSMOS.UI.dojopath"; //$NON-NLS-1$
	public static final String DOJOBASEPATH_PREFERENCE = "COSMOS.UI.dojopbaseath"; //$NON-NLS-1$

	// The shared instance
	private static WebViewerActivator plugin;
	protected Bundle viewerBundle;
	protected ILauncher launcher;
	protected String axis2Location = ""; //$NON-NLS-1$
	/**
	 * The constructor
	 */
	public WebViewerActivator() {
	}
	
	

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		//first intialize AXIS 2 environtment variable
		super.start(context);
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static WebViewerActivator getDefault() {
		return plugin;
	}
	public String getHostPreference(){
		return getPreferenceStore().getString(HOST_PREFERENCE);	
	}
	
	public String getPortPreference(){
		return getPreferenceStore().getString(PORT_PREFERENCE);	
	}
		
	public String getDojoPathPreference(){
		return getPreferenceStore().getString(DOJOPATH_PREFERENCE);	
	}

    public static IStatus createErrorStatus( final String msg,
            final Exception e )
	{
	return new Status( IStatus.ERROR, PLUGIN_ID, 0, msg, e );
	}	
	

	public String getDefaultHostPreference(){
		String defaultStr =  getPreferenceStore().getDefaultString(HOST_PREFERENCE);
		return defaultStr;
	}
	
	public String getDefaultPortPreference(){
		String defaultStr = getPreferenceStore().getDefaultString(PORT_PREFERENCE);	
		return defaultStr;
	}
	
	public String getDefaultDojoPathPreference(){
		String defaultStr = getPreferenceStore().getDefaultString(DOJOPATH_PREFERENCE);	
		return defaultStr;
	}

	public String getDefaultDojoBasePathPreference(){
		String defaultStr = getPreferenceStore().getDefaultString(DOJOBASEPATH_PREFERENCE);	
		return defaultStr;
	}

	public String getDojoBasePathPreference(){
		return getPreferenceStore().getString(DOJOBASEPATH_PREFERENCE);	
	}
	
	public void setHostPreference(String value){
		getPreferenceStore().putValue(HOST_PREFERENCE, value);
	}

	public void setPortPreference(String value){
		getPreferenceStore().putValue(PORT_PREFERENCE, value);
	}
	public void setDojoPathPreference(String value){
		String basePath = ""; //$NON-NLS-1$
		int dojoBaseIdx = value.indexOf("/dojo/dojo"); //$NON-NLS-1$
		if (dojoBaseIdx > 0){
			basePath = value.substring(0, dojoBaseIdx);
		}
		getPreferenceStore().putValue(DOJOPATH_PREFERENCE, value);
		getPreferenceStore().putValue(DOJOBASEPATH_PREFERENCE, basePath);
	}	

	public void launchCOSMOSUI(String name, String queryService){
		//lets see if we need to restart the viewer bundle.  We might if the axis2 location changed
		//need to set axis lib env variable for cosmos web ui plugin viewer
		Axis2EmitterContext axis2context = WebServiceAxis2CorePlugin.getDefault().getAxisEmitterContext();
		String newAxis2Location = axis2context.getAxis2RuntimeLocation();
		if ((newAxis2Location == null) || ("".equals(newAxis2Location))){ //$NON-NLS-1$
			//error axis 2 not set
	        Status status = new Status(IStatus.ERROR, PLUGIN_ID, 0,
	                Messages.getString("WebViewerActivator.8"), null); //$NON-NLS-1$

	            // Display the dialog
	            ErrorDialog.openError(Display.getCurrent().getActiveShell(),
	                Messages.getString("WebViewerActivator.9"), Messages.getString("WebViewerActivator.10"), status);			 //$NON-NLS-1$ //$NON-NLS-2$
			return;
		}
		else if (!axis2Location.equals(newAxis2Location)){
			axis2Location = newAxis2Location;
			System.setProperty("AXIS2_LIB",axis2Location+File.separator+"lib"); //$NON-NLS-1$ //$NON-NLS-2$
			//if the web viewer bundle is started 
			//we need to stop and start the Web viewer bundle 
			//so that the bundle picks up the new axis 2 lib directory
			Bundle viewPlugin = Platform.getBundle("org.eclipse.cosmos.dr.web.ui.viewer"); //$NON-NLS-1$
			try {
				// Invoke update to get the plugin class loader
				// to reinitialize and evaluate the external
				// variables in com.acme.wrapperplugin's
				// MANIFEST.MF
				viewPlugin.update();
				// and then start the plugin explicitly
				viewPlugin.start();
			}
			catch ( BundleException e ) {
				getLog( ).log( createErrorStatus(e.getLocalizedMessage(), e) );			
			}		
			
		}
		
		if (launcher != null)
			launcher.launchCOSMOSUI(name, queryService);
	}



	public void setLauncher(ILauncher launcher) {
		this.launcher = launcher;
	}


	
}
