package org.eclipse.cosmos.dc.provisional.datamanager;

import java.util.Properties;
import java.io.InputStream;
import java.io.IOException;

public class ConfigurationManager {
	private String _Id = null;
	private String _displayName = null;
	private String _description = null;
	private String _soapNamespace = null;
	private String _recordTypeNamespace = null;
	private String _securityNamespace = null;
	
	private Properties _other_properties;
	
	public ConfigurationManager() { 
		_other_properties = new Properties();
	}
	
	public void Init(InputStream in) throws IOException {
		Properties p = new Properties();
		p.load(in);
		
		_Id = p.getProperty("ID");
		_displayName = p.getProperty("DisplayName");
		_description = p.getProperty("Description");
		_soapNamespace = p.getProperty("SoapNamespace");
		_recordTypeNamespace = p.getProperty("RecordTypeNamespace");
		_securityNamespace = p.getProperty("SecurityNamespace");
		
		p.remove("ID");
		p.remove("DisplayName");
		p.remove("Description");
		p.remove("SoapNamespace");
		p.remove("RecordTypeNamespace");
		p.remove("SecurityNamespace");
		_other_properties = p;
	}
	
	public String getId() { return _Id; }
	public String getDisplayName() { return _displayName; }
	public String getDescription() { return _description; }
	public String getSoapNamespace() { return _soapNamespace; }
	public String getRecordTypeNamespace() { return _recordTypeNamespace; }
	public String getSecurityNamespace() { return _securityNamespace; }
	public Properties getOtherProperties() { return _other_properties; }
	
	public void setId(String d) { _Id = d; }
	public void setDisplayName(String d) { _displayName = d; }
	public void setDescription(String d) { _description = d; }
	public void setSoapNamespace(String d) { _soapNamespace = d; }
	public void setRecordTypeNamespace(String d) { _recordTypeNamespace = d; }
	public void setSecurityNamespace(String d) { _securityNamespace = d; }
	
}

