/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class ForeignKeyConstraintDescriptor
extends KeyConstraintDescriptor {
    ReferencedKeyConstraintDescriptor referencedConstraintDescriptor;
    UUID referencedConstraintId;
    int raDeleteRule;
    int raUpdateRule;

    protected ForeignKeyConstraintDescriptor(DataDictionary dataDictionary, TableDescriptor tableDescriptor, String string, boolean bl, boolean bl2, int[] nArray, UUID uUID, UUID uUID2, SchemaDescriptor schemaDescriptor, ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor, boolean bl3, int n, int n2) {
        super(dataDictionary, tableDescriptor, string, bl, bl2, nArray, uUID, uUID2, schemaDescriptor, bl3);
        this.referencedConstraintDescriptor = referencedKeyConstraintDescriptor;
        this.raDeleteRule = n;
        this.raUpdateRule = n2;
    }

    ForeignKeyConstraintDescriptor(DataDictionary dataDictionary, TableDescriptor tableDescriptor, String string, boolean bl, boolean bl2, int[] nArray, UUID uUID, UUID uUID2, SchemaDescriptor schemaDescriptor, UUID uUID3, boolean bl3, int n, int n2) {
        super(dataDictionary, tableDescriptor, string, bl, bl2, nArray, uUID, uUID2, schemaDescriptor, bl3);
        this.referencedConstraintId = uUID3;
        this.raDeleteRule = n;
        this.raUpdateRule = n2;
    }

    public ReferencedKeyConstraintDescriptor getReferencedConstraint() throws StandardException {
        if (this.referencedConstraintDescriptor != null) {
            return this.referencedConstraintDescriptor;
        }
        if (this.referencedConstraintId == null) {
            this.getReferencedConstraintId();
        }
        TableDescriptor tableDescriptor = this.getDataDictionary().getConstraintTableDescriptor(this.referencedConstraintId);
        ConstraintDescriptorList constraintDescriptorList = this.getDataDictionary().getConstraintDescriptors(tableDescriptor);
        this.referencedConstraintDescriptor = (ReferencedKeyConstraintDescriptor)constraintDescriptorList.getConstraintDescriptorById(this.referencedConstraintId);
        return this.referencedConstraintDescriptor;
    }

    public UUID getReferencedConstraintId() throws StandardException {
        if (this.referencedConstraintDescriptor != null) {
            return this.referencedConstraintDescriptor.getUUID();
        }
        SubKeyConstraintDescriptor subKeyConstraintDescriptor = this.getDataDictionary().getSubKeyConstraint(this.constraintId, 6);
        this.referencedConstraintId = subKeyConstraintDescriptor.getKeyConstraintId();
        return this.referencedConstraintId;
    }

    public int getConstraintType() {
        return 6;
    }

    public boolean needsToFire(int n, int[] nArray) {
        if (!this.isEnabled) {
            return false;
        }
        if (n == 4) {
            return false;
        }
        if (n == 1) {
            return true;
        }
        return ForeignKeyConstraintDescriptor.doColumnsIntersect(nArray, this.getReferencedColumns());
    }

    public boolean isSelfReferencingFK() throws StandardException {
        ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = this.getReferencedConstraint();
        return referencedKeyConstraintDescriptor.getTableId().equals(this.getTableId());
    }

    public int getRaDeleteRule() {
        return this.raDeleteRule;
    }

    public int getRaUpdateRule() {
        return this.raUpdateRule;
    }
}

