/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.eclipse.cosmos.dc.provisional.cmdbf.query.client.QueryServiceClient;
import org.eclipse.cosmos.dc.provisional.cmdbf.registration.client.RegistrationServiceClient;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.input.artifacts.DeregisterInputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.input.artifacts.IDeregisterRequest;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.QueryInputTransformer;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQuery;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.input.artifacts.IRegisterRequest;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.input.artifacts.RegisterInputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IAccepted;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IDeclined;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IInstanceResponse;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IRegisterResponse;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IResponse;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRelationship;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.IOutputterConstants;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.Messages;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusResponseOutputter
extends AbstractOutputter
implements IOutputterConstants {
    private static final String DEREGISTER = "deregister";
    private static final String CMDBF_EPR = "cmdbfEPR";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String SOAPVERSION = "soapversion";
    private static final String ACCEPTED_ITEMS = "ACCEPTED_ITEMS";
    private static final String DECLINED_ITEMS = "DECLINED_ITEMS";
    protected static final String AllQuery = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><s:query xmlns:s=\"http://cmdbf.org/schema/1-0-0/datamodel\">        <s:itemTemplate id=\"all-items\">                 </s:itemTemplate>        <s:itemTemplate id=\"items-with-relationship\">                   </s:itemTemplate>        <s:relationshipTemplate id=\"all-relationships\">          <s:sourceTemplate ref=\"items-with-relationship\"/>          <s:targetTemplate ref=\"items-with-relationship\"/>        </s:relationshipTemplate></s:query>";

    @Override
    public void render(PrintWriter output, IParameters input) throws Exception {
        Configuration configuration = new Configuration(input);
        JSONObject rootObject = new JSONObject();
        rootObject.put("identifier", (Object)"id");
        rootObject.put("label", (Object)"label");
        if (configuration.isRegister) {
            int i = 0;
            while (i < configuration.mdrEPRs.length) {
                IQueryResult graphResponse = this.submitQuery(configuration.mdrEPRs[i], AllQuery, configuration);
                this.registerDerigisterCI(graphResponse, rootObject, configuration);
                ++i;
            }
        } else {
            String cmdbfQueryService = input.getParameter("queryEPR");
            int x = 0;
            while (x < configuration.mdrEPRs.length) {
                String mdrEPR = configuration.mdrEPRs[x];
                IQueryResult graphResponse = this.submitQuery(mdrEPR, AllQuery, configuration);
                String mdrId = this.getMdrId(graphResponse);
                String ciQuery = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?><s:query xmlns:s=\"http://cmdbf.org/schema/1-0-0/datamodel\">   <s:itemTemplate id=\"items\" suppressFromResult=\"false\" >      <s:instanceIdConstraint>         <s:instanceId>         <s:mdrId>%s</s:mdrId>         <s:localId>*</s:localId>        </s:instanceId>      </s:instanceIdConstraint>   </s:itemTemplate>   <s:itemTemplate id=\"itemswithrel\" suppressFromResult=\"false\" >      <s:instanceIdConstraint>         <s:instanceId>         <s:mdrId>%s</s:mdrId>         <s:localId>*</s:localId>         </s:instanceId>      </s:instanceIdConstraint>   </s:itemTemplate>   <s:relationshipTemplate id=\"relationship\">      <s:sourceTemplate ref=\"itemswithrel\"/>      <s:targetTemplate ref=\"itemswithrel\"/>   </s:relationshipTemplate></s:query>", mdrId, mdrId, mdrId);
                IQueryResult cmdbfResponse = this.submitQuery(cmdbfQueryService, ciQuery, configuration);
                this.registerDerigisterCI(cmdbfResponse, rootObject, configuration);
                ++x;
            }
        }
        output.print(rootObject.toString());
    }

    public String getMdrId(IQueryResult queryResult) throws Exception {
        INodes[] nodes;
        URI mdrId = new URI("");
        INodes[] iNodesArray = nodes = queryResult.getAllNodes();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IGraphElement[] graphElements;
            INodes inode = iNodesArray[n2];
            IGraphElement[] iGraphElementArray = graphElements = inode.getElements();
            int n3 = graphElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IGraphElement graphElement = iGraphElementArray[n4];
                if (graphElement.getInstanceIds() != null && graphElement.getInstanceIds().length > 0) {
                    mdrId = graphElement.getInstanceIds()[0].getMdrId();
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return mdrId.toString();
    }

    public void registerDerigisterCI(IQueryResult queryResult, JSONObject rootObject, Configuration config) throws Exception {
        IEdges[] edges;
        int n;
        INodes[] nodes;
        IRegisterRequest registerRequest = RegisterInputArtifactFactory.getInstance().createRegisterRequest();
        IDeregisterRequest deregisterRequest = DeregisterInputArtifactFactory.getInstance().createDeregisterRequest();
        URI mdrId = new URI("");
        INodes[] iNodesArray = nodes = queryResult.getAllNodes();
        int n2 = nodes.length;
        int n3 = 0;
        while (n3 < n2) {
            IGraphElement[] graphElements;
            INodes inode = iNodesArray[n3];
            IGraphElement[] iGraphElementArray = graphElements = inode.getElements();
            n = graphElements.length;
            int n4 = 0;
            while (n4 < n) {
                IGraphElement graphElement = iGraphElementArray[n4];
                if (graphElement.getInstanceIds() != null && graphElement.getInstanceIds().length > 0) {
                    mdrId = graphElement.getInstanceIds()[0].getMdrId();
                }
                if (config.isRegister) {
                    registerRequest.addItem((IItem)graphElement);
                } else {
                    deregisterRequest.addItem((IItem)graphElement);
                }
                ++n4;
            }
            ++n3;
        }
        IEdges[] iEdgesArray = edges = queryResult.getAllEdges();
        int n5 = edges.length;
        n2 = 0;
        while (n2 < n5) {
            IGraphElement[] graphElements;
            IEdges edge = iEdgesArray[n2];
            IGraphElement[] iGraphElementArray = graphElements = edge.getElements();
            int n6 = graphElements.length;
            n = 0;
            while (n < n6) {
                IGraphElement graphElement = iGraphElementArray[n];
                if (graphElement.getInstanceIds() != null && graphElement.getInstanceIds().length > 0) {
                    mdrId = graphElement.getInstanceIds()[0].getMdrId();
                }
                if (config.isRegister) {
                    registerRequest.addRelationship((IRelationship)graphElement);
                } else {
                    deregisterRequest.addRelationship((IRelationship)graphElement);
                }
                ++n;
            }
            ++n2;
        }
        registerRequest.setMdrId(mdrId);
        deregisterRequest.setMdrId(mdrId);
        RegistrationServiceClient client = new RegistrationServiceClient(config.cmdbfEPR);
        if (config.username != null) {
            client.setUsername(config.username);
        }
        if (config.password != null) {
            client.setPassword(config.password);
        }
        if (config.soapVersion != null) {
            client.setSoapVersion(Integer.parseInt(config.soapVersion));
        }
        IRegisterResponse result = config.isRegister ? client.register(registerRequest) : client.deregister(deregisterRequest);
        StatusResponseOutputter.renderStatusResult(rootObject, (IResponse)result);
    }

    protected IQueryResult submitQuery(String mdrEPR, String query, Configuration config) throws Exception {
        StringReader queryReader = new StringReader(query);
        QueryServiceClient queryService = new QueryServiceClient(mdrEPR);
        if (config.username != null) {
            queryService.setUsername(config.username);
        }
        if (config.password != null) {
            queryService.setPassword(config.password);
        }
        if (config.soapVersion != null) {
            queryService.setSoapVersion(Integer.parseInt(config.soapVersion));
        }
        IQuery iquery = QueryInputTransformer.transform((Reader)queryReader);
        return queryService.graphQuery(iquery);
    }

    public static JSONObject renderStatusResult(JSONObject rootJSONObject, IResponse result) throws Exception {
        if (result == null) {
            throw new Exception(Messages.getString("RegisterError.0"));
        }
        if (rootJSONObject == null) {
            rootJSONObject = new JSONObject();
            rootJSONObject.put("identifier", (Object)"id");
            rootJSONObject.put("label", (Object)"label");
        }
        IInstanceResponse[] instanceResponse = result.getInstanceResponses();
        boolean acceptedItemsPresent = true;
        boolean declinedItemsPresent = true;
        JSONArray acceptedItems = StatusResponseOutputter.retrieveArray(rootJSONObject, ACCEPTED_ITEMS);
        JSONArray declinedItems = StatusResponseOutputter.retrieveArray(rootJSONObject, DECLINED_ITEMS);
        if (acceptedItems == null) {
            acceptedItemsPresent = false;
            acceptedItems = new JSONArray();
        }
        if (declinedItems == null) {
            declinedItemsPresent = false;
            declinedItems = new JSONArray();
        }
        Hashtable<String, Boolean> idMap = new Hashtable<String, Boolean>();
        int i = 0;
        while (i < instanceResponse.length) {
            JSONObject item = StatusResponseOutputter.createItem(idMap, instanceResponse[i]);
            if (item != null) {
                int j;
                IDeclined declined = instanceResponse[i].getDeclined();
                IAccepted accepted = instanceResponse[i].getAccepted();
                if (declined != null) {
                    String[] reasons = declined.getReasons();
                    JSONArray reasonsArray = new JSONArray();
                    j = 0;
                    while (j < reasons.length) {
                        reasonsArray.put((Object)StatusResponseOutputter.createJSONObject(new String[][]{{"id", "REASON" + j}, {"label", reasons[j]}}));
                        ++j;
                    }
                    StatusResponseOutputter.addItem(declinedItems, item, reasonsArray);
                } else if (accepted != null) {
                    IInstanceId[] alternativeInstanceIds = accepted.getAlternateInstanceIds();
                    JSONArray alternativeIdArray = new JSONArray();
                    j = 0;
                    while (j < alternativeInstanceIds.length) {
                        String mdrId = CMDBfServicesUtil.toString((URI)alternativeInstanceIds[j].getMdrId());
                        String localId = CMDBfServicesUtil.toString((URI)alternativeInstanceIds[j].getLocalId());
                        alternativeIdArray.put((Object)StatusResponseOutputter.createJSONObject(new String[][]{{"id", String.valueOf(mdrId) + localId}, {"mdrId", mdrId}, {"localId", localId}, {"label", localId}}));
                        ++j;
                    }
                    StatusResponseOutputter.addItem(acceptedItems, item, alternativeIdArray);
                }
            }
            ++i;
        }
        JSONArray rootJSONArray = new JSONArray();
        if (!acceptedItemsPresent) {
            StatusResponseOutputter.createItemStore(rootJSONArray, acceptedItems, true);
        }
        if (!declinedItemsPresent) {
            StatusResponseOutputter.createItemStore(rootJSONArray, declinedItems, false);
        }
        if (!acceptedItemsPresent || !declinedItemsPresent) {
            StatusResponseOutputter.addArrayToObject("items", rootJSONObject, rootJSONArray);
        }
        return rootJSONObject;
    }

    private static JSONArray retrieveArray(JSONObject root, String id) throws JSONException {
        if (root == null || !root.has("items")) {
            return null;
        }
        JSONArray itemsArray = root.getJSONArray("items");
        int i = 0;
        int count = itemsArray.length();
        while (i < count) {
            JSONObject jsonObject = (JSONObject)itemsArray.get(i);
            if (id.equals(jsonObject.get("id"))) {
                return jsonObject.getJSONArray("response");
            }
            ++i;
        }
        return null;
    }

    private static void createItemStore(JSONArray rootArray, JSONArray items, boolean accepted) throws JSONException {
        if (items.length() <= 0) {
            return;
        }
        String ID = accepted ? ACCEPTED_ITEMS : DECLINED_ITEMS;
        String label = accepted ? Messages.getString("AcceptedItems") : Messages.getString("DeclinedItems");
        JSONObject itemsObject = StatusResponseOutputter.createJSONObject(new String[][]{{"type", "response"}, {"id", ID}, {"label", label}});
        itemsObject.put("response", (Object)items);
        rootArray.put((Object)itemsObject);
    }

    private static void addItem(JSONArray itemsArray, JSONObject item, JSONArray innerArray) throws JSONException {
        StatusResponseOutputter.addArrayToObject("response", item, innerArray);
        itemsArray.put((Object)item);
    }

    private static void addArrayToObject(String key, JSONObject jsonObject, JSONArray jsonArray) throws JSONException {
        if (jsonArray.length() > 0) {
            jsonObject.put(key, (Object)jsonArray);
        }
    }

    private static JSONObject createItem(Map<String, Boolean> idMap, IInstanceResponse instanceResponse) throws JSONException {
        IInstanceId instanceId = null;
        if (instanceResponse == null || (instanceId = instanceResponse.getInstanceId()) == null) {
            return null;
        }
        String mdrId = CMDBfServicesUtil.toString((URI)instanceId.getMdrId());
        String localId = CMDBfServicesUtil.toString((URI)instanceId.getLocalId());
        String id = String.valueOf(mdrId) + localId;
        if (idMap.get(id) != null) {
            int counter = 0;
            while (idMap.get(String.valueOf(id) + counter) != null) {
                ++counter;
            }
            id = String.valueOf(id) + counter;
        }
        idMap.put(id, Boolean.TRUE);
        return StatusResponseOutputter.createJSONObject(new String[][]{{"id", id}, {"mdrId", mdrId}, {"localId", localId}, {"label", CMDBfServicesUtil.toString((URI)instanceId.getLocalId())}});
    }

    private static JSONObject createJSONObject(String[][] pairs) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        int i = 0;
        while (i < pairs.length) {
            jsonObject.put(pairs[i][0], (Object)pairs[i][1]);
            ++i;
        }
        return jsonObject;
    }

    private static class Configuration {
        private String username;
        private String password;
        private String soapVersion;
        private String cmdbfEPR;
        private boolean isRegister;
        private String[] mdrEPRs;

        public Configuration(IParameters input) {
            String mdrParm;
            this.username = input.getParameter(StatusResponseOutputter.USERNAME);
            this.password = input.getParameter(StatusResponseOutputter.PASSWORD);
            this.soapVersion = input.getParameter(StatusResponseOutputter.SOAPVERSION);
            this.cmdbfEPR = input.getParameter(StatusResponseOutputter.CMDBF_EPR);
            this.isRegister = input.getParameter(StatusResponseOutputter.DEREGISTER) == null;
            ArrayList<String> mdrEPRList = new ArrayList<String>();
            Integer i = 0;
            while ((mdrParm = input.getParameter("mdrEPR" + i.toString())) != null) {
                mdrEPRList.add(mdrParm);
                i = i + 1;
            }
            this.mdrEPRs = mdrEPRList.toArray(new String[mdrEPRList.size()]);
        }
    }
}

