/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.QueryOutputTransformer;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IQueryServiceElementCollection;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IAdditionalRecordType;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRecordMetadata;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRelationship;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.AbstractGraphResponse;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

public class GraphResponseTreeOutputter
extends AbstractGraphResponse {
    public void render(PrintWriter output, IParameters input) throws Exception {
        String queryResponse = input.getParameter("queryResponse");
        String historyId = input.getParameter("historyId");
        String uuid = input.getParameter("uuid");
        if (historyId != null) {
            queryResponse = super.loadFromHistory(uuid, historyId);
        }
        if (queryResponse != null) {
            IQueryResult queryResult = QueryOutputTransformer.transform((InputStream)new ByteArrayInputStream(queryResponse.getBytes()));
            this.writeLogicalJSON(output, queryResult);
        }
    }

    private void writeLogicalJSON(PrintWriter output, IQueryResult response) {
        try {
            JSONObject main = new JSONObject();
            main.put("label", (Object)"label");
            JSONArray elementsArray = new JSONArray();
            this.convertTemplates(elementsArray, response, response.getNodesIds(), true);
            this.convertTemplates(elementsArray, response, response.getEdgesIds(), false);
            main.put("items", (Object)elementsArray);
            output.println(main.toString());
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    private void convertTemplates(JSONArray store, IQueryResult response, String[] templateIds, boolean isItem) throws JSONException {
        String type = isItem ? "itemTemplate" : "relationshipTemplate";
        int i = 0;
        while (i < templateIds.length) {
            JSONObject templateObject = new JSONObject();
            templateObject.put("type", (Object)type);
            templateObject.put("label", (Object)templateIds[i]);
            templateObject.put("elements", (Object)this.convertElements((IQueryServiceElementCollection)(isItem ? response.getNodes(templateIds[i]) : response.getEdges(templateIds[i])), isItem));
            store.put((Object)templateObject);
            ++i;
        }
    }

    private JSONArray convertElements(IQueryServiceElementCollection elementCollection, boolean isItem) throws JSONException {
        JSONArray elementsArray = new JSONArray();
        IGraphElement[] elements = elementCollection.getElements();
        String type = isItem ? "item" : "relationship";
        int i = 0;
        while (i < elements.length) {
            JSONObject elementObject = new JSONObject();
            elementObject.put("type", (Object)type);
            elementObject.put("label", (Object)this.getFirstInstanceId(elements[i].getInstanceIds()));
            if (!isItem) {
                IRelationship relationship = (IRelationship)elements[i];
                this.addJSONEntries(elementObject, new String[][]{{"source", this.getFirstInstanceId(new IInstanceId[]{relationship.getSourceId()})}, {"target", this.getFirstInstanceId(new IInstanceId[]{relationship.getTargetId()})}});
            }
            elementObject.put("instanceId", (Object)this.convertInstanceIds(elements[i]));
            elementObject.put("additionalRecords", (Object)this.convertAdditionalRecords(elements[i]));
            elementObject.put("records", (Object)this.convertRecords(elements[i]));
            elementsArray.put((Object)elementObject);
            ++i;
        }
        return elementsArray;
    }

    private JSONArray convertInstanceIds(IGraphElement graphElement) throws JSONException {
        IInstanceId[] instanceIds = graphElement.getInstanceIds();
        JSONArray instanceIdArray = new JSONArray();
        int i = 0;
        while (i < instanceIds.length) {
            JSONObject instanceIdObject = new JSONObject();
            instanceIdObject.put("mdrId", (Object)CMDBfServicesUtil.toString((URI)instanceIds[i].getMdrId()));
            instanceIdObject.put("localId", (Object)CMDBfServicesUtil.toString((URI)instanceIds[i].getLocalId()));
            instanceIdArray.put((Object)instanceIdObject);
            ++i;
        }
        return instanceIdArray;
    }

    private JSONArray convertAdditionalRecords(IGraphElement graphElement) throws JSONException {
        IAdditionalRecordType[] additionalRecords = graphElement.getAdditionalRecordTypes();
        JSONArray additionalRecordsArray = new JSONArray();
        int i = 0;
        while (i < additionalRecords.length) {
            JSONObject additionalRecordsObject = new JSONObject();
            additionalRecordsObject.put("namespace", (Object)CMDBfServicesUtil.toString((URI)additionalRecords[i].getNamespace()));
            additionalRecordsObject.put("localName", (Object)additionalRecords[i].getLocalName());
            additionalRecordsArray.put((Object)additionalRecordsObject);
            ++i;
        }
        return additionalRecordsArray;
    }

    private JSONArray convertRecords(IGraphElement graphElement) throws JSONException {
        IRecord[] records = graphElement.getRecords();
        JSONArray recordsArray = new JSONArray();
        int i = 0;
        while (i < records.length) {
            IRecordMetadata recordMetaData = records[i].getRecordMetadata();
            JSONObject recordsObject = new JSONObject();
            StringWriter sw = new StringWriter();
            records[i].getValue().toXML(sw, 0);
            String value = sw.getBuffer().toString();
            this.addJSONEntries(recordsObject, new String[][]{{"type", "record"}, {"label", CMDBfServicesUtil.toString((URI)recordMetaData.getRecordId())}, {"lastModified", recordMetaData.getLastModified()}, {"snapId", recordMetaData.getSnapshotId()}, {"baseId", recordMetaData.getBaselineId()}, {"value", value}});
            recordsArray.put((Object)recordsObject);
            ++i;
        }
        return recordsArray;
    }

    private String getFirstInstanceId(IInstanceId[] instanceIds) {
        String localId = null;
        return instanceIds.length > 0 && instanceIds[0] != null && (localId = CMDBfServicesUtil.toString((URI)instanceIds[0].getLocalId())) != null && localId.length() > 0 ? localId : "unknown";
    }

    private void addJSONEntries(JSONObject jsonObject, String[][] values) throws JSONException {
        int i = 0;
        while (i < values.length) {
            if (values[i][1] != null && values[i][1].length() > 0) {
                jsonObject.put(values[i][0], (Object)values[i][1]);
            }
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        GraphResponseTreeOutputter outputter = new GraphResponseTreeOutputter();
        IQueryResult result = QueryOutputTransformer.transform((InputStream)outputter.getClass().getClassLoader().getResourceAsStream("Staff02Students.xml"));
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        outputter.writeLogicalJSON(pw, result);
        System.out.println(sw.getBuffer());
    }
}

