/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.smlif.editor;

import org.eclipse.cosmos.rm.internal.smlif.editor.XMLLineStyler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextEditor;

public class SMLIFTextPage
extends TextEditor {
    private FindReplaceTarget findReplaceTarget;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ISourceViewer sourceViewer = super.getSourceViewer();
        final StyledText styledText = sourceViewer.getTextWidget();
        styledText.addLineStyleListener((LineStyleListener)new XMLLineStyler());
        styledText.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent event) {
                styledText.redraw();
            }
        });
        sourceViewer.setEditable(true);
        this.getSite().setSelectionProvider(null);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IFindReplaceTarget.class) {
            if (this.findReplaceTarget == null && this.getSourceViewer() != null) {
                this.findReplaceTarget = new FindReplaceTarget(this.getSourceViewer().getTextWidget());
            }
            return this.findReplaceTarget;
        }
        return super.getAdapter(adapter);
    }

    public boolean isEditable() {
        this.getSourceViewer().setEditable(!this.getSourceViewer().isEditable());
        return this.getSourceViewer().isEditable();
    }

    public void activated() {
        this.getSourceViewer().setEditable(true);
    }

    public void deactivated() {
        this.getSourceViewer().setEditable(false);
    }

    public IDocument getDocument() {
        return this.getSourceViewer().getDocument();
    }

    public static class FindReplaceTarget
    implements IFindReplaceTarget {
        private StyledText input;

        public FindReplaceTarget(StyledText input) {
            this.input = input;
        }

        public boolean canPerformFind() {
            return this.input != null;
        }

        public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
            String macro = this.input.getText();
            macro = widgetOffset < 0 ? macro.substring(0) : (searchForward ? macro.substring(widgetOffset) : macro.substring(0, widgetOffset));
            char[] findStringChar = findString.toCharArray();
            int firstCharacterInx = -1;
            if (searchForward) {
                int i = 0;
                int macroLength = macro.length();
                while (i < macroLength) {
                    char currentCharacter = macro.charAt(i);
                    firstCharacterInx = this.findFirstCharInx(currentCharacter, i, macro, findStringChar, searchForward, caseSensitive, wholeWord);
                    if ((firstCharacterInx = this.findSuccessiveCharacters(firstCharacterInx, findStringChar, macroLength, macro, i, 0, currentCharacter, searchForward, caseSensitive)) != -1) {
                        widgetOffset = widgetOffset < 0 ? 0 : widgetOffset;
                        this.input.setSelection(i + widgetOffset, i + findStringChar.length + widgetOffset);
                        return i;
                    }
                    ++i;
                }
            } else {
                int k = macro.length() - 1;
                int macroLength = macro.length();
                while (k > 0) {
                    char currentCharacter = macro.charAt(k);
                    int lastChar = findStringChar.length - 1;
                    firstCharacterInx = this.findFirstCharInx(currentCharacter, k, macro, findStringChar, searchForward, caseSensitive, wholeWord);
                    if ((firstCharacterInx = this.findSuccessiveCharacters(firstCharacterInx, findStringChar, macroLength, macro, k, lastChar, currentCharacter, searchForward, caseSensitive)) != -1) {
                        this.input.setSelection(++k, k - findStringChar.length);
                        return k;
                    }
                    --k;
                }
            }
            return -1;
        }

        private int findSuccessiveCharacters(int firstCharacterInx, char[] findStringChar, int macroLength, String macro, int macroInx, int lastChar, char currentCharacter, boolean searchForward, boolean caseSensitive) {
            int j = 1;
            while (firstCharacterInx != -1 && j < findStringChar.length) {
                if ((searchForward ? macroInx + j : macroInx - j) >= macroLength) {
                    firstCharacterInx = -1;
                    break;
                }
                currentCharacter = macro.charAt(searchForward ? macroInx + j : macroInx - j);
                if (currentCharacter != findStringChar[searchForward ? j : lastChar - j] && (caseSensitive || (currentCharacter <= 'Z' ? currentCharacter + 32 != findStringChar[searchForward ? j : lastChar - j] : currentCharacter - 32 != findStringChar[searchForward ? j : lastChar - j]))) {
                    firstCharacterInx = -1;
                    break;
                }
                ++j;
            }
            return firstCharacterInx;
        }

        private int findFirstCharInx(char currentCharacter, int i, String macro, char[] findStringChar, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
            if ((currentCharacter == findStringChar[searchForward ? 0 : findStringChar.length - 1] || !caseSensitive && (currentCharacter <= 'Z' ? currentCharacter + 32 == findStringChar[0] : currentCharacter - 32 == findStringChar[0])) && (!wholeWord || macro.charAt(i - 1) == ' ' && macro.charAt(i + findStringChar.length) == ' ')) {
                return i;
            }
            return -1;
        }

        public Point getSelection() {
            Point selection = this.input.getSelection();
            return new Point(selection.x, selection.y - selection.x);
        }

        public String getSelectionText() {
            Point selection = this.getSelection();
            return this.input.getText().substring(selection.x, selection.x + selection.y);
        }

        public boolean isEditable() {
            return true;
        }

        public void replaceSelection(String text) {
            if (this.input == null) {
                return;
            }
            Point selection = this.input.getSelection();
            this.input.replaceTextRange(selection.x, selection.y - selection.x, text);
        }
    }
}

