/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.smlvalidators;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunctionException;
import org.apache.xerces.dom.PSVIElementNSImpl;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ConstraintNode;
import org.eclipse.cosmos.rm.internal.validation.artifacts.DOMStructure;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementLocation;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementTypeMap;
import org.eclipse.cosmos.rm.internal.validation.artifacts.EmbeddedTargetElementNode;
import org.eclipse.cosmos.rm.internal.validation.artifacts.TargetElementNode;
import org.eclipse.cosmos.rm.internal.validation.artifacts.TypeDeclarationCollection;
import org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.core.AbstractSMLValidator;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.internal.validation.databuilders.DocumentDOMBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.ElementDeclarationBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.TargetInstanceBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.TypeDeclarationBuilder;
import org.eclipse.cosmos.rm.internal.validation.reference.DerefXPathFunction;
import org.eclipse.cosmos.rm.internal.validation.reference.URIReference;
import org.eclipse.cosmos.rm.internal.validation.util.ParserHelper;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetValidator
extends AbstractSMLValidator {
    private Map<String, ConstraintNode> targetSchemaBuilderStructure;
    private Map<TargetElementNode, String> targetInstanceBuilderStructure;
    private DOMStructure documentDOMBuilderElems;
    private Map<String, Map<String, String>> substitutionElementElems;
    private ElementTypeMap elementTypeMapBuilderStructure;
    private TypeDeclarationBuilder typeDeclarationBuilder;
    private IValidationOutput<String, Object> validationLogger;

    @Override
    public void initialize(Map<String, Object> validationAttribute) {
        super.initialize(validationAttribute);
        DataBuilderRegistry builderRegistry = DataBuilderRegistry.getInstanceLevelRegistry();
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.TargetInstanceBuilder", new TargetInstanceBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.DocumentDOMBuilder", new DocumentDOMBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.TypeDeclarationBuilder", new TypeDeclarationBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementDeclarationBuilder", new ElementDeclarationBuilder());
    }

    @Override
    public boolean validate() {
        this.setTaskName(SMLValidationMessages.validationTarget);
        this.validationLogger = this.getValidationOutput();
        this.documentDOMBuilderElems = (DOMStructure)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.DocumentDOMBuilder");
        TargetInstanceBuilder targetInstanceBuilder = (TargetInstanceBuilder)DataBuilderRegistry.getInstanceLevelRegistry().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.TargetInstanceBuilder");
        this.targetInstanceBuilderStructure = targetInstanceBuilder.getDataStructure();
        this.targetSchemaBuilderStructure = targetInstanceBuilder.getTargetSchemaBuilderStructure();
        this.substitutionElementElems = targetInstanceBuilder.getSubstitutionGroupStructure();
        this.elementTypeMapBuilderStructure = targetInstanceBuilder.getElementTypeMap();
        this.typeDeclarationBuilder = (TypeDeclarationBuilder)DataBuilderRegistry.getInstanceLevelRegistry().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.TypeDeclarationBuilder");
        if (!this.isSyntaxValid() && this.shouldAbortOnError()) {
            return false;
        }
        return this.validateValues() && this.validateTargetInstance();
    }

    private boolean validateValues() {
        for (String elementName : this.targetSchemaBuilderStructure.keySet()) {
            ConstraintNode schemaNode = this.targetSchemaBuilderStructure.get(elementName);
            QName targetElement = schemaNode.getTargetElement();
            if (targetElement != null && this.elementTypeMapBuilderStructure.getType(targetElement.getNamespaceURI(), targetElement.getLocalPart()) == null) {
                ElementLocation location = schemaNode.getLocation();
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(location.getFilePath(), location.getLineNumber(), NLS.bind((String)SMLValidationMessages.targetElementInvalidValue, (Object)(String.valueOf(targetElement.getPrefix()) + ":" + targetElement.getLocalPart()))));
                return false;
            }
            QName targetType = schemaNode.getTargetType();
            TypeDeclarationCollection typeCollection = this.typeDeclarationBuilder.getDataStructure();
            if (targetType == null || typeCollection.get(targetType) != null) continue;
            ElementLocation location = schemaNode.getLocation();
            this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(location.getFilePath(), location.getLineNumber(), NLS.bind((String)SMLValidationMessages.targetTypeInvalidValue, (Object)(String.valueOf(targetType.getPrefix()) + ":" + targetType.getLocalPart()))));
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean validateTargetInstance() {
        iter = this.targetInstanceBuilderStructure.keySet().iterator();
        if (this.typeDeclarationBuilder.isStructureValid()) ** GOTO lbl17
        this.validationLogger.reportMessage(this.typeDeclarationBuilder.getErrorMessage());
        return false;
lbl-1000:
        // 1 sources

        {
            targetElementNode = iter.next();
            targetSchemaNode = this.targetSchemaBuilderStructure.get(targetElementNode.getName());
            if (targetSchemaNode == null && (subGroupMap = this.substitutionElementElems.get(targetElementNode.getUri())) != null && (subGroup = subGroupMap.get(targetElementNode.getName())) != null) {
                targetSchemaNode = this.targetSchemaBuilderStructure.get(ParserHelper.removeNameSpace(subGroup));
            }
            if (targetSchemaNode.getTargetRequired() && !TargetValidator.isURIValid(targetElementNode)) {
                errorParams = new String[]{targetElementNode.getName(), String.valueOf(targetElementNode.getLocation().getLineNumber()), String.valueOf(targetElementNode.getLocation().getColumnNumber())};
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(targetElementNode.getLocation().getFilePath(), targetElementNode.getLocation().getLineNumber(), NLS.bind((String)SMLValidationMessages.unresolvedTargetURI, (Object[])errorParams)));
                return false;
            }
            if (targetSchemaNode.getTargetElement() != null && !this.validateTargetElement(targetElementNode, targetSchemaNode)) {
                return false;
            }
            if (targetSchemaNode.getTargetType() == null || this.validateTargetType(targetElementNode, targetSchemaNode)) continue;
            return false;
lbl17:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl18:
        // 1 sources

        return true;
    }

    protected boolean validateTargetType(TargetElementNode targetElementNode, ConstraintNode targetSchemaNode) {
        boolean valid;
        String targetElementUri;
        String targetElementNamespace = targetElementNode.getUri();
        try {
            targetElementUri = this.determineTargetElementURI(targetElementNode);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
        String getTargetType = this.elementTypeMapBuilderStructure.getType(targetElementNode.getUri(), targetElementUri);
        String targetSchemaNodeTypeName = this.qNameToString(targetSchemaNode.getTargetType());
        if (getTargetType != null) {
            if (this.compareElementInstance(targetSchemaNodeTypeName, getTargetType)) {
                return true;
            }
            if (this.checkInheritanceTree(targetSchemaNodeTypeName, targetElementUri)) {
                return true;
            }
        }
        String targetTypeUri = null;
        Node alias = this.documentDOMBuilderElems.get(targetElementUri);
        if (alias != null) {
            targetTypeUri = alias.getNodeName();
            targetElementNamespace = alias.getNamespaceURI();
        }
        if (targetTypeUri != null) {
            getTargetType = this.elementTypeMapBuilderStructure.getType(targetElementNamespace, targetTypeUri);
        }
        if (getTargetType != null) {
            if (this.compareElementInstance(getTargetType, targetSchemaNodeTypeName)) {
                return true;
            }
            if (this.checkInheritanceTree(targetSchemaNodeTypeName, targetElementUri)) {
                return true;
            }
        }
        if ((valid = false) || alias == null) {
            return true;
        }
        Object[] errorParams = new String[]{targetElementNode.getName(), targetElementNode.getLocation().getLineNumber() < 0 ? SMLValidationMessages.commonUnknown : String.valueOf(targetElementNode.getLocation().getLineNumber()), targetElementNode.getLocation().getColumnNumber() < 0 ? SMLValidationMessages.commonUnknown : String.valueOf(targetElementNode.getLocation().getColumnNumber()), targetElementUri, targetSchemaNodeTypeName};
        this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(targetElementNode.getLocation().getFilePath(), targetElementNode.getLocation().getLineNumber(), NLS.bind((String)SMLValidationMessages.targetTypeInvalid, (Object[])errorParams)));
        return false;
    }

    private boolean checkInheritanceTree(String targetSchemaNodeTypeName, String targetElementUri) {
        boolean valid = false;
        PSVIElementNSImpl psviElementNode = (PSVIElementNSImpl)this.documentDOMBuilderElems.get(targetElementUri);
        XSTypeDefinition type = psviElementNode.getTypeDefinition();
        while (type instanceof XSComplexTypeDefinition && ((XSComplexTypeDefinition)type).getContentType() == 2) {
            if (this.compareElementInstance(type.getName(), targetSchemaNodeTypeName)) {
                valid = true;
                break;
            }
            type = type.getBaseType();
        }
        return valid;
    }

    protected boolean validateTargetElement(TargetElementNode targetElementNode, ConstraintNode targetSchemaNode) {
        String targetElementUri;
        String targetElementNamespace = targetElementNode.getUri();
        try {
            targetElementUri = this.determineTargetElementURI(targetElementNode);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
        if (this.compareElementInstance(this.qNameToString(targetSchemaNode.getTargetElement()), targetElementUri)) {
            return true;
        }
        Node alias = this.documentDOMBuilderElems.get(targetElementUri);
        if (alias != null) {
            targetElementUri = alias.getNodeName();
            targetElementNamespace = alias.getNamespaceURI();
        }
        if (this.compareElementInstance(targetElementUri, this.qNameToString(targetSchemaNode.getTargetElement()))) {
            return true;
        }
        Map<String, String> substitutionGroupMap = this.substitutionElementElems.get(targetElementNamespace);
        boolean valid = false;
        if (substitutionGroupMap != null) {
            String substitutionGroup = substitutionGroupMap.get(targetElementUri);
            while (substitutionGroup != null) {
                if (this.compareElementInstance(substitutionGroup, this.qNameToString(targetSchemaNode.getTargetElement()))) {
                    valid = true;
                    break;
                }
                substitutionGroup = ParserHelper.removeNameSpace(substitutionGroup);
                substitutionGroup = substitutionGroupMap.get(substitutionGroup);
            }
        }
        if (valid || alias == null) {
            return true;
        }
        Object[] errorParams = new String[5];
        errorParams[0] = targetElementNode.getName();
        errorParams[1] = targetElementNode.getLocation().getLineNumber() < 0 ? SMLValidationMessages.commonUnknown : String.valueOf(targetElementNode.getLocation().getLineNumber());
        errorParams[2] = targetElementNode.getLocation().getColumnNumber() < 0 ? SMLValidationMessages.commonUnknown : String.valueOf(targetElementNode.getLocation().getColumnNumber());
        errorParams[3] = targetElementUri;
        QName targetElement = targetSchemaNode.getTargetElement();
        String prefix = targetElement.getPrefix();
        errorParams[4] = prefix != null && prefix.length() > 0 ? String.valueOf(prefix) + ":" + targetElement.getLocalPart() : targetElement.getLocalPart();
        this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(targetElementNode.getLocation().getFilePath(), targetElementNode.getLocation().getLineNumber(), NLS.bind((String)SMLValidationMessages.invalidTargetInstance, (Object[])errorParams)));
        return false;
    }

    private String determineTargetElementURI(TargetElementNode targetElementNode) throws URISyntaxException {
        String targetElementUri = targetElementNode.getTargetURI();
        try {
            Node contextNode = SMLValidatorUtil.locateDocumentNode(targetElementNode.getAliases(), targetElementNode.getDocumentPosition());
            URIReference targetURI = new URIReference(contextNode, targetElementUri);
            if (contextNode.getBaseURI() != null) {
                targetURI.setBase(new URI(contextNode.getBaseURI()));
            }
            targetElementUri = targetURI.getDocumentReference();
        }
        catch (URISyntaxException exception) {
            this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(targetElementNode.getLocation().getFilePath(), targetElementNode.getLocation().getLineNumber(), exception.getLocalizedMessage()));
            throw exception;
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return targetElementUri;
    }

    private String qNameToString(QName qName) {
        String prefix = qName.getPrefix();
        return prefix == null || prefix.length() <= 0 ? qName.getLocalPart() : String.valueOf(prefix) + ":" + qName.getLocalPart();
    }

    private boolean isSyntaxValid() {
        XSModel xsModel = (XSModel)this.getAttributes().get("xs.model");
        if (xsModel == null) {
            return true;
        }
        XSNamedMap typeDefinitions = xsModel.getComponents((short)3);
        boolean shouldAbortOnError = this.shouldAbortOnError();
        boolean status = true;
        int i = 0;
        int definitionCount = typeDefinitions.getLength();
        while (i < definitionCount) {
            XSTypeDefinition typeDefinition = (XSTypeDefinition)typeDefinitions.item(i);
            this.checkForBadDeclaration(SMLValidatorUtil.retrieveAnnotation(typeDefinition, "http://www.w3.org/2008/09/sml", "targetElement", false));
            this.checkForBadDeclaration(SMLValidatorUtil.retrieveAnnotation(typeDefinition, "http://www.w3.org/2008/09/sml", "targetRequired", false));
            this.checkForBadDeclaration(SMLValidatorUtil.retrieveAnnotation(typeDefinition, "http://www.w3.org/2008/09/sml", "targetType", false));
            ++i;
        }
        XSNamedMap elementDeclarations = xsModel.getComponents((short)2);
        int i2 = 0;
        int declarationCount = elementDeclarations.getLength();
        while (i2 < declarationCount && (!shouldAbortOnError || status)) {
            XSElementDeclaration elementDeclarationToCheck = (XSElementDeclaration)elementDeclarations.item(i2);
            AbstractDataBuilder.AnnotationResult targetElementAnnotationResult = SMLValidatorUtil.retrieveAnnotation(elementDeclarationToCheck, "http://www.w3.org/2008/09/sml", "targetElement");
            AbstractDataBuilder.AnnotationResult targetTypeAnnotationResult = SMLValidatorUtil.retrieveAnnotation(elementDeclarationToCheck, "http://www.w3.org/2008/09/sml", "targetType");
            status = this.checkForInvalidTargetElementValue(elementDeclarations, elementDeclarationToCheck, targetElementAnnotationResult);
            if (!shouldAbortOnError || status) {
                status = status && this.checkForInvalidTargetType(typeDefinitions, elementDeclarations, elementDeclarationToCheck, targetTypeAnnotationResult);
            }
            ++i2;
        }
        if (!shouldAbortOnError || status) {
            status = status && this.checkForInvalidDerivations();
        }
        return status;
    }

    private boolean checkForInvalidTargetType(XSNamedMap allTypeDefs, XSNamedMap globalElementDeclarations, XSElementDeclaration elementDeclarationWithTargetType, AbstractDataBuilder.AnnotationResult result) throws DOMException {
        Node[] nodes;
        boolean status = true;
        if (result != null && (nodes = result.getNodes()).length > 0) {
            String targetTypeValue = nodes[0].getNodeValue();
            boolean found = false;
            XSTypeDefinition typeDef = null;
            int j = 0;
            int typeDefinitionCount = allTypeDefs.getLength();
            while (j < typeDefinitionCount && !found) {
                typeDef = (XSTypeDefinition)allTypeDefs.item(j);
                found = this.compareElementInstance(typeDef.getName(), targetTypeValue);
                if (found) break;
                ++j;
            }
            if (!found) {
                this.getValidationOutput().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)SMLValidationMessages.targetTypeInvalidValue, (Object)targetTypeValue)));
                if (this.shouldAbortOnError()) {
                    return false;
                }
            }
        }
        return status;
    }

    @Override
    protected boolean handleNewElement(XSElementDeclaration elementDeclaration, XSComplexTypeDefinition typeDefinition) {
        String qName = SMLValidatorUtil.createQualifiedName(elementDeclaration);
        String currentElementTargetTypeUri = this.retrieveAnnotationValue(elementDeclaration, "http://www.w3.org/2008/09/sml", "targetType");
        String currentElementTargetElementUri = this.retrieveAnnotationValue(elementDeclaration, "http://www.w3.org/2008/09/sml", "targetElement");
        String currentElementTargetRequired = this.retrieveAnnotationValue(elementDeclaration, "http://www.w3.org/2008/09/sml", "targetRequired");
        if (currentElementTargetTypeUri != null || currentElementTargetElementUri != null) {
            byte targetTypeOrElement = currentElementTargetTypeUri != null ? (byte)17 : 1;
            String targetUri = currentElementTargetTypeUri != null ? currentElementTargetTypeUri : currentElementTargetElementUri;
            EmbeddedTargetElementNode embeddedTargetElementNode = new EmbeddedTargetElementNode(elementDeclaration, typeDefinition, targetUri, targetTypeOrElement);
            if (currentElementTargetRequired != null) {
                embeddedTargetElementNode.setRequired(SMLValidatorUtil.isTrue(currentElementTargetRequired));
            }
            this.getConstraintMap().put(qName, embeddedTargetElementNode);
        }
        return true;
    }

    @Override
    protected boolean handleDiscoveredElement(XSElementDeclaration elementDeclaration, XSComplexTypeDefinition typeDefinition, Object discoveredElement) {
        String targetUri;
        EmbeddedTargetElementNode embeddedTargetElementNode = (EmbeddedTargetElementNode)discoveredElement;
        String currentElementTargetTypeUri = this.retrieveAnnotationValue(elementDeclaration, "http://www.w3.org/2008/09/sml", "targetType");
        String currentElementTargetElementUri = this.retrieveAnnotationValue(elementDeclaration, "http://www.w3.org/2008/09/sml", "targetElement");
        String string = targetUri = currentElementTargetTypeUri != null ? currentElementTargetTypeUri : currentElementTargetElementUri;
        if (currentElementTargetTypeUri != null && !this.checkForSameHierarchy(typeDefinition, embeddedTargetElementNode.getEnclosingType())) {
            return true;
        }
        if (targetUri != null) {
            String errorMessage = SMLValidationMessages.targetBadDerivation;
            if (typeDefinition == embeddedTargetElementNode.getEnclosingType()) {
                errorMessage = SMLValidationMessages.targetInconsistentDeclarations;
            }
            if (!targetUri.equals(embeddedTargetElementNode.getTargetURI())) {
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)errorMessage, (Object)typeDefinition.getName())));
                return false;
            }
            String currentElementTargetRequired = this.retrieveAnnotationValue(elementDeclaration, "http://www.w3.org/2008/09/sml", "targetRequired");
            if (currentElementTargetRequired != null && SMLValidatorUtil.isTrue(currentElementTargetRequired) != embeddedTargetElementNode.isRequired()) {
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)errorMessage, (Object)typeDefinition.getName())));
                return false;
            }
        }
        return true;
    }

    protected String retrieveAnnotationValue(XSElementDeclaration declaration, String namespaceUri, String attributeName) {
        String result = null;
        AbstractDataBuilder.AnnotationResult annotation = SMLValidatorUtil.retrieveAnnotation(declaration, namespaceUri, attributeName);
        if (annotation != null && annotation.getNodes().length > 0) {
            return annotation.getNodes()[0].getNodeValue();
        }
        return result;
    }

    private boolean checkForSameHierarchy(XSComplexTypeDefinition parentComplexTypeForCurrentElement, XSComplexTypeDefinition enclosingType) {
        return parentComplexTypeForCurrentElement.derivedFromType((XSTypeDefinition)enclosingType, (short)1) || enclosingType.derivedFromType((XSTypeDefinition)parentComplexTypeForCurrentElement, (short)1);
    }

    private void checkForBadDeclaration(AbstractDataBuilder.AnnotationResult annotationResult) {
        if (annotationResult != null) {
            this.getValidationOutput().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createWarningMessage(-1, SMLValidationMessages.targetBadDeclaration));
        }
    }

    protected boolean compareElementInstance(String elem1, String elem2) {
        return ParserHelper.removeNameSpace(elem1).equals(ParserHelper.removeNameSpace(elem2));
    }

    private boolean checkForInvalidTargetElementValue(XSNamedMap elementDeclarations, XSElementDeclaration elementDeclaration, AbstractDataBuilder.AnnotationResult result) throws DOMException {
        Node[] nodes;
        boolean status = true;
        if (result != null && (nodes = result.getNodes()).length > 0) {
            String targetElementValue = nodes[0].getNodeValue();
            boolean found = false;
            int j = 0;
            int declarationCount2 = elementDeclarations.getLength();
            while (j < declarationCount2 && !found) {
                XSElementDeclaration elemDec2 = (XSElementDeclaration)elementDeclarations.item(j);
                if (elemDec2 != elementDeclaration) {
                    found = this.compareElementInstance(elemDec2.getName(), targetElementValue);
                }
                ++j;
            }
            if (!found) {
                this.getValidationOutput().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)SMLValidationMessages.targetElementInvalidValue, (Object)targetElementValue)));
                status = false;
            }
        }
        return status;
    }

    protected static boolean isURIValid(TargetElementNode targetElementNode) {
        String uri;
        block3: {
            try {
                uri = targetElementNode.getTargetURI();
                if (uri != null && !"".equals(uri.trim())) break block3;
                return false;
            }
            catch (XPathFunctionException xPathFunctionException) {
                return false;
            }
        }
        Node context = SMLValidatorUtil.locateDocumentNode(targetElementNode.getAliases(), targetElementNode.getDocumentPosition());
        return DerefXPathFunction.instance().evaluate(context, SMLValidatorUtil.removeLineBreaks(uri)) != null;
    }
}

