/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import javax.xml.namespace.QName;

/**
 * Element Node represents a node in a document. 
 * 
 * @author sleeloy
 * @author Ali Mehregani
 */
public class ElementNode extends TypeNode
{
	/**
	 * The name of the element
	 */
	private String name;

	/**
	 * The element location
	 */
	private ElementLocation location;
	
	/**
	 * Set if this element node refers to a global element declaration
	 */
	private QName ref;
	
	
	public ElementNode()
	{
	}

	public ElementNode(String name, String filePath, int line, int column)
	{
		super();
		this.name = name;
		location = new ElementLocation(filePath, line, column);
	}


	/**
	 * Returns the name of the element
	 * 
	 * @return the name of the element
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * Sets the name of the element
	 * 
	 * @param name
	 *            name of the element
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * @return the location
	 */
	public ElementLocation getLocation()
	{
		return location;
	}

	/**
	 * @param location the location to set
	 */
	public void setLocation(ElementLocation location)
	{
		this.location = location;
	}

	/**
	 * @return the ref
	 */
	public QName getRef()
	{
		return ref;
	}

	/**
	 * @param ref the ref to set
	 */
	public void setRef(QName ref)
	{
		this.ref = ref;
	}
		
}
