/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.repository.resource;

import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLDocument;
import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLDocumentFragment;
import org.w3c.dom.NodeList;

/**
 * The file system representation of an SML fragment.
 * 
 * @author Ali Mehregani
 */
public class SMLDocumentFragment implements ISMLDocumentFragment
{
	/**
	 * The parent document
	 */
	private ISMLDocument parentDocument;
	
	/**
	 * The node list representing the fragment
	 */
	private NodeList nodeList;
	
	/**
	 * @see org.eclipse.cosmos.rm.provisional.repository.resource.ISMLDocumentFragment#getParentDocument()
	 */
	public ISMLDocument getParentDocument()
	{
		return parentDocument;
	}

	public void setParentDocument(ISMLDocument parentDocument)
	{
		this.parentDocument = parentDocument;
	}
	
	
	/**
	 * @see org.eclipse.cosmos.rm.provisional.repository.resource.ISMLDocumentFragment#getNodeList()
	 */
	public NodeList getNodeList()
	{
		return nodeList;
	}
	
	public void setNodeList(NodeList nodeList)
	{
		this.nodeList = nodeList;
	}
}
