/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact.AdditionalContentImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact.ArtifactImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact.ArtifactOutputVariable;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact.StringSubstitutionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.AdditionalContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.ArtifactFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.StringSubstitution;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ArtifactFactoryImpl
implements ArtifactFactory {
    private SPISessionImpl session;
    private static final String SUBSTITUTION_TYPE = "sdd-dd:SubstitutionType";

    public ArtifactFactoryImpl(SPISessionImpl session) {
        this.session = session;
    }

    public AdditionalContent createAdditionalContent(String contentReference) {
        this.session.testParameter(contentReference, 1, null);
        Element additionalContentElement = this.session.createDeploymentElement("AdditionalContent");
        additionalContentElement.setAttribute("contentRef", contentReference);
        return new AdditionalContentImpl(additionalContentElement, this.session);
    }

    public Artifact createInstallArtifact() {
        return this.createArtifact("InstallArtifact");
    }

    public Artifact createUninstallArtifact() {
        return this.createArtifact("UninstallArtifact");
    }

    public Artifact createUndoArtifact() {
        return this.createArtifact("UndoArtifact");
    }

    public Artifact createConfigArtifact() {
        return this.createArtifact("ConfigArtifact");
    }

    public Artifact createUpdateArtifact() {
        return this.createArtifact("UpdateArtifact");
    }

    public Artifact createRepairArtifact() {
        return this.createArtifact("RepairArtifact");
    }

    private Artifact createArtifact(String elementName) {
        Element artifactElement = this.session.createDeploymentElement(elementName);
        return new ArtifactImpl(artifactElement, this.session);
    }

    public ArtifactOutputVariable createArtifactOutputVariable(String outputVariableID, String artifactParameter) {
        this.session.testParameter(outputVariableID, 1, null);
        this.session.testParameter(artifactParameter, 2, null);
        return new ArtifactOutputVariable(outputVariableID, artifactParameter);
    }

    public StringSubstitution createStringSubstitution(String pattern, String value) {
        this.session.testParameter(pattern, 1, null);
        this.session.testParameter(value, 2, null);
        Element stElement = this.session.createDeploymentElement("Substitution");
        Element patterElement = this.session.createDeploymentElement("Pattern");
        patterElement.setTextContent(pattern);
        Element valueElement = this.session.createDeploymentElement("Value");
        valueElement.setTextContent(value);
        this.session.insertNode((Node)stElement, (Node)patterElement, SUBSTITUTION_TYPE);
        this.session.insertNode((Node)stElement, (Node)valueElement, SUBSTITUTION_TYPE);
        return new StringSubstitutionImpl(stElement, this.session);
    }
}

