/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Identity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ReferencedPackage;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.BooleanParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariableExpression;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ParameterGroup;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ResourceProperty;
import org.w3c.dom.Element;

public class CompositeUnit_Test
extends TestCase {
    CompositeUnit unit;
    CompositeUnit clonedUnit;
    Element element;
    SPISessionImpl session;

    public CompositeUnit_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.unit = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeUnit("unitID");
        CompositeUnit cu1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeUnit("cu1ID");
        CompositeUnit cu2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeUnit("cu2ID");
        this.unit.setCompositeUnits((Collection<CompositeUnit>)Arrays.asList(cu1, cu2));
        Condition condition = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        condition.setDisplayName(new TranslatableString("conName", "conNameKey"));
        this.unit.setCondition(condition);
        Condition con1 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con1.setDisplayName(new TranslatableString("con1Name", "con1NameKey"));
        ConditionalDerivedVariableExpression exp1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp1Expression", con1);
        Condition con2 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con2.setDisplayName(new TranslatableString("con2Name", "con2NameKey"));
        ConditionalDerivedVariableExpression exp2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp2Expression", con2);
        ConditionalDerivedVariable var1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariable("var1ID", (Collection<ConditionalDerivedVariableExpression>)Arrays.asList(exp1, exp2));
        Condition con3 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con3.setDisplayName(new TranslatableString("con3Name", "con3NameKey"));
        ConditionalDerivedVariableExpression exp3 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp3Expression", con3);
        Condition con4 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con4.setDisplayName(new TranslatableString("con4Name", "con4NameKey"));
        ConditionalDerivedVariableExpression exp4 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp4Expression", con4);
        ConditionalDerivedVariable var2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariable("var2ID", (Collection<ConditionalDerivedVariableExpression>)Arrays.asList(exp3, exp4));
        this.unit.setConditionalDerivedVariables((Collection<ConditionalDerivedVariable>)Arrays.asList(var1, var2));
        Artifact art1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createConfigArtifact();
        art1.setContentReference("art1ContentRef");
        ConfigurationUnit cfg1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConfigurationUnit("cfg1ID", "cfg1ResourceRef", art1);
        Artifact art2 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createConfigArtifact();
        art2.setContentReference("art2ContentRef");
        ConfigurationUnit cfg2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConfigurationUnit("cfg2ID", "cfg2ResourceRef", art2);
        this.unit.setConfigurationUnits((Collection<ConfigurationUnit>)Arrays.asList(cfg1, cfg2));
        ReferencedPackage package1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedPackage("package1Ref", "package1ID");
        ReferencedPackage package2 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedPackage("package2Ref", "package2ID");
        this.unit.setContainedPackages((Collection<ReferencedPackage>)Arrays.asList(package1, package2));
        DerivedVariable dvar1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createDerivedVariable("dvar1ID", "dvar1Expression");
        DerivedVariable dvar2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createDerivedVariable("dvar2ID", "dvar2Expression");
        this.unit.setDerivedVariables((Collection<DerivedVariable>)Arrays.asList(dvar1, dvar2));
        Identity identity = SPISession.DEFAULT_INSTANCE.createBaseFactory().createIdentity(new TranslatableString("name", "nameKey"));
        this.unit.setIdentityData(identity);
        Artifact iuArt1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        iuArt1.setContentReference("iuArt1ContentRef");
        InstallableUnit iu1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createInstallableUnit("iu1ID", "iu1ResourceRef", iuArt1, 0);
        Artifact iuArt2 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        iuArt2.setContentReference("iuArt2ContentRef");
        InstallableUnit iu2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createInstallableUnit("iu2ID", "iu2ResourceRef", iuArt2, 0);
        this.unit.setInstallableUnits((Collection<InstallableUnit>)Arrays.asList(iu1, iu2));
        BooleanParameter param1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param1ID");
        BooleanParameter param2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param2ID");
        ParameterGroup group1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createParameterGroup();
        group1.setBooleanParameters((Collection<BooleanParameter>)Arrays.asList(param1, param2));
        BooleanParameter param3 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param3ID");
        BooleanParameter param4 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param4ID");
        ParameterGroup group2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createParameterGroup();
        group2.setBooleanParameters((Collection<BooleanParameter>)Arrays.asList(param3, param4));
        this.unit.setParameterGroups((Collection<ParameterGroup>)Arrays.asList(group1, group2));
        Requirement req1 = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRequirement("req1ID");
        Requirement req2 = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRequirement("req2ID");
        this.unit.setRequirements((Collection<Requirement>)Arrays.asList(req1, req2));
        ResourceProperty prop1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createResourceProperty("prop1ID", "prop1Ref");
        ResourceProperty prop2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createResourceProperty("prop2ID", "prop2Ref");
        this.unit.setResourceProperties((Collection<ResourceProperty>)Arrays.asList(prop1, prop2));
        this.clonedUnit = (CompositeUnit)this.unit.clone();
        this.element = ((SPIDataObject)((Object)this.unit)).getElement();
        this.session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings() {
        Properties props = ((SPIDataObject)((Object)this.unit)).getTranslatableStrings();
        CompositeUnit_Test.assertEquals((int)6, (int)props.size());
        CompositeUnit_Test.assertEquals((String)"name", (String)props.getProperty("nameKey"));
        CompositeUnit_Test.assertEquals((String)"conName", (String)props.getProperty("conNameKey"));
        CompositeUnit_Test.assertEquals((String)"con1Name", (String)props.getProperty("con1NameKey"));
        CompositeUnit_Test.assertEquals((String)"con2Name", (String)props.getProperty("con2NameKey"));
        CompositeUnit_Test.assertEquals((String)"con3Name", (String)props.getProperty("con3NameKey"));
        CompositeUnit_Test.assertEquals((String)"con4Name", (String)props.getProperty("con4NameKey"));
    }

    public void testGetCompositeUnits() {
        CompositeUnit_Test.assertEquals((int)2, (int)this.unit.getCompositeUnits().size());
        CompositeUnit_Test.assertEquals((String)"cu1ID", (String)this.unit.getCompositeUnits().toArray(new CompositeUnit[0])[0].getContentUnitID());
        CompositeUnit_Test.assertEquals((String)"cu2ID", (String)this.unit.getCompositeUnits().toArray(new CompositeUnit[0])[1].getContentUnitID());
        CompositeUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getCompositeUnits().size());
        CompositeUnit_Test.assertEquals((String)"cu1ID", (String)this.clonedUnit.getCompositeUnits().toArray(new CompositeUnit[0])[0].getContentUnitID());
        CompositeUnit_Test.assertEquals((String)"cu2ID", (String)this.clonedUnit.getCompositeUnits().toArray(new CompositeUnit[0])[1].getContentUnitID());
        CompositeUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "CompositeUnit").size());
        CompositeUnit_Test.assertEquals((String)"cu1ID", (String)this.session.getChildren(this.element, "CompositeUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"cu2ID", (String)this.session.getChildren(this.element, "CompositeUnit").toArray(new Element[0])[1].getAttribute("id"));
    }

    public void testGetCondition() {
        CompositeUnit_Test.assertEquals((String)"conName", (String)this.unit.getCondition().getDisplayName().getValue());
        CompositeUnit_Test.assertEquals((String)"conNameKey", (String)this.unit.getCondition().getDisplayName().getTranslationKey());
        CompositeUnit_Test.assertEquals((String)"conName", (String)this.clonedUnit.getCondition().getDisplayName().getValue());
        CompositeUnit_Test.assertEquals((String)"conNameKey", (String)this.clonedUnit.getCondition().getDisplayName().getTranslationKey());
        CompositeUnit_Test.assertEquals((String)"conName", (String)this.session.getChildren(this.session.getChildren(this.element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeUnit_Test.assertEquals((String)"conNameKey", (String)this.session.getChildren(this.session.getChildren(this.element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetConfigurationUnits() {
        CompositeUnit_Test.assertEquals((int)2, (int)this.unit.getConfigurationUnits().size());
        CompositeUnit_Test.assertEquals((String)"cfg1ID", (String)this.unit.getConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getContentUnitID());
        CompositeUnit_Test.assertEquals((String)"cfg1ResourceRef", (String)this.unit.getConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getTargetResourceReference());
        CompositeUnit_Test.assertEquals((String)"art1ContentRef", (String)this.unit.getConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getConfigurationArtifact().getContentReference());
        CompositeUnit_Test.assertEquals((String)"cfg2ID", (String)this.unit.getConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getContentUnitID());
        CompositeUnit_Test.assertEquals((String)"cfg2ResourceRef", (String)this.unit.getConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getTargetResourceReference());
        CompositeUnit_Test.assertEquals((String)"art2ContentRef", (String)this.unit.getConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getConfigurationArtifact().getContentReference());
        CompositeUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getConfigurationUnits().size());
        CompositeUnit_Test.assertEquals((String)"cfg1ID", (String)this.clonedUnit.getConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getContentUnitID());
        CompositeUnit_Test.assertEquals((String)"cfg1ResourceRef", (String)this.clonedUnit.getConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getTargetResourceReference());
        CompositeUnit_Test.assertEquals((String)"art1ContentRef", (String)this.clonedUnit.getConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getConfigurationArtifact().getContentReference());
        CompositeUnit_Test.assertEquals((String)"cfg2ID", (String)this.clonedUnit.getConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getContentUnitID());
        CompositeUnit_Test.assertEquals((String)"cfg2ResourceRef", (String)this.clonedUnit.getConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getTargetResourceReference());
        CompositeUnit_Test.assertEquals((String)"art2ContentRef", (String)this.clonedUnit.getConfigurationUnits().toArray(new ConfigurationUnit[0])[1].getConfigurationArtifact().getContentReference());
        CompositeUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "ConfigurationUnit").size());
        CompositeUnit_Test.assertEquals((String)"cfg1ID", (String)this.session.getChildren(this.element, "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"cfg1ResourceRef", (String)this.session.getChildren(this.element, "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        CompositeUnit_Test.assertEquals((String)"art1ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "ConfigurationUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "ConfigArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
        CompositeUnit_Test.assertEquals((String)"cfg2ID", (String)this.session.getChildren(this.element, "ConfigurationUnit").toArray(new Element[0])[1].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"cfg2ResourceRef", (String)this.session.getChildren(this.element, "ConfigurationUnit").toArray(new Element[0])[1].getAttribute("targetResourceRef"));
        CompositeUnit_Test.assertEquals((String)"art2ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "ConfigurationUnit").toArray(new Element[0])[1], "Artifacts").toArray(new Element[0])[0], "ConfigArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testGetContainedPackages() {
        CompositeUnit_Test.assertEquals((int)2, (int)this.unit.getContainedPackages().size());
        CompositeUnit_Test.assertEquals((String)"package1ID", (String)this.unit.getContainedPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeUnit_Test.assertEquals((String)"package1Ref", (String)this.unit.getContainedPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeUnit_Test.assertEquals((String)"package2ID", (String)this.unit.getContainedPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        CompositeUnit_Test.assertEquals((String)"package2Ref", (String)this.unit.getContainedPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        CompositeUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getContainedPackages().size());
        CompositeUnit_Test.assertEquals((String)"package1ID", (String)this.clonedUnit.getContainedPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeUnit_Test.assertEquals((String)"package1Ref", (String)this.clonedUnit.getContainedPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeUnit_Test.assertEquals((String)"package2ID", (String)this.clonedUnit.getContainedPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        CompositeUnit_Test.assertEquals((String)"package2Ref", (String)this.clonedUnit.getContainedPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        CompositeUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "ContainedPackage").size());
        CompositeUnit_Test.assertEquals((String)"package1ID", (String)this.session.getChildren(this.element, "ContainedPackage").toArray(new Element[0])[0].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"package1Ref", (String)this.session.getChildren(this.element, "ContainedPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
        CompositeUnit_Test.assertEquals((String)"package2ID", (String)this.session.getChildren(this.element, "ContainedPackage").toArray(new Element[0])[1].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"package2Ref", (String)this.session.getChildren(this.element, "ContainedPackage").toArray(new Element[0])[1].getAttribute("contentRef"));
    }

    public void testGetInstallableUnits() {
        CompositeUnit_Test.assertEquals((int)2, (int)this.unit.getInstallableUnits().size());
        CompositeUnit_Test.assertEquals((String)"iu1ID", (String)this.unit.getInstallableUnits().toArray(new InstallableUnit[0])[0].getContentUnitID());
        CompositeUnit_Test.assertEquals((String)"iu1ResourceRef", (String)this.unit.getInstallableUnits().toArray(new InstallableUnit[0])[0].getTargetResourceReference());
        CompositeUnit_Test.assertEquals((String)"iuArt1ContentRef", (String)this.unit.getInstallableUnits().toArray(new InstallableUnit[0])[0].getInstallArtifact().getContentReference());
        CompositeUnit_Test.assertEquals((String)"iu2ID", (String)this.unit.getInstallableUnits().toArray(new InstallableUnit[0])[1].getContentUnitID());
        CompositeUnit_Test.assertEquals((String)"iu2ResourceRef", (String)this.unit.getInstallableUnits().toArray(new InstallableUnit[0])[1].getTargetResourceReference());
        CompositeUnit_Test.assertEquals((String)"iuArt2ContentRef", (String)this.unit.getInstallableUnits().toArray(new InstallableUnit[0])[1].getInstallArtifact().getContentReference());
        CompositeUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getInstallableUnits().size());
        CompositeUnit_Test.assertEquals((String)"iu1ID", (String)this.clonedUnit.getInstallableUnits().toArray(new InstallableUnit[0])[0].getContentUnitID());
        CompositeUnit_Test.assertEquals((String)"iu1ResourceRef", (String)this.clonedUnit.getInstallableUnits().toArray(new InstallableUnit[0])[0].getTargetResourceReference());
        CompositeUnit_Test.assertEquals((String)"iuArt1ContentRef", (String)this.clonedUnit.getInstallableUnits().toArray(new InstallableUnit[0])[0].getInstallArtifact().getContentReference());
        CompositeUnit_Test.assertEquals((String)"iu2ID", (String)this.clonedUnit.getInstallableUnits().toArray(new InstallableUnit[0])[1].getContentUnitID());
        CompositeUnit_Test.assertEquals((String)"iu2ResourceRef", (String)this.clonedUnit.getInstallableUnits().toArray(new InstallableUnit[0])[1].getTargetResourceReference());
        CompositeUnit_Test.assertEquals((String)"iuArt2ContentRef", (String)this.clonedUnit.getInstallableUnits().toArray(new InstallableUnit[0])[1].getInstallArtifact().getContentReference());
        CompositeUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "InstallableUnit").size());
        CompositeUnit_Test.assertEquals((String)"iu1ID", (String)this.session.getChildren(this.element, "InstallableUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"iu1ResourceRef", (String)this.session.getChildren(this.element, "InstallableUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        CompositeUnit_Test.assertEquals((String)"iuArt1ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "InstallableUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
        CompositeUnit_Test.assertEquals((String)"iu2ID", (String)this.session.getChildren(this.element, "InstallableUnit").toArray(new Element[0])[1].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"iu2ResourceRef", (String)this.session.getChildren(this.element, "InstallableUnit").toArray(new Element[0])[1].getAttribute("targetResourceRef"));
        CompositeUnit_Test.assertEquals((String)"iuArt2ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "InstallableUnit").toArray(new Element[0])[1], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testGetRequirements() {
        CompositeUnit_Test.assertEquals((int)2, (int)this.unit.getRequirements().size());
        CompositeUnit_Test.assertEquals((String)"req1ID", (String)this.unit.getRequirements().toArray(new Requirement[0])[0].getRequirementID());
        CompositeUnit_Test.assertEquals((String)"req2ID", (String)this.unit.getRequirements().toArray(new Requirement[0])[1].getRequirementID());
        CompositeUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getRequirements().size());
        CompositeUnit_Test.assertEquals((String)"req1ID", (String)this.clonedUnit.getRequirements().toArray(new Requirement[0])[0].getRequirementID());
        CompositeUnit_Test.assertEquals((String)"req2ID", (String)this.clonedUnit.getRequirements().toArray(new Requirement[0])[1].getRequirementID());
        CompositeUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "Requirements").toArray(new Element[0])[0], "Requirement").size());
        CompositeUnit_Test.assertEquals((String)"req1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Requirements").toArray(new Element[0])[0], "Requirement").toArray(new Element[0])[0].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"req2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Requirements").toArray(new Element[0])[0], "Requirement").toArray(new Element[0])[1].getAttribute("id"));
    }

    public void testGetContentUnitID() {
        CompositeUnit_Test.assertEquals((String)"unitID", (String)this.unit.getContentUnitID());
        CompositeUnit_Test.assertEquals((String)"unitID", (String)this.clonedUnit.getContentUnitID());
        CompositeUnit_Test.assertEquals((String)"unitID", (String)this.element.getAttribute("id"));
    }

    public void testGetIdentityData() {
        CompositeUnit_Test.assertEquals((String)"name", (String)this.unit.getIdentityData().getName().getValue());
        CompositeUnit_Test.assertEquals((String)"nameKey", (String)this.unit.getIdentityData().getName().getTranslationKey());
        CompositeUnit_Test.assertEquals((String)"name", (String)this.clonedUnit.getIdentityData().getName().getValue());
        CompositeUnit_Test.assertEquals((String)"nameKey", (String)this.clonedUnit.getIdentityData().getName().getTranslationKey());
        CompositeUnit_Test.assertEquals((String)"name", (String)this.session.getChildren(this.session.getChildren(this.element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
        CompositeUnit_Test.assertEquals((String)"nameKey", (String)this.session.getChildren(this.session.getChildren(this.element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetDerivedVariables() {
        CompositeUnit_Test.assertEquals((int)2, (int)this.unit.getDerivedVariables().size());
        CompositeUnit_Test.assertEquals((String)"dvar1ID", (String)this.unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        CompositeUnit_Test.assertEquals((String)"dvar1Expression", (String)this.unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getExpression());
        CompositeUnit_Test.assertEquals((String)"dvar2ID", (String)this.unit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        CompositeUnit_Test.assertEquals((String)"dvar2Expression", (String)this.unit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getExpression());
        CompositeUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getDerivedVariables().size());
        CompositeUnit_Test.assertEquals((String)"dvar1ID", (String)this.clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        CompositeUnit_Test.assertEquals((String)"dvar1Expression", (String)this.clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getExpression());
        CompositeUnit_Test.assertEquals((String)"dvar2ID", (String)this.clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        CompositeUnit_Test.assertEquals((String)"dvar2Expression", (String)this.clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getExpression());
        CompositeUnit_Test.assertEquals((int)4, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        CompositeUnit_Test.assertEquals((String)"dvar1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"dvar1Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeUnit_Test.assertEquals((String)"dvar2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[3].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"dvar2Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[3], "Expression").toArray(new Element[0])[0].getTextContent());
    }

    public void testGetConditionalDerivedVariables() {
        CompositeUnit_Test.assertEquals((int)2, (int)this.unit.getConditionalDerivedVariables().size());
        CompositeUnit_Test.assertEquals((String)"var1ID", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getVariableID());
        CompositeUnit_Test.assertEquals((String)"exp1Expression", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        CompositeUnit_Test.assertEquals((String)"con1Name", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        CompositeUnit_Test.assertEquals((String)"con1NameKey", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        CompositeUnit_Test.assertEquals((String)"exp2Expression", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        CompositeUnit_Test.assertEquals((String)"con2Name", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        CompositeUnit_Test.assertEquals((String)"con2NameKey", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());
        CompositeUnit_Test.assertEquals((String)"var2ID", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getVariableID());
        CompositeUnit_Test.assertEquals((String)"exp3Expression", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        CompositeUnit_Test.assertEquals((String)"con3Name", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        CompositeUnit_Test.assertEquals((String)"con3NameKey", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        CompositeUnit_Test.assertEquals((String)"exp4Expression", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        CompositeUnit_Test.assertEquals((String)"con4Name", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        CompositeUnit_Test.assertEquals((String)"con4NameKey", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());
        CompositeUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getConditionalDerivedVariables().size());
        CompositeUnit_Test.assertEquals((String)"var1ID", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getVariableID());
        CompositeUnit_Test.assertEquals((String)"exp1Expression", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        CompositeUnit_Test.assertEquals((String)"con1Name", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        CompositeUnit_Test.assertEquals((String)"con1NameKey", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        CompositeUnit_Test.assertEquals((String)"exp2Expression", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        CompositeUnit_Test.assertEquals((String)"con2Name", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        CompositeUnit_Test.assertEquals((String)"con2NameKey", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());
        CompositeUnit_Test.assertEquals((String)"var2ID", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getVariableID());
        CompositeUnit_Test.assertEquals((String)"exp3Expression", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        CompositeUnit_Test.assertEquals((String)"con3Name", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        CompositeUnit_Test.assertEquals((String)"con3NameKey", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        CompositeUnit_Test.assertEquals((String)"exp4Expression", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        CompositeUnit_Test.assertEquals((String)"con4Name", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        CompositeUnit_Test.assertEquals((String)"con4NameKey", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());
        CompositeUnit_Test.assertEquals((int)4, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        CompositeUnit_Test.assertEquals((String)"var1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"exp1Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeUnit_Test.assertEquals((String)"con1Name", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeUnit_Test.assertEquals((String)"con1NameKey", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
        CompositeUnit_Test.assertEquals((String)"exp2Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[1], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeUnit_Test.assertEquals((String)"con2Name", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeUnit_Test.assertEquals((String)"con2NameKey", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
        CompositeUnit_Test.assertEquals((String)"var2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"exp3Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeUnit_Test.assertEquals((String)"con3Name", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeUnit_Test.assertEquals((String)"con3NameKey", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
        CompositeUnit_Test.assertEquals((String)"exp4Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[1], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeUnit_Test.assertEquals((String)"con4Name", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeUnit_Test.assertEquals((String)"con4NameKey", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetResourceProperties() {
        CompositeUnit_Test.assertEquals((int)2, (int)this.unit.getResourceProperties().size());
        CompositeUnit_Test.assertEquals((String)"prop1ID", (String)this.unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getVariableID());
        CompositeUnit_Test.assertEquals((String)"prop1Ref", (String)this.unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getResourceReference());
        CompositeUnit_Test.assertEquals((String)"prop2ID", (String)this.unit.getResourceProperties().toArray(new ResourceProperty[0])[1].getVariableID());
        CompositeUnit_Test.assertEquals((String)"prop2Ref", (String)this.unit.getResourceProperties().toArray(new ResourceProperty[0])[1].getResourceReference());
        CompositeUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getResourceProperties().size());
        CompositeUnit_Test.assertEquals((String)"prop1ID", (String)this.clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[0].getVariableID());
        CompositeUnit_Test.assertEquals((String)"prop1Ref", (String)this.clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[0].getResourceReference());
        CompositeUnit_Test.assertEquals((String)"prop2ID", (String)this.clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[1].getVariableID());
        CompositeUnit_Test.assertEquals((String)"prop2Ref", (String)this.clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[1].getResourceReference());
        CompositeUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").size());
        CompositeUnit_Test.assertEquals((String)"prop1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"prop1Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("resourceRef"));
        CompositeUnit_Test.assertEquals((String)"prop2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[1].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"prop2Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[1].getAttribute("resourceRef"));
    }

    public void testGetParameterGroups() {
        CompositeUnit_Test.assertEquals((int)2, (int)this.unit.getParameterGroups().size());
        CompositeUnit_Test.assertEquals((int)2, (int)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().size());
        CompositeUnit_Test.assertEquals((int)2, (int)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().size());
        CompositeUnit_Test.assertEquals((String)"param1ID", (String)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        CompositeUnit_Test.assertEquals((String)"param2ID", (String)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());
        CompositeUnit_Test.assertEquals((String)"param3ID", (String)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        CompositeUnit_Test.assertEquals((String)"param4ID", (String)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());
        CompositeUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getParameterGroups().size());
        CompositeUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().size());
        CompositeUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().size());
        CompositeUnit_Test.assertEquals((String)"param1ID", (String)this.clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        CompositeUnit_Test.assertEquals((String)"param2ID", (String)this.clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());
        CompositeUnit_Test.assertEquals((String)"param3ID", (String)this.clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        CompositeUnit_Test.assertEquals((String)"param4ID", (String)this.clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());
        CompositeUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").size());
        CompositeUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").size());
        CompositeUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[1], "BooleanParameter").size());
        CompositeUnit_Test.assertEquals((String)"param1ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").toArray(new Element[0])[0].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"param2ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").toArray(new Element[0])[1].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"param3ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[1], "BooleanParameter").toArray(new Element[0])[0].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"param4ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[1], "BooleanParameter").toArray(new Element[0])[1].getAttribute("id"));
    }

    public void testSetCompositeUnits() {
        CompositeUnit cu1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeUnit("cu3ID");
        this.unit.setCompositeUnits((Collection<CompositeUnit>)Arrays.asList(cu1));
        CompositeUnit_Test.assertEquals((int)1, (int)this.unit.getCompositeUnits().size());
        CompositeUnit_Test.assertEquals((String)"cu3ID", (String)this.unit.getCompositeUnits().toArray(new CompositeUnit[0])[0].getContentUnitID());
        CompositeUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "CompositeUnit").size());
        CompositeUnit_Test.assertEquals((String)"cu3ID", (String)this.session.getChildren(this.element, "CompositeUnit").toArray(new Element[0])[0].getAttribute("id"));
    }

    public void testSetCondition() {
        Condition condition = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        condition.setDisplayName(new TranslatableString("differentName", "differentNameKey"));
        this.unit.setCondition(condition);
        CompositeUnit_Test.assertEquals((String)"differentName", (String)this.unit.getCondition().getDisplayName().getValue());
        CompositeUnit_Test.assertEquals((String)"differentNameKey", (String)this.unit.getCondition().getDisplayName().getTranslationKey());
        CompositeUnit_Test.assertEquals((String)"differentName", (String)this.session.getChildren(this.session.getChildren(this.element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeUnit_Test.assertEquals((String)"differentNameKey", (String)this.session.getChildren(this.session.getChildren(this.element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetConfigurationUnits() {
        Artifact art1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createConfigArtifact();
        art1.setContentReference("art3ContentRef");
        ConfigurationUnit cfg1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConfigurationUnit("cfg3ID", "cfg3ResourceRef", art1);
        this.unit.setConfigurationUnits((Collection<ConfigurationUnit>)Arrays.asList(cfg1));
        CompositeUnit_Test.assertEquals((int)1, (int)this.unit.getConfigurationUnits().size());
        CompositeUnit_Test.assertEquals((String)"cfg3ID", (String)this.unit.getConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getContentUnitID());
        CompositeUnit_Test.assertEquals((String)"cfg3ResourceRef", (String)this.unit.getConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getTargetResourceReference());
        CompositeUnit_Test.assertEquals((String)"art3ContentRef", (String)this.unit.getConfigurationUnits().toArray(new ConfigurationUnit[0])[0].getConfigurationArtifact().getContentReference());
        CompositeUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "ConfigurationUnit").size());
        CompositeUnit_Test.assertEquals((String)"cfg3ID", (String)this.session.getChildren(this.element, "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"cfg3ResourceRef", (String)this.session.getChildren(this.element, "ConfigurationUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        CompositeUnit_Test.assertEquals((String)"art3ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "ConfigurationUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "ConfigArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetContainedPackages() {
        ReferencedPackage package1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedPackage("package3Ref", "package3ID");
        this.unit.setContainedPackages((Collection<ReferencedPackage>)Arrays.asList(package1));
        CompositeUnit_Test.assertEquals((int)1, (int)this.unit.getContainedPackages().size());
        CompositeUnit_Test.assertEquals((String)"package3ID", (String)this.unit.getContainedPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeUnit_Test.assertEquals((String)"package3Ref", (String)this.unit.getContainedPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "ContainedPackage").size());
        CompositeUnit_Test.assertEquals((String)"package3ID", (String)this.session.getChildren(this.element, "ContainedPackage").toArray(new Element[0])[0].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"package3Ref", (String)this.session.getChildren(this.element, "ContainedPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetInstallableUnits() {
        Artifact iuArt1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        iuArt1.setContentReference("iuArt3ContentRef");
        InstallableUnit iu1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createInstallableUnit("iu3ID", "iu3ResourceRef", iuArt1, 0);
        this.unit.setInstallableUnits((Collection<InstallableUnit>)Arrays.asList(iu1));
        CompositeUnit_Test.assertEquals((int)1, (int)this.unit.getInstallableUnits().size());
        CompositeUnit_Test.assertEquals((String)"iu3ID", (String)this.unit.getInstallableUnits().toArray(new InstallableUnit[0])[0].getContentUnitID());
        CompositeUnit_Test.assertEquals((String)"iu3ResourceRef", (String)this.unit.getInstallableUnits().toArray(new InstallableUnit[0])[0].getTargetResourceReference());
        CompositeUnit_Test.assertEquals((String)"iuArt3ContentRef", (String)this.unit.getInstallableUnits().toArray(new InstallableUnit[0])[0].getInstallArtifact().getContentReference());
        CompositeUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "InstallableUnit").size());
        CompositeUnit_Test.assertEquals((String)"iu3ID", (String)this.session.getChildren(this.element, "InstallableUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"iu3ResourceRef", (String)this.session.getChildren(this.element, "InstallableUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        CompositeUnit_Test.assertEquals((String)"iuArt3ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "InstallableUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetRequirements() {
        Requirement req1 = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRequirement("req3ID");
        this.unit.setRequirements((Collection<Requirement>)Arrays.asList(req1));
        CompositeUnit_Test.assertEquals((int)1, (int)this.unit.getRequirements().size());
        CompositeUnit_Test.assertEquals((String)"req3ID", (String)this.unit.getRequirements().toArray(new Requirement[0])[0].getRequirementID());
        CompositeUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "Requirements").toArray(new Element[0])[0], "Requirement").size());
        CompositeUnit_Test.assertEquals((String)"req3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Requirements").toArray(new Element[0])[0], "Requirement").toArray(new Element[0])[0].getAttribute("id"));
    }

    public void testSetContentUnitID() {
        this.unit.setContentUnitID("differentID");
        CompositeUnit_Test.assertEquals((String)"differentID", (String)this.unit.getContentUnitID());
        CompositeUnit_Test.assertEquals((String)"differentID", (String)this.element.getAttribute("id"));
    }

    public void testSetIdentityData() {
        Identity identity = SPISession.DEFAULT_INSTANCE.createBaseFactory().createIdentity(new TranslatableString("differentName", "differentNameKey"));
        this.unit.setIdentityData(identity);
        CompositeUnit_Test.assertEquals((String)"differentName", (String)this.unit.getIdentityData().getName().getValue());
        CompositeUnit_Test.assertEquals((String)"differentNameKey", (String)this.unit.getIdentityData().getName().getTranslationKey());
        CompositeUnit_Test.assertEquals((String)"differentName", (String)this.session.getChildren(this.session.getChildren(this.element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
        CompositeUnit_Test.assertEquals((String)"differentNameKey", (String)this.session.getChildren(this.session.getChildren(this.element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetResourceProperties() {
        ResourceProperty prop1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createResourceProperty("prop3ID", "prop3Ref");
        this.unit.setResourceProperties((Collection<ResourceProperty>)Arrays.asList(prop1));
        CompositeUnit_Test.assertEquals((int)1, (int)this.unit.getResourceProperties().size());
        CompositeUnit_Test.assertEquals((String)"prop3ID", (String)this.unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getVariableID());
        CompositeUnit_Test.assertEquals((String)"prop3Ref", (String)this.unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getResourceReference());
        CompositeUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").size());
        CompositeUnit_Test.assertEquals((String)"prop3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"prop3Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("resourceRef"));
    }

    public void testSetDerivedVariables() {
        DerivedVariable dvar1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createDerivedVariable("dvar3ID", "dvar3Expression");
        this.unit.setDerivedVariables((Collection<DerivedVariable>)Arrays.asList(dvar1));
        CompositeUnit_Test.assertEquals((int)1, (int)this.unit.getDerivedVariables().size());
        CompositeUnit_Test.assertEquals((String)"dvar3ID", (String)this.unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        CompositeUnit_Test.assertEquals((String)"dvar3Expression", (String)this.unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getExpression());
        CompositeUnit_Test.assertEquals((int)3, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        CompositeUnit_Test.assertEquals((String)"dvar3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"dvar3Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "Expression").toArray(new Element[0])[0].getTextContent());
    }

    public void testSetConditionalDerivedVariables() {
        Condition con1 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con1.setDisplayName(new TranslatableString("con5Name", "con5NameKey"));
        ConditionalDerivedVariableExpression exp1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp3Expression", con1);
        ConditionalDerivedVariable var1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariable("var3ID", (Collection<ConditionalDerivedVariableExpression>)Arrays.asList(exp1));
        this.unit.setConditionalDerivedVariables((Collection<ConditionalDerivedVariable>)Arrays.asList(var1));
        CompositeUnit_Test.assertEquals((int)1, (int)this.unit.getConditionalDerivedVariables().size());
        CompositeUnit_Test.assertEquals((String)"var3ID", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getVariableID());
        CompositeUnit_Test.assertEquals((String)"exp3Expression", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        CompositeUnit_Test.assertEquals((String)"con5Name", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        CompositeUnit_Test.assertEquals((String)"con5NameKey", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        CompositeUnit_Test.assertEquals((int)3, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        CompositeUnit_Test.assertEquals((String)"var3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2].getAttribute("id"));
        CompositeUnit_Test.assertEquals((String)"exp3Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "ConditionalExpression").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeUnit_Test.assertEquals((String)"con5Name", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeUnit_Test.assertEquals((String)"con5NameKey", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetParameterGroups() {
        BooleanParameter param1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param5ID");
        ParameterGroup group1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createParameterGroup();
        group1.setBooleanParameters((Collection<BooleanParameter>)Arrays.asList(param1));
        this.unit.setParameterGroups((Collection<ParameterGroup>)Arrays.asList(group1));
        CompositeUnit_Test.assertEquals((int)1, (int)this.unit.getParameterGroups().size());
        CompositeUnit_Test.assertEquals((int)1, (int)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().size());
        CompositeUnit_Test.assertEquals((String)"param5ID", (String)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        CompositeUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").size());
        CompositeUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").size());
        CompositeUnit_Test.assertEquals((String)"param5ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").toArray(new Element[0])[0].getAttribute("id"));
    }
}

