/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescriptorImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.ResourceImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.CompositeInstallableImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ConfigurationUnitImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ContentUnitImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.InstallableUnitImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.LocalizationUnitImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeInstallable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ContentUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentDescriptorImpl
extends DescriptorImpl
implements DeploymentDescriptor {
    private static final String DEPLOYMENT_DESCRIPTOR_TYPE = "sdd-dd:DeploymentDescriptorType";
    private static final String TOPOLOGY_TYPE = "sdd-dd:TopologyType";

    public DeploymentDescriptorImpl(Document doc, SPISessionImpl session) {
        super(doc, session, DEPLOYMENT_DESCRIPTOR_TYPE);
    }

    @Override
    public ContentUnit getContentUnit() {
        ContentUnitImpl contentUnit = null;
        if (this.isSetElement("InstallableUnit")) {
            Element installableUnit = this.getChild("InstallableUnit");
            contentUnit = new InstallableUnitImpl(installableUnit, this.session);
        } else if (this.isSetElement("LocalizationUnit")) {
            Element localizationUnit = this.getChild("LocalizationUnit");
            contentUnit = new LocalizationUnitImpl(localizationUnit, this.session);
        } else if (this.isSetElement("ConfigurationUnit")) {
            Element configurationUnit = this.getChild("ConfigurationUnit");
            contentUnit = new ConfigurationUnitImpl(configurationUnit, this.session);
        }
        return contentUnit;
    }

    @Override
    public Collection<CompositeInstallable> getCompositeInstallables() {
        Collection<Element> composites = this.getChildren("CompositeInstallable");
        ArrayList<CompositeInstallable> compositeInstallables = new ArrayList<CompositeInstallable>();
        for (Element composite : composites) {
            compositeInstallables.add(new CompositeInstallableImpl(composite, this.session));
        }
        return compositeInstallables;
    }

    @Override
    public Collection<Resource> getResources() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.isSetElement("Topology")) {
            Element topology = this.getChild("Topology");
            Collection<Element> tmpList = this.session.getChildren(topology, "Resource");
            for (Element element : tmpList) {
                resources.add(new ResourceImpl(element, this.session));
            }
        }
        return resources;
    }

    @Override
    public void setResources(Collection<Resource> resources) {
        this.session.testParameter(resources, 1, null);
        if (resources == null) {
            this.unSetElement("Topology");
        } else {
            Element topology;
            if (!this.isSetElement("Topology")) {
                topology = this.session.createDeploymentElement("Topology");
                this.setContent(topology);
            }
            topology = this.getChild("Topology");
            for (Resource resource : resources) {
                if (resource == null) {
                    throw new InvalidInputException(1, 1);
                }
                this.session.insertNode((Node)topology, (SPIDataObject)((Object)resource), TOPOLOGY_TYPE);
            }
            this.unSetElement("Topology");
            this.setContent(topology);
        }
    }

    @Override
    public void setContentUnit(ContentUnit cu) {
        this.session.testParameter(cu, 1, null);
        this.unSetElement("InstallableUnit");
        this.unSetElement("ConfigurationUnit");
        this.unSetElement("LocalizationUnit");
        this.unSetElement("CompositeUnit");
        this.setContent((SPIDataObject)((Object)cu));
    }

    @Override
    public void setCompositeInstallables(Collection<CompositeInstallable> ci) {
        this.session.testParameter(ci, 1, null);
        if (ci == null) {
            this.unSetElement("CompositeInstallable");
        } else {
            this.removeContent(this.getChildren("CompositeInstallable", false));
            this.addContent(ci);
        }
    }

    @Override
    public String toString() {
        String summary = "Deployment Descriptor\n" + super.toString();
        summary = String.valueOf(summary) + "\nContent Unit\n------------------------------------\n";
        summary = String.valueOf(summary) + this.getContentUnit().toString();
        summary = String.valueOf(summary) + "\n\nTopology\n------------------------------------\n";
        Collection<Resource> topologyResources = this.getResources();
        for (Resource resource : topologyResources) {
            summary = String.valueOf(summary) + resource.toString();
        }
        return summary;
    }

    @Override
    public Object clone() {
        return new DeploymentDescriptorImpl((Document)this.document.cloneNode(true), this.session);
    }
}

