/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig;

/**
 * 
 * A XmlDsigFactory is used to create objects representing or directly
 * related to XML digest.
 * For details and examples, see {@link http://www.w3.org/TR/xmldsig-core}.
 */
public interface XmlDsigFactory {
	/**
	 * Creates a new digest method.
	 * 
	 * @param algorithm The algorithm to be used.
	 * @return A new digest method.
	 */
	DigestMethod createDigestMethod(String algorithm);
	
	/**
	 * Creates a new signature.
	 * 
	 * @return A new signature to be used.
	 */
	Signature createSignature();
}
